/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Pen;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import java.awt.Graphics2D;

public abstract class GraphicReportElement
extends ReportElement {
    public static final String FILL = "FILL";
    public static final String PEN = "PEN";
    public static final String DEFAULT_FILL = "Solid";
    public static final String DEFAULT_PEN = "Thin";
    private Pen pen = null;

    public GraphicReportElement(int x, int y, int width, int height) {
        super(x, y, Math.abs(width), Math.abs(height));
        this.setKey("graphic");
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        super.drawGraphicsElement(g, this.getGraphicElementPen(), zoom_factor, x_shift_origin, y_shift_origin);
    }

    public String getFill() {
        if (this.getPropertyValue(FILL) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("fill", DEFAULT_FILL, true);
        }
        return this.getStringValue(FILL, DEFAULT_FILL);
    }

    public void setFill(String fill) {
        this.setPropertyValue(FILL, fill);
    }

    public String getGraphicElementPen() {
        if (this.getPropertyValue(PEN) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("pen", DEFAULT_PEN, true);
        }
        return this.getStringValue(PEN, DEFAULT_PEN);
    }

    public void setGraphicElementPen(String graphicElementPen) {
        this.setPropertyValue(PEN, graphicElementPen);
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof GraphicReportElement && source instanceof GraphicReportElement) {
            destination.setPropertyValue(PEN, this.getPropertyValue(PEN));
            destination.setPropertyValue(FILL, this.getPropertyValue(FILL));
        }
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (style != null) {
            // empty if block
        }
    }

    public Pen getPen() {
        return this.pen;
    }

    public void setPen(Pen pen) {
        this.pen = pen;
    }
}

