/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameLinkedMode;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.UIJob;

public class RenameInformationPopup
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    private static boolean MAC = Util.isMac();
    private static final int WIDGET_PRIORITY = 1000;
    private static final String DIALOG_SETTINGS_SECTION = "RenameInformationPopup";
    private static final String SNAP_POSITION_KEY = "snap_position";
    private static final int SNAP_POSITION_UNDER_RIGHT_FIELD = 0;
    private static final int SNAP_POSITION_OVER_RIGHT_FIELD = 1;
    private static final int SNAP_POSITION_UNDER_LEFT_FIELD = 2;
    private static final int SNAP_POSITION_OVER_LEFT_FIELD = 3;
    private static final int SNAP_POSITION_LOWER_RIGHT = 4;
    private static final int POPUP_VISIBILITY_DELAY = 300;
    private static final int HAO = 10;
    private static final int HAW = 8;
    private static final int HAH = 10;
    private static final int GAP = 2;
    private final CompilationUnitEditor fEditor;
    private final RenameLinkedMode fRenameLinkedMode;
    private int fSnapPosition;
    private Shell fPopup;
    private GridLayout fPopupLayout;
    private Region fRegion;
    private Image fMenuImage;
    private MenuManager fMenuManager;
    private ToolBar fToolBar;
    private String fOpenDialogBinding = "";
    private boolean fIsMenuUp = false;
    private boolean fDelayJobFinished = false;
    static /* synthetic */ Class class$0;

    public RenameInformationPopup(CompilationUnitEditor editor, RenameLinkedMode renameLinkedMode) {
        this.fEditor = editor;
        this.fRenameLinkedMode = renameLinkedMode;
        this.restoreSnapPosition();
    }

    private void restoreSnapPosition() {
        IDialogSettings settings = this.getDialogSettings();
        try {
            this.fSnapPosition = settings.getInt(SNAP_POSITION_KEY);
        }
        catch (NumberFormatException numberFormatException) {
            this.fSnapPosition = 2;
        }
    }

    private IDialogSettings getDialogSettings() {
        return JavaPlugin.getDefault().getDialogSettingsSection(DIALOG_SETTINGS_SECTION);
    }

    public void open() {
        this.fOpenDialogBinding = RenameInformationPopup.getOpenDialogBinding();
        Shell workbenchShell = this.fEditor.getSite().getShell();
        final Display display = workbenchShell.getDisplay();
        this.fPopup = new Shell(workbenchShell, 16396);
        this.fPopupLayout = new GridLayout(2, false);
        this.fPopupLayout.marginWidth = 1;
        this.fPopupLayout.marginHeight = 1;
        this.fPopupLayout.marginLeft = 4;
        this.fPopupLayout.horizontalSpacing = 0;
        this.fPopup.setLayout((Layout)this.fPopupLayout);
        this.createContent((Composite)this.fPopup);
        this.updatePopupLocation(true);
        new PopupVisibilityManager().start();
        this.fPopup.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                if (RenameInformationPopup.this.fIsMenuUp) {
                    return;
                }
                Shell editorShell = RenameInformationPopup.this.fEditor.getSite().getShell();
                display.asyncExec(new Runnable(this, display, editorShell){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Display val$display;
                    private final /* synthetic */ Shell val$editorShell;
                    {
                        this.this$1 = var1_1;
                        this.val$display = display;
                        this.val$editorShell = shell;
                    }

                    public void run() {
                        Shell activeShell = this.val$display.getActiveShell();
                        if (activeShell != this.val$editorShell) {
                            RenameInformationPopup.access$6(2.access$0(this.this$1)).cancel();
                        }
                    }
                });
            }

            static /* synthetic */ RenameInformationPopup access$0(2 var0) {
                return var0.RenameInformationPopup.this;
            }
        });
        if (!MAC) {
            this.fPopup.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    pe.gc.drawPolygon(RenameInformationPopup.this.getPolygon(true));
                }
            });
        }
        UIJob delayJob = new UIJob(display, ReorgMessages.RenameInformationPopup_delayJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                RenameInformationPopup.this.fDelayJobFinished = true;
                if (RenameInformationPopup.this.fPopup != null && !RenameInformationPopup.this.fPopup.isDisposed()) {
                    RenameInformationPopup.this.updateVisibility();
                }
                return Status.OK_STATUS;
            }
        };
        delayJob.setSystem(true);
        delayJob.setPriority(10);
        delayJob.schedule(300L);
    }

    public void close() {
        if (this.fPopup != null) {
            if (!this.fPopup.isDisposed()) {
                this.fPopup.close();
            }
            this.fPopup = null;
        }
        this.releaseWidgetToken();
        if (this.fRegion != null && !this.fRegion.isDisposed()) {
            this.fRegion.dispose();
        }
    }

    public Shell getShell() {
        return this.fPopup;
    }

    private void updatePopupLocation(boolean force) {
        if (!force && this.fSnapPosition == 4) {
            return;
        }
        this.packPopup();
        Point loc = this.computePopupLocation(this.fSnapPosition);
        if (loc != null) {
            this.fPopup.setLocation(loc);
        }
    }

    private void updateVisibility() {
        if (this.fPopup != null && !this.fPopup.isDisposed() && this.fDelayJobFinished) {
            boolean visible = false;
            if (this.fRenameLinkedMode.isCaretInLinkedPosition()) {
                StyledText textWidget = this.fEditor.getViewer().getTextWidget();
                Rectangle eArea = Geometry.toDisplay((Control)textWidget, (Rectangle)textWidget.getClientArea());
                Rectangle pBounds = this.fPopup.getBounds();
                pBounds.x -= 2;
                pBounds.y -= 2;
                pBounds.width += 4;
                pBounds.height += 4;
                if (eArea.intersects(pBounds)) {
                    visible = true;
                }
            }
            if (visible && !this.fPopup.isVisible()) {
                ISourceViewer viewer = this.fEditor.getViewer();
                if (viewer instanceof IWidgetTokenOwnerExtension) {
                    IWidgetTokenOwnerExtension widgetTokenOwnerExtension = (IWidgetTokenOwnerExtension)viewer;
                    widgetTokenOwnerExtension.requestWidgetToken((IWidgetTokenKeeper)this, 1000);
                }
            } else if (!visible && this.fPopup.isVisible()) {
                this.releaseWidgetToken();
            }
            this.fPopup.setVisible(visible);
        }
    }

    private void releaseWidgetToken() {
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IWidgetTokenOwner) {
            IWidgetTokenOwner widgetTokenOwner = (IWidgetTokenOwner)viewer;
            widgetTokenOwner.releaseWidgetToken((IWidgetTokenKeeper)this);
        }
    }

    private Point computePopupLocation(int snapPosition) {
        if (this.fPopup == null || this.fPopup.isDisposed()) {
            return null;
        }
        switch (snapPosition) {
            case 4: {
                StyledText eWidget = this.fEditor.getViewer().getTextWidget();
                Rectangle eBounds = eWidget.getClientArea();
                Point eLowerRight = eWidget.toDisplay(eBounds.x + eBounds.width, eBounds.y + eBounds.height);
                Point pSize = this.getExtent();
                return new Point(eLowerRight.x - pSize.x - 5, eLowerRight.y - pSize.y - 5);
            }
            case 0: 
            case 1: {
                LinkedPosition position = this.fRenameLinkedMode.getCurrentLinkedPosition();
                if (position == null) {
                    return null;
                }
                ISourceViewer viewer = this.fEditor.getViewer();
                ITextViewerExtension5 viewer5 = (ITextViewerExtension5)viewer;
                int widgetOffset = viewer5.modelOffset2WidgetOffset(position.offset + position.length);
                StyledText textWidget = viewer.getTextWidget();
                Point pos = textWidget.getLocationAtOffset(widgetOffset);
                Point pSize = this.getExtent();
                pos.y = snapPosition == 1 ? (pos.y -= pSize.y + 2) : (pos.y += textWidget.getLineHeight(widgetOffset) + 2);
                pos.x += 2;
                Point dPos = textWidget.toDisplay(pos);
                Rectangle displayBounds = textWidget.getDisplay().getClientArea();
                Rectangle dPopupRect = Geometry.createRectangle((Point)dPos, (Point)pSize);
                Geometry.moveInside((Rectangle)dPopupRect, (Rectangle)displayBounds);
                return new Point(dPopupRect.x, dPopupRect.y);
            }
        }
        LinkedPosition position = this.fRenameLinkedMode.getCurrentLinkedPosition();
        if (position == null) {
            return null;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        ITextViewerExtension5 viewer5 = (ITextViewerExtension5)viewer;
        int widgetOffset = viewer5.modelOffset2WidgetOffset(position.offset);
        StyledText textWidget = viewer.getTextWidget();
        Point pos = textWidget.getLocationAtOffset(widgetOffset);
        Point pSize = this.getExtent();
        pSize.y += 11;
        pos.x -= 10;
        pos.y = snapPosition == 3 ? (pos.y -= pSize.y) : (pos.y += textWidget.getLineHeight(widgetOffset));
        Point dPos = textWidget.toDisplay(pos);
        Rectangle displayBounds = textWidget.getDisplay().getClientArea();
        Rectangle dPopupRect = Geometry.createRectangle((Point)dPos, (Point)pSize);
        Geometry.moveInside((Rectangle)dPopupRect, (Rectangle)displayBounds);
        return new Point(dPopupRect.x, dPopupRect.y);
    }

    private void addMoveSupport(final Shell popupShell, Control movedControl) {
        movedControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent downEvent) {
                if (downEvent.button != 1) {
                    return;
                }
                Point POPUP_SOURCE = popupShell.getLocation();
                StyledText textWidget = RenameInformationPopup.this.fEditor.getViewer().getTextWidget();
                Point pSize = RenameInformationPopup.this.getExtent();
                int originalSnapPosition = RenameInformationPopup.this.fSnapPosition;
                Tracker tracker = new Tracker((Composite)textWidget, 0);
                Point[] LOCATIONS = new Point[]{textWidget.toControl(RenameInformationPopup.this.computePopupLocation(0)), textWidget.toControl(RenameInformationPopup.this.computePopupLocation(1)), textWidget.toControl(RenameInformationPopup.this.computePopupLocation(2)), textWidget.toControl(RenameInformationPopup.this.computePopupLocation(3)), textWidget.toControl(RenameInformationPopup.this.computePopupLocation(4))};
                Rectangle[] DROP_TARGETS = new Rectangle[]{Geometry.createRectangle((Point)LOCATIONS[0], (Point)pSize), Geometry.createRectangle((Point)LOCATIONS[1], (Point)pSize), new Rectangle(LOCATIONS[2].x, LOCATIONS[2].y + 10, pSize.x, pSize.y), Geometry.createRectangle((Point)LOCATIONS[3], (Point)pSize), Geometry.createRectangle((Point)LOCATIONS[4], (Point)pSize)};
                Rectangle MOUSE_MOVE_SOURCE = new Rectangle(1000000, 0, 0, 0);
                tracker.setRectangles(new Rectangle[]{MOUSE_MOVE_SOURCE, DROP_TARGETS[RenameInformationPopup.this.fSnapPosition]});
                tracker.setStippled(true);
                ControlAdapter moveListener = new ControlAdapter(this, tracker, POPUP_SOURCE, MOUSE_MOVE_SOURCE, popupShell, textWidget, DROP_TARGETS, LOCATIONS){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ Tracker val$tracker;
                    private final /* synthetic */ Point val$POPUP_SOURCE;
                    private final /* synthetic */ Rectangle val$MOUSE_MOVE_SOURCE;
                    private final /* synthetic */ Shell val$popupShell;
                    private final /* synthetic */ StyledText val$textWidget;
                    private final /* synthetic */ Rectangle[] val$DROP_TARGETS;
                    private final /* synthetic */ Point[] val$LOCATIONS;
                    {
                        this.this$1 = var1_1;
                        this.val$tracker = tracker;
                        this.val$POPUP_SOURCE = point;
                        this.val$MOUSE_MOVE_SOURCE = rectangle;
                        this.val$popupShell = shell;
                        this.val$textWidget = styledText;
                        this.val$DROP_TARGETS = rectangleArray;
                        this.val$LOCATIONS = pointArray;
                    }

                    public void controlMoved(ControlEvent moveEvent) {
                        Rectangle[] currentRects = this.val$tracker.getRectangles();
                        Rectangle mouseMoveCurrent = currentRects[0];
                        Point popupLoc = new Point(this.val$POPUP_SOURCE.x + mouseMoveCurrent.x - this.val$MOUSE_MOVE_SOURCE.x, this.val$POPUP_SOURCE.y + mouseMoveCurrent.y - this.val$MOUSE_MOVE_SOURCE.y);
                        this.val$popupShell.setLocation(popupLoc);
                        Point ePopupLoc = this.val$textWidget.toControl(popupLoc);
                        int minDist = Integer.MAX_VALUE;
                        int snapPos = 0;
                        while (snapPos < this.val$DROP_TARGETS.length) {
                            int dist = Geometry.distanceSquared((Point)ePopupLoc, (Point)this.val$LOCATIONS[snapPos]);
                            if (dist < minDist) {
                                minDist = dist;
                                RenameInformationPopup.access$15(6.access$0(this.this$1), snapPos);
                                currentRects[1] = this.val$DROP_TARGETS[snapPos];
                            }
                            ++snapPos;
                        }
                        this.val$tracker.setRectangles(currentRects);
                    }
                };
                tracker.addControlListener((ControlListener)moveListener);
                boolean committed = tracker.open();
                tracker.close();
                tracker.dispose();
                if (committed) {
                    RenameInformationPopup.this.getDialogSettings().put(RenameInformationPopup.SNAP_POSITION_KEY, RenameInformationPopup.this.fSnapPosition);
                } else {
                    RenameInformationPopup.this.fSnapPosition = originalSnapPosition;
                }
                RenameInformationPopup.this.updatePopupLocation(true);
                RenameInformationPopup.this.activateEditor();
            }

            static /* synthetic */ RenameInformationPopup access$0(6 var0) {
                return var0.RenameInformationPopup.this;
            }
        });
    }

    private void packPopup() {
        boolean isUnderLeft = this.fSnapPosition == 2;
        boolean isOverLeft = this.fSnapPosition == 3;
        this.fPopupLayout.marginTop = isUnderLeft ? 10 : 0;
        this.fPopupLayout.marginBottom = isOverLeft ? 11 : 0;
        this.fPopup.pack();
        Region oldRegion = this.fRegion;
        if (isUnderLeft || isOverLeft) {
            this.fRegion = new Region();
            this.fRegion.add(this.getPolygon(false));
            this.fPopup.setRegion(this.fRegion);
            Rectangle bounds = this.fRegion.getBounds();
            this.fPopup.setSize(bounds.width, bounds.height + 1);
        } else {
            this.fRegion = null;
            this.fPopup.setRegion(null);
        }
        if (oldRegion != null) {
            oldRegion.dispose();
        }
    }

    private Point getExtent() {
        Point e = this.fPopup.getSize();
        switch (this.fSnapPosition) {
            case 2: {
                e.y -= 10;
                break;
            }
            case 3: {
                e.y -= 11;
            }
        }
        return e;
    }

    private int[] getPolygon(boolean border) {
        int[] poly;
        Point e = this.getExtent();
        int b = border ? 1 : 0;
        boolean isRTL = (this.fPopup.getStyle() & 0x4000000) != 0;
        int ha1 = isRTL ? e.x - 10 : 18;
        int ha2 = isRTL ? e.x - 10 - 4 : 14;
        int ha3 = isRTL ? e.x - 10 - 8 : 10;
        switch (this.fSnapPosition) {
            case 3: {
                int[] nArray = new int[16];
                nArray[2] = e.x - b;
                nArray[4] = e.x - b;
                nArray[5] = e.y - b;
                nArray[6] = ha1;
                nArray[7] = e.y - b;
                nArray[8] = ha2;
                nArray[9] = e.y + 10 - b;
                nArray[10] = ha3;
                nArray[11] = e.y - b;
                nArray[13] = e.y - b;
                poly = nArray;
                break;
            }
            case 2: {
                int[] nArray = new int[16];
                nArray[1] = 10;
                nArray[2] = ha3 + b;
                nArray[3] = 10;
                nArray[4] = ha2;
                nArray[5] = b;
                nArray[6] = ha1 - b;
                nArray[7] = 10;
                nArray[8] = e.x - b;
                nArray[9] = 10;
                nArray[10] = e.x - b;
                nArray[11] = e.y + 10 - b;
                nArray[13] = e.y + 10 - b;
                nArray[15] = 10;
                poly = nArray;
                break;
            }
            default: {
                int[] nArray = new int[10];
                nArray[2] = e.x - b;
                nArray[4] = e.x - b;
                nArray[5] = e.y - b;
                nArray[7] = e.y - b;
                poly = nArray;
            }
        }
        return poly;
    }

    private void createContent(Composite parent) {
        Display display = parent.getDisplay();
        Color foreground = display.getSystemColor(28);
        Color background = display.getSystemColor(29);
        this.addMoveSupport(this.fPopup, (Control)parent);
        StyledText hint = new StyledText((Composite)this.fPopup, 12);
        String enterKeyName = RenameInformationPopup.getEnterBinding();
        String hintTemplate = ReorgMessages.RenameInformationPopup_EnterNewName;
        hint.setText(Messages.format(hintTemplate, enterKeyName));
        hint.setForeground(foreground);
        hint.setStyleRange(new StyleRange(hintTemplate.indexOf("{0}"), enterKeyName.length(), null, null, 1));
        hint.setEnabled(false);
        this.addMoveSupport(this.fPopup, (Control)hint);
        this.addViewMenu(parent);
        RenameInformationPopup.recursiveSetBackgroundColor((Control)parent, background);
    }

    private ToolBar addViewMenu(Composite parent) {
        this.fToolBar = new ToolBar(parent, 0x800000);
        ToolItem menuButton = new ToolItem(this.fToolBar, 8, 0);
        this.fMenuImage = JavaPluginImages.DESC_ELCL_VIEW_MENU.createImage();
        menuButton.setImage(this.fMenuImage);
        menuButton.setToolTipText(ReorgMessages.RenameInformationPopup_menu);
        this.fToolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                RenameInformationPopup.this.showMenu(RenameInformationPopup.this.fToolBar);
            }
        });
        menuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RenameInformationPopup.this.showMenu(RenameInformationPopup.this.fToolBar);
            }
        });
        this.fToolBar.pack();
        return this.fToolBar;
    }

    private void showMenu(ToolBar toolBar) {
        Menu menu = this.getMenuManager().createContextMenu((Control)toolBar);
        menu.setLocation(toolBar.toDisplay(0, toolBar.getSize().y));
        this.fIsMenuUp = true;
        menu.setVisible(true);
    }

    private MenuManager getMenuManager() {
        if (this.fMenuManager != null) {
            return this.fMenuManager;
        }
        this.fMenuManager = new MenuManager();
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToHide(IMenuManager manager) {
                RenameInformationPopup.this.fIsMenuUp = false;
            }

            public void menuAboutToShow(IMenuManager manager) {
                boolean canRefactor = !RenameInformationPopup.this.fRenameLinkedMode.isOriginalName();
                Action refactorAction = new Action(this, ReorgMessages.RenameInformationPopup_RenameInWorkspace){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RenameInformationPopup.access$17(10.access$0(this.this$1));
                        RenameInformationPopup.access$6(10.access$0(this.this$1)).doRename(false);
                    }
                };
                refactorAction.setAccelerator(13);
                refactorAction.setEnabled(canRefactor);
                manager.add((IAction)refactorAction);
                Action previewAction = new Action(this, ReorgMessages.RenameInformationPopup_Preview){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RenameInformationPopup.access$17(10.access$0(this.this$1));
                        RenameInformationPopup.access$6(10.access$0(this.this$1)).doRename(true);
                    }
                };
                previewAction.setAccelerator(262157);
                previewAction.setEnabled(canRefactor);
                manager.add((IAction)previewAction);
                Action openDialogAction = new Action(this, String.valueOf(ReorgMessages.RenameInformationPopup_OpenDialog) + '\t' + RenameInformationPopup.this.fOpenDialogBinding){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RenameInformationPopup.access$17(10.access$0(this.this$1));
                        RenameInformationPopup.access$6(10.access$0(this.this$1)).startFullDialog();
                    }
                };
                manager.add((IAction)openDialogAction);
                manager.add((IContributionItem)new Separator());
                MenuManager subMenuManager = new MenuManager(ReorgMessages.RenameInformationPopup_SnapTo);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)subMenuManager, 2, ReorgMessages.RenameInformationPopup_snap_under_left);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)subMenuManager, 0, ReorgMessages.RenameInformationPopup_snap_under_right);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)subMenuManager, 3, ReorgMessages.RenameInformationPopup_snap_over_left);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)subMenuManager, 1, ReorgMessages.RenameInformationPopup_snap_over_right);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)subMenuManager, 4, ReorgMessages.RenameInformationPopup_snap_bottom_right);
                manager.add((IContributionItem)subMenuManager);
                Action prefsAction = new Action(this, ReorgMessages.RenameInformationPopup_preferences){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RenameInformationPopup.access$6(10.access$0(this.this$1)).cancel();
                        String linkedModePrefPageID = "org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage";
                        String refactoringPrefPageID = "org.eclipse.jdt.ui.preferences.JavaBasePreferencePage";
                        PreferencesUtil.createPreferenceDialogOn((Shell)RenameInformationPopup.access$0(10.access$0(this.this$1)).getSite().getShell(), (String)refactoringPrefPageID, (String[])new String[]{linkedModePrefPageID, refactoringPrefPageID}, null).open();
                    }
                };
                manager.add((IAction)prefsAction);
            }

            static /* synthetic */ RenameInformationPopup access$0(10 var0) {
                return var0.RenameInformationPopup.this;
            }
        });
        return this.fMenuManager;
    }

    private void addMoveMenuItem(IMenuManager manager, final int snapPosition, String text) {
        Action action = new Action(text, 8){

            public void run() {
                RenameInformationPopup.this.fSnapPosition = snapPosition;
                RenameInformationPopup.this.getDialogSettings().put(RenameInformationPopup.SNAP_POSITION_KEY, RenameInformationPopup.this.fSnapPosition);
                RenameInformationPopup.this.updatePopupLocation(true);
                RenameInformationPopup.this.activateEditor();
            }
        };
        action.setChecked(this.fSnapPosition == snapPosition);
        manager.add((IAction)action);
    }

    private static String getEnterBinding() {
        return KeyStroke.getInstance((int)KeyLookupFactory.getDefault().formalKeyLookup("CR")).format();
    }

    private static String getOpenDialogBinding() {
        IBindingService bindingService;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) == null) {
            return "";
        }
        String binding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.jdt.ui.edit.text.java.rename.element");
        return binding == null ? "" : binding;
    }

    private static void recursiveSetBackgroundColor(Control control, Color color) {
        control.setBackground(color);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                RenameInformationPopup.recursiveSetBackgroundColor(children[i], color);
                ++i;
            }
        }
    }

    public boolean ownsFocusShell() {
        if (this.fIsMenuUp) {
            return true;
        }
        if (this.fPopup == null || this.fPopup.isDisposed()) {
            return false;
        }
        Shell activeShell = this.fPopup.getDisplay().getActiveShell();
        return this.fPopup == activeShell;
    }

    private void activateEditor() {
        this.fEditor.getSite().getShell().setActive();
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        return false;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        return false;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        if (this.fToolBar != null && !this.fToolBar.isDisposed()) {
            this.showMenu(this.fToolBar);
        }
        return true;
    }

    static /* synthetic */ Image access$2(RenameInformationPopup renameInformationPopup) {
        return renameInformationPopup.fMenuImage;
    }

    static /* synthetic */ void access$3(RenameInformationPopup renameInformationPopup, Image image) {
        renameInformationPopup.fMenuImage = image;
    }

    static /* synthetic */ MenuManager access$4(RenameInformationPopup renameInformationPopup) {
        return renameInformationPopup.fMenuManager;
    }

    static /* synthetic */ void access$5(RenameInformationPopup renameInformationPopup, MenuManager menuManager) {
        renameInformationPopup.fMenuManager = menuManager;
    }

    private class PopupVisibilityManager
    implements IPartListener2,
    ControlListener,
    MouseListener,
    KeyListener,
    ITextListener,
    IViewportListener {
        private PopupVisibilityManager() {
        }

        public void start() {
            RenameInformationPopup.this.fEditor.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
            ISourceViewer viewer = RenameInformationPopup.this.fEditor.getViewer();
            StyledText textWidget = viewer.getTextWidget();
            textWidget.addControlListener((ControlListener)this);
            textWidget.addMouseListener((MouseListener)this);
            textWidget.addKeyListener((KeyListener)this);
            RenameInformationPopup.this.fEditor.getSite().getShell().addControlListener((ControlListener)this);
            viewer.addTextListener((ITextListener)this);
            viewer.addViewportListener((IViewportListener)this);
            RenameInformationPopup.this.fPopup.addDisposeListener(new DisposeListener(this, textWidget, viewer){
                final /* synthetic */ PopupVisibilityManager this$1;
                private final /* synthetic */ StyledText val$textWidget;
                private final /* synthetic */ ISourceViewer val$viewer;
                {
                    this.this$1 = popupVisibilityManager;
                    this.val$textWidget = styledText;
                    this.val$viewer = iSourceViewer;
                }

                public void widgetDisposed(DisposeEvent e) {
                    RenameInformationPopup.access$0(PopupVisibilityManager.access$1(this.this$1)).getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this.this$1);
                    if (!this.val$textWidget.isDisposed()) {
                        this.val$textWidget.removeControlListener((ControlListener)this.this$1);
                        this.val$textWidget.removeMouseListener((MouseListener)this.this$1);
                        this.val$textWidget.removeKeyListener((KeyListener)this.this$1);
                    }
                    RenameInformationPopup.access$0(PopupVisibilityManager.access$1(this.this$1)).getSite().getShell().removeControlListener((ControlListener)this.this$1);
                    this.val$viewer.removeTextListener((ITextListener)this.this$1);
                    this.val$viewer.removeViewportListener((IViewportListener)this.this$1);
                    if (RenameInformationPopup.access$2(PopupVisibilityManager.access$1(this.this$1)) != null) {
                        RenameInformationPopup.access$2(PopupVisibilityManager.access$1(this.this$1)).dispose();
                        RenameInformationPopup.access$3(PopupVisibilityManager.access$1(this.this$1), null);
                    }
                    if (RenameInformationPopup.access$4(PopupVisibilityManager.access$1(this.this$1)) != null) {
                        RenameInformationPopup.access$4(PopupVisibilityManager.access$1(this.this$1)).dispose();
                        RenameInformationPopup.access$5(PopupVisibilityManager.access$1(this.this$1), null);
                    }
                    RenameInformationPopup.access$6(PopupVisibilityManager.access$1(this.this$1)).cancel();
                }
            });
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart fPart = RenameInformationPopup.this.fEditor.getEditorSite().getPart();
            if (partRef.getPart(false) == fPart) {
                RenameInformationPopup.this.updateVisibility();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart fPart = RenameInformationPopup.this.fEditor.getEditorSite().getPart();
            if (RenameInformationPopup.this.fPopup != null && !RenameInformationPopup.this.fPopup.isDisposed() && partRef.getPart(false) == fPart) {
                RenameInformationPopup.this.fPopup.setVisible(false);
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void controlMoved(ControlEvent e) {
            RenameInformationPopup.this.updatePopupLocation(true);
            RenameInformationPopup.this.updateVisibility();
        }

        public void controlResized(ControlEvent e) {
            RenameInformationPopup.this.updatePopupLocation(true);
            RenameInformationPopup.this.updateVisibility();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            RenameInformationPopup.this.updatePopupLocation(false);
            RenameInformationPopup.this.updateVisibility();
        }

        public void keyPressed(KeyEvent e) {
            RenameInformationPopup.this.updatePopupLocation(false);
            RenameInformationPopup.this.updateVisibility();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void textChanged(TextEvent event) {
            if (!event.getViewerRedrawState()) {
                return;
            }
            RenameInformationPopup.this.updatePopupLocation(false);
            RenameInformationPopup.this.updateVisibility();
        }

        public void viewportChanged(int verticalOffset) {
            RenameInformationPopup.this.updatePopupLocation(true);
            RenameInformationPopup.this.updateVisibility();
        }

        static /* synthetic */ RenameInformationPopup access$1(PopupVisibilityManager popupVisibilityManager) {
            return popupVisibilityManager.RenameInformationPopup.this;
        }
    }
}

