/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ProfileManager
extends Observable {
    public static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private final String fProfileKey;
    private final String fProfileVersionKey;
    private static final String SHARED_PROFILE = "org.eclipse.jdt.ui.default.shared";
    private final Map fProfiles;
    private final List fProfilesByName;
    private Profile fSelected;
    private final KeySet[] fKeySets;
    private final PreferencesAccess fPreferencesAccess;
    private final IProfileVersioner fProfileVersioner;

    public ProfileManager(List profiles, IScopeContext context, PreferencesAccess preferencesAccess, IProfileVersioner profileVersioner, KeySet[] keySets, String profileKey, String profileVersionKey) {
        block6: {
            String projProfileId;
            Profile matching;
            Map map;
            block8: {
                ArrayList allKeys;
                block7: {
                    Profile profile;
                    this.fPreferencesAccess = preferencesAccess;
                    this.fProfileVersioner = profileVersioner;
                    this.fKeySets = keySets;
                    this.fProfileKey = profileKey;
                    this.fProfileVersionKey = profileVersionKey;
                    this.fProfiles = new HashMap();
                    this.fProfilesByName = new ArrayList();
                    Iterator iter = profiles.iterator();
                    while (iter.hasNext()) {
                        profile = (Profile)iter.next();
                        if (profile instanceof CustomProfile) {
                            ((CustomProfile)profile).setManager(this);
                        }
                        this.fProfiles.put(profile.getID(), profile);
                        this.fProfilesByName.add(profile);
                    }
                    Collections.sort(this.fProfilesByName);
                    String profileId = this.getSelectedProfileId(this.fPreferencesAccess.getInstanceScope());
                    profile = (Profile)this.fProfiles.get(profileId);
                    if (profile == null) {
                        profile = this.getDefaultProfile();
                    }
                    this.fSelected = profile;
                    if (context.getName() != "project" || !this.hasProjectSpecificSettings(context) || (map = this.readFromPreferenceStore(context, profile)) == null) break block6;
                    allKeys = new ArrayList();
                    int i = 0;
                    while (i < this.fKeySets.length) {
                        allKeys.addAll(this.fKeySets[i].getKeys());
                        ++i;
                    }
                    Collections.sort(allKeys);
                    matching = null;
                    projProfileId = context.getNode("org.eclipse.jdt.ui").get(this.fProfileKey, null);
                    if (projProfileId == null) break block7;
                    Profile curr = (Profile)this.fProfiles.get(projProfileId);
                    if (curr == null || !curr.isBuiltInProfile() && !curr.hasEqualSettings(map, allKeys)) break block8;
                    matching = curr;
                    break block8;
                }
                Iterator iter = this.fProfilesByName.iterator();
                while (iter.hasNext()) {
                    Profile curr = (Profile)iter.next();
                    if (!curr.hasEqualSettings(map, allKeys)) continue;
                    matching = curr;
                    break;
                }
            }
            if (matching == null) {
                String name = projProfileId != null && !this.fProfiles.containsKey(projProfileId) ? Messages.format(FormatterMessages.ProfileManager_unmanaged_profile_with_name, projProfileId.substring(ID_PREFIX.length())) : FormatterMessages.ProfileManager_unmanaged_profile;
                SharedProfile shared = new SharedProfile(name, map, this.fProfileVersioner.getCurrentVersion(), this.fProfileVersioner.getProfileKind());
                shared.setManager(this);
                this.fProfiles.put(shared.getID(), shared);
                this.fProfilesByName.add(shared);
                matching = shared;
            }
            this.fSelected = matching;
        }
    }

    protected String getSelectedProfileId(IScopeContext instanceScope) {
        String profileId = instanceScope.getNode("org.eclipse.jdt.ui").get(this.fProfileKey, null);
        if (profileId == null) {
            profileId = new DefaultScope().getNode("org.eclipse.jdt.ui").get(this.fProfileKey, null);
        }
        return profileId;
    }

    protected void notifyObservers(int message) {
        this.setChanged();
        this.notifyObservers(new Integer(message));
    }

    public static boolean hasProjectSpecificSettings(IScopeContext context, KeySet[] keySets) {
        int i = 0;
        while (i < keySets.length) {
            KeySet keySet = keySets[i];
            IEclipsePreferences preferences = context.getNode(keySet.getNodeName());
            Iterator keyIter = keySet.getKeys().iterator();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                String val = preferences.get(key, null);
                if (val == null) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasProjectSpecificSettings(IScopeContext context) {
        return ProfileManager.hasProjectSpecificSettings(context, this.fKeySets);
    }

    private Map readFromPreferenceStore(IScopeContext context, Profile workspaceProfile) {
        HashMap<String, String> profileOptions = new HashMap<String, String>();
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        int version = uiPrefs.getInt(this.fProfileVersionKey, this.fProfileVersioner.getFirstVersion());
        if (version != this.fProfileVersioner.getCurrentVersion()) {
            HashMap allOptions = new HashMap();
            int i = 0;
            while (i < this.fKeySets.length) {
                this.addAll(context.getNode(this.fKeySets[i].getNodeName()), allOptions);
                ++i;
            }
            CustomProfile profile = new CustomProfile("tmp", allOptions, version, this.fProfileVersioner.getProfileKind());
            this.fProfileVersioner.update(profile);
            return profile.getSettings();
        }
        boolean hasValues = false;
        int i = 0;
        while (i < this.fKeySets.length) {
            KeySet keySet = this.fKeySets[i];
            IEclipsePreferences preferences = context.getNode(keySet.getNodeName());
            Iterator keyIter = keySet.getKeys().iterator();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                String val = preferences.get(key, null);
                if (val != null) {
                    hasValues = true;
                } else {
                    val = workspaceProfile.getSettings().get(key);
                }
                profileOptions.put(key, val);
            }
            ++i;
        }
        if (!hasValues) {
            return null;
        }
        ProfileManager.setLatestCompliance(profileOptions);
        return profileOptions;
    }

    private void addAll(IEclipsePreferences uiPrefs, Map allOptions) {
        try {
            String[] keys = uiPrefs.keys();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String val = uiPrefs.get(key, null);
                if (val != null) {
                    allOptions.put(key, val);
                }
                ++i;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private boolean updatePreferences(IEclipsePreferences prefs, List keys, Map profileOptions) {
        boolean hasChanges = false;
        Iterator keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String oldVal = prefs.get(key, null);
            String val = (String)profileOptions.get(key);
            if (val == null) {
                if (oldVal == null) continue;
                prefs.remove(key);
                hasChanges = true;
                continue;
            }
            if (val.equals(oldVal)) continue;
            prefs.put(key, val);
            hasChanges = true;
        }
        return hasChanges;
    }

    private void writeToPreferenceStore(Profile profile, IScopeContext context) {
        Map profileOptions = profile.getSettings();
        int i = 0;
        while (i < this.fKeySets.length) {
            this.updatePreferences(context.getNode(this.fKeySets[i].getNodeName()), this.fKeySets[i].getKeys(), profileOptions);
            ++i;
        }
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        if (uiPrefs.getInt(this.fProfileVersionKey, 0) != this.fProfileVersioner.getCurrentVersion()) {
            uiPrefs.putInt(this.fProfileVersionKey, this.fProfileVersioner.getCurrentVersion());
        }
        if (context.getName() == "instance") {
            uiPrefs.put(this.fProfileKey, profile.getID());
        } else if (context.getName() == "project" && !profile.isSharedProfile()) {
            uiPrefs.put(this.fProfileKey, profile.getID());
        }
    }

    public List getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedDisplayNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        Iterator iter = this.fProfilesByName.iterator();
        while (iter.hasNext()) {
            Profile curr = (Profile)iter.next();
            sortedNames[i++] = curr.getName();
        }
        return sortedNames;
    }

    public Profile getProfile(String ID) {
        return (Profile)this.fProfiles.get(ID);
    }

    public void commitChanges(IScopeContext scopeContext) {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected, scopeContext);
        }
    }

    public void clearAllSettings(IScopeContext context) {
        int i = 0;
        while (i < this.fKeySets.length) {
            this.updatePreferences(context.getNode(this.fKeySets[i].getNodeName()), this.fKeySets[i].getKeys(), Collections.EMPTY_MAP);
            ++i;
        }
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        uiPrefs.remove(this.fProfileKey);
    }

    public Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(Profile profile) {
        Profile newSelected = (Profile)this.fProfiles.get(profile.getID());
        if (newSelected != null && !newSelected.equals(this.fSelected)) {
            this.fSelected = newSelected;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String name) {
        Iterator iter = this.fProfilesByName.iterator();
        while (iter.hasNext()) {
            Profile curr = (Profile)iter.next();
            if (!name.equals(curr.getName())) continue;
            return true;
        }
        return false;
    }

    public void addProfile(CustomProfile profile) {
        profile.setManager(this);
        CustomProfile oldProfile = (CustomProfile)this.fProfiles.get(profile.getID());
        if (oldProfile != null) {
            this.fProfiles.remove(oldProfile.getID());
            this.fProfilesByName.remove(oldProfile);
            oldProfile.setManager(null);
        }
        this.fProfiles.put(profile.getID(), profile);
        this.fProfilesByName.add(profile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = profile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof CustomProfile)) {
            return false;
        }
        return this.deleteProfile((CustomProfile)this.fSelected);
    }

    public boolean deleteProfile(CustomProfile profile) {
        int index = this.fProfilesByName.indexOf(profile);
        this.fProfiles.remove(profile.getID());
        this.fProfilesByName.remove(profile);
        profile.setManager(null);
        if (index >= this.fProfilesByName.size()) {
            --index;
        }
        this.fSelected = (Profile)this.fProfilesByName.get(index);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), null, false);
        }
        this.notifyObservers(2);
        return true;
    }

    public void profileRenamed(CustomProfile profile, String oldID) {
        this.fProfiles.remove(oldID);
        this.fProfiles.put(profile.getID(), profile);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(oldID, profile, false);
        }
        Collections.sort(this.fProfilesByName);
        this.notifyObservers(3);
    }

    public void profileReplaced(CustomProfile oldProfile, CustomProfile newProfile) {
        this.fProfiles.remove(oldProfile.getID());
        this.fProfiles.put(newProfile.getID(), newProfile);
        this.fProfilesByName.remove(oldProfile);
        this.fProfilesByName.add(newProfile);
        Collections.sort(this.fProfilesByName);
        if (!oldProfile.isSharedProfile()) {
            this.updateProfilesWithName(oldProfile.getID(), null, false);
        }
        this.setSelected(newProfile);
        this.notifyObservers(4);
        this.notifyObservers(1);
    }

    public void profileChanged(CustomProfile profile) {
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), profile, true);
        }
        this.notifyObservers(5);
    }

    protected void updateProfilesWithName(String oldName, Profile newProfile, boolean applySettings) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IScopeContext projectScope = this.fPreferencesAccess.getProjectScope(projects[i]);
            IEclipsePreferences node = projectScope.getNode("org.eclipse.jdt.ui");
            String profileId = node.get(this.fProfileKey, null);
            if (oldName.equals(profileId)) {
                if (newProfile == null) {
                    node.remove(this.fProfileKey);
                } else if (applySettings) {
                    this.writeToPreferenceStore(newProfile, projectScope);
                } else {
                    node.put(this.fProfileKey, newProfile.getID());
                }
            }
            ++i;
        }
        IScopeContext instanceScope = this.fPreferencesAccess.getInstanceScope();
        IEclipsePreferences uiPrefs = instanceScope.getNode("org.eclipse.jdt.ui");
        if (newProfile != null && oldName.equals(uiPrefs.get(this.fProfileKey, null))) {
            this.writeToPreferenceStore(newProfile, instanceScope);
        }
    }

    private static void setLatestCompliance(Map map) {
        JavaModelUtil.set50ComplianceOptions(map);
    }

    public abstract Profile getDefaultProfile();

    public IProfileVersioner getProfileVersioner() {
        return this.fProfileVersioner;
    }

    public static final class BuiltInProfile
    extends Profile {
        private final String fName;
        private final String fID;
        private final Map fSettings;
        private final int fOrder;
        private final int fCurrentVersion;
        private final String fProfileKind;

        public BuiltInProfile(String ID, String name, Map settings, int order, int currentVersion, String profileKind) {
            this.fName = name;
            this.fID = ID;
            this.fSettings = settings;
            this.fOrder = order;
            this.fCurrentVersion = currentVersion;
            this.fProfileKind = profileKind;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            CustomProfile newProfile = new CustomProfile(trimmed, this.fSettings, this.fCurrentVersion, this.fProfileKind);
            manager.addProfile(newProfile);
            return newProfile;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map settings) {
        }

        public String getID() {
            return this.fID;
        }

        public final int compareTo(Object o) {
            if (o instanceof BuiltInProfile) {
                return this.fOrder - ((BuiltInProfile)o).fOrder;
            }
            return -1;
        }

        public boolean isProfileToSave() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return true;
        }

        public int getVersion() {
            return this.fCurrentVersion;
        }
    }

    public static class CustomProfile
    extends Profile {
        private String fName;
        private Map fSettings;
        protected ProfileManager fManager;
        private int fVersion;
        private final String fKind;

        public CustomProfile(String name, Map settings, int version, String kind) {
            this.fName = name;
            this.fSettings = settings;
            this.fVersion = version;
            this.fKind = kind;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            if (trimmed.equals(this.getName())) {
                return this;
            }
            String oldID = this.getID();
            this.fName = trimmed;
            manager.profileRenamed(this, oldID);
            return this;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map settings) {
            if (settings == null) {
                throw new IllegalArgumentException();
            }
            this.fSettings = settings;
            if (this.fManager != null) {
                this.fManager.profileChanged(this);
            }
        }

        public String getID() {
            return ProfileManager.ID_PREFIX + this.fName;
        }

        public void setManager(ProfileManager profileManager) {
            this.fManager = profileManager;
        }

        public ProfileManager getManager() {
            return this.fManager;
        }

        public int getVersion() {
            return this.fVersion;
        }

        public void setVersion(int version) {
            this.fVersion = version;
        }

        public int compareTo(Object o) {
            if (o instanceof SharedProfile) {
                return -1;
            }
            if (o instanceof CustomProfile) {
                return this.getName().compareToIgnoreCase(((Profile)o).getName());
            }
            return 1;
        }

        public boolean isProfileToSave() {
            return true;
        }

        public String getKind() {
            return this.fKind;
        }
    }

    public static final class KeySet {
        private final List fKeys;
        private final String fNodeName;

        public KeySet(String nodeName, List keys) {
            this.fNodeName = nodeName;
            this.fKeys = keys;
        }

        public String getNodeName() {
            return this.fNodeName;
        }

        public List getKeys() {
            return this.fKeys;
        }
    }

    public static abstract class Profile
    implements Comparable {
        public abstract String getName();

        public abstract Profile rename(String var1, ProfileManager var2);

        public abstract Map getSettings();

        public abstract void setSettings(Map var1);

        public abstract int getVersion();

        public boolean hasEqualSettings(Map otherMap, Collection allKeys) {
            Map settings = this.getSettings();
            Iterator iter = allKeys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object other = otherMap.get(key);
                Object curr = settings.get(key);
                if (!(other == null ? curr != null : !other.equals(curr))) continue;
                return false;
            }
            return true;
        }

        public abstract boolean isProfileToSave();

        public abstract String getID();

        public boolean isSharedProfile() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return false;
        }
    }

    public final class SharedProfile
    extends CustomProfile {
        public SharedProfile(String oldName, Map options, int version, String profileKind) {
            super(oldName, options, version, profileKind);
        }

        public Profile rename(String name, ProfileManager manager) {
            CustomProfile profile = new CustomProfile(name.trim(), this.getSettings(), this.getVersion(), this.getKind());
            manager.profileReplaced(this, profile);
            return profile;
        }

        public String getID() {
            return ProfileManager.SHARED_PROFILE;
        }

        public final int compareTo(Object o) {
            return 1;
        }

        public boolean isProfileToSave() {
            return false;
        }

        public boolean isSharedProfile() {
            return true;
        }
    }
}

