/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.callhierarchy.CallerMethodWrapper;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.corext.callhierarchy.RealCallers;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.jdt.internal.ui.callhierarchy.DeferredMethodWrapper;
import org.eclipse.jdt.internal.ui.callhierarchy.TreeRoot;
import org.eclipse.jdt.internal.ui.callhierarchy.TreeTermination;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public class CallHierarchyContentProvider
implements ITreeContentProvider {
    public static final String PREF_DEFAULT_EXPAND_WITH_CONSTRUCTORS = "CallHierarchy.defaultExpandWithConstructors";
    public static final String PREF_ANONYMOUS_EXPAND_WITH_CONSTRUCTORS = "CallHierarchy.anonymousExpandWithConstructors";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private DeferredTreeContentManager fManager;
    private CallHierarchyViewPart fPart;

    public CallHierarchyContentProvider(CallHierarchyViewPart part) {
        this.fPart = part;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeRoot) {
            TreeRoot dummyRoot = (TreeRoot)parentElement;
            return dummyRoot.getRoots();
        }
        if (parentElement instanceof RealCallers) {
            Object[] children;
            MethodWrapper parentWrapper = ((RealCallers)((Object)parentElement)).getParent();
            RealCallers element = (RealCallers)((Object)parentElement);
            if (this.fManager != null && (children = this.fManager.getChildren((Object)new DeferredMethodWrapper(this, element))) != null) {
                return children;
            }
            return this.fetchChildren(parentWrapper);
        }
        if (parentElement instanceof MethodWrapper) {
            Object[] children;
            MethodWrapper methodWrapper = (MethodWrapper)((Object)parentElement);
            if (this.shouldStopTraversion(methodWrapper)) {
                return EMPTY_ARRAY;
            }
            if (parentElement instanceof CallerMethodWrapper) {
                CallerMethodWrapper caller = (CallerMethodWrapper)((Object)parentElement);
                CallHierarchyContentProvider.ensureDefaultExpandWithConstructors(caller);
                if (caller.getExpandWithConstructors()) {
                    IType type = caller.getMember().getDeclaringType();
                    try {
                        if (type.isAnonymous()) {
                            IType anonymousClass = type;
                            MethodCall anonymousConstructor = new MethodCall((IMember)anonymousClass);
                            CallerMethodWrapper anonymousWrapper = (CallerMethodWrapper)caller.createMethodWrapper(anonymousConstructor);
                            return new Object[]{anonymousWrapper, new RealCallers(methodWrapper, caller.getMethodCall())};
                        }
                        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
                        if (constructors.length == 0) {
                            constructors = new IType[]{type};
                        }
                        Object[] children2 = new Object[constructors.length + 1];
                        int j = 0;
                        while (j < constructors.length) {
                            MethodCall constructor = new MethodCall((IMember)constructors[j]);
                            CallerMethodWrapper constructorWrapper = (CallerMethodWrapper)caller.createMethodWrapper(constructor);
                            children2[j] = constructorWrapper;
                            ++j;
                        }
                        children2[constructors.length] = new RealCallers(methodWrapper, caller.getMethodCall());
                        return children2;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                        return null;
                    }
                }
            }
            if (this.fManager != null && (children = this.fManager.getChildren((Object)new DeferredMethodWrapper(this, methodWrapper))) != null) {
                return children;
            }
            return this.fetchChildren(methodWrapper);
        }
        return EMPTY_ARRAY;
    }

    static void ensureDefaultExpandWithConstructors(CallerMethodWrapper wrapper) {
        if (!wrapper.isExpandWithConstructorsSet() && CallHierarchyContentProvider.canExpandWithConstructors(wrapper)) {
            IType type = wrapper.getMember().getDeclaringType();
            try {
                boolean withConstructors = false;
                if (type != null) {
                    boolean anonymousPref = PreferenceConstants.getPreferenceStore().getBoolean(PREF_ANONYMOUS_EXPAND_WITH_CONSTRUCTORS);
                    if (anonymousPref && type.isAnonymous()) {
                        withConstructors = true;
                    } else if (CallHierarchyContentProvider.isInTheDefaultExpandWithConstructorList(type)) {
                        withConstructors = true;
                    }
                }
                wrapper.setExpandWithConstructors(withConstructors);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    static boolean canExpandWithConstructors(CallerMethodWrapper wrapper) {
        IMember member = wrapper.getMember();
        if (!(member instanceof IMethod)) {
            return false;
        }
        IMethod method = (IMethod)member;
        try {
            return !JdtFlags.isStatic((IMember)method) && !method.isConstructor();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    static boolean isInTheDefaultExpandWithConstructorList(IType type) {
        String[] superInterfaces;
        String superClass;
        String serializedTypes = PreferenceConstants.getPreferenceStore().getString(PREF_DEFAULT_EXPAND_WITH_CONSTRUCTORS);
        if (serializedTypes.length() == 0) {
            return false;
        }
        String[] defaultTypes = serializedTypes.split(";");
        String typeName = type.getFullyQualifiedName('.');
        try {
            superClass = type.getSuperclassName();
            superInterfaces = type.getSuperInterfaceNames();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int i = 0;
        while (i < defaultTypes.length) {
            String defaultType = defaultTypes[i];
            if (typeName.equals(defaultType) || superClass != null && CallHierarchyContentProvider.typeNameMatches(superClass, defaultType)) {
                return true;
            }
            if (superInterfaces.length > 0) {
                int j = 0;
                while (j < superInterfaces.length) {
                    if (CallHierarchyContentProvider.typeNameMatches(superInterfaces[j], defaultType)) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean typeNameMatches(String nameA, String nameB) {
        if (nameA.equals(nameB)) {
            return true;
        }
        if (nameB.endsWith(nameA) && nameB.lastIndexOf(46) == nameB.length() - nameA.length() - 1) {
            return true;
        }
        return nameA.endsWith(nameB) && nameA.lastIndexOf(46) == nameA.length() - nameB.length() - 1;
    }

    protected Object[] fetchChildren(MethodWrapper methodWrapper) {
        MethodWrapperRunnable runnable;
        block3: {
            IWorkbenchWindow context = JavaPlugin.getActiveWorkbenchWindow();
            runnable = new MethodWrapperRunnable(methodWrapper);
            try {
                context.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, CallHierarchyMessages.CallHierarchyContentProvider_searchError_title, CallHierarchyMessages.CallHierarchyContentProvider_searchError_message);
                return EMPTY_ARRAY;
            }
            catch (InterruptedException interruptedException) {
                final CallerMethodWrapper element = (CallerMethodWrapper)methodWrapper;
                if (CallHierarchyContentProvider.isExpandWithConstructors(element)) break block3;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        CallHierarchyContentProvider.this.collapseAndRefresh(element);
                    }
                });
            }
        }
        return runnable.getCalls();
    }

    static boolean isExpandWithConstructors(MethodWrapper element) {
        return element instanceof CallerMethodWrapper && ((CallerMethodWrapper)element).getExpandWithConstructors();
    }

    protected void collapseAndRefresh(MethodWrapper element) {
        CallHierarchyViewer viewer = this.fPart.getViewer();
        boolean elementStays = true;
        if (element instanceof RealCallers) {
            elementStays = CallHierarchyContentProvider.isExpandWithConstructors(element.getParent());
        }
        if (elementStays) {
            viewer.setExpandedState((Object)element, false);
        }
        viewer.refresh((Object)element);
    }

    public CallHierarchyViewPart getViewPart() {
        return this.fPart;
    }

    private boolean shouldStopTraversion(MethodWrapper methodWrapper) {
        return methodWrapper.getLevel() > CallHierarchyUI.getDefault().getMaxCallDepth() || methodWrapper.isRecursive();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof MethodWrapper) {
            return ((MethodWrapper)((Object)element)).getParent();
        }
        return null;
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        if (element == TreeRoot.EMPTY_ROOT || element == TreeTermination.SEARCH_CANCELED) {
            return false;
        }
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)element);
            if (!methodWrapper.canHaveChildren()) {
                return false;
            }
            return !this.shouldStopTraversion(methodWrapper);
        }
        if (element instanceof TreeRoot) {
            return true;
        }
        return element instanceof DeferredMethodWrapper;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput instanceof TreeRoot) {
            MethodWrapper[] roots = ((TreeRoot)oldInput).getRoots();
            this.cancelJobs(roots);
        }
        if (viewer instanceof AbstractTreeViewer) {
            this.fManager = new DeferredTreeContentManager((AbstractTreeViewer)viewer, this.fPart.getSite());
        }
    }

    void cancelJobs(MethodWrapper[] wrappers) {
        if (this.fManager != null && wrappers != null) {
            int i = 0;
            while (i < wrappers.length) {
                MethodWrapper wrapper = wrappers[i];
                this.fManager.cancel((Object)wrapper);
                ++i;
            }
            if (this.fPart != null) {
                this.fPart.setCancelEnabled(false);
            }
        }
    }

    public void doneFetching() {
        if (this.fPart != null) {
            this.fPart.setCancelEnabled(false);
        }
    }

    public void startFetching() {
        if (this.fPart != null) {
            this.fPart.setCancelEnabled(true);
        }
    }

    private class MethodWrapperRunnable
    implements IRunnableWithProgress {
        private MethodWrapper fMethodWrapper;
        private MethodWrapper[] fCalls = null;

        MethodWrapperRunnable(MethodWrapper methodWrapper) {
            this.fMethodWrapper = methodWrapper;
        }

        public void run(IProgressMonitor pm) {
            this.fCalls = this.fMethodWrapper.getCalls(pm);
        }

        MethodWrapper[] getCalls() {
            if (this.fCalls != null) {
                return this.fCalls;
            }
            return new MethodWrapper[0];
        }
    }
}

