/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.CalleeAnalyzerVisitor;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;

class CalleeMethodWrapper
extends MethodWrapper {
    private Comparator fMethodWrapperComparator = new MethodWrapperComparator();

    public CalleeMethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        super(parent, methodCall);
    }

    public MethodWrapper[] getCalls(IProgressMonitor progressMonitor) {
        MethodWrapper[] result = super.getCalls(progressMonitor);
        Arrays.sort(result, this.fMethodWrapperComparator);
        return result;
    }

    protected String getTaskName() {
        return CallHierarchyMessages.CalleeMethodWrapper_taskname;
    }

    protected MethodWrapper createMethodWrapper(MethodCall methodCall) {
        return new CalleeMethodWrapper(this, methodCall);
    }

    public boolean canHaveChildren() {
        return true;
    }

    protected Map findChildren(IProgressMonitor progressMonitor) {
        IMember member = this.getMember();
        if (member.exists()) {
            CompilationUnit cu = CallHierarchy.getCompilationUnitNode(member, true);
            if (progressMonitor != null) {
                progressMonitor.worked(5);
            }
            if (cu != null) {
                CalleeAnalyzerVisitor visitor = new CalleeAnalyzerVisitor(member, cu, progressMonitor);
                cu.accept((ASTVisitor)visitor);
                return visitor.getCallees();
            }
        }
        return new HashMap(0);
    }

    private static class MethodWrapperComparator
    implements Comparator {
        private MethodWrapperComparator() {
        }

        public int compare(Object o1, Object o2) {
            MethodWrapper m1 = (MethodWrapper)((Object)o1);
            MethodWrapper m2 = (MethodWrapper)((Object)o2);
            CallLocation callLocation1 = m1.getMethodCall().getFirstCallLocation();
            CallLocation callLocation2 = m2.getMethodCall().getFirstCallLocation();
            if (callLocation1 != null && callLocation2 != null) {
                if (callLocation1.getStart() == callLocation2.getStart()) {
                    return callLocation1.getEnd() - callLocation2.getEnd();
                }
                return callLocation1.getStart() - callLocation2.getStart();
            }
            return 0;
        }
    }
}

