/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.ui.internal.ApiToolsLabelProvider;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiBaselinePreferencePage;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class ApiBaselineWizardPage
extends WizardPage {
    private IApiBaseline fProfile = null;
    private String originalname = null;
    private boolean contentchange = false;
    private boolean initializing = false;
    private Text nametext = null;
    private TreeViewer treeviewer = null;
    private Combo locationcombo = null;
    private Button browsebutton = null;
    private Button reloadbutton = null;
    static /* synthetic */ Class class$0;

    protected ApiBaselineWizardPage(IApiBaseline profile) {
        super(WizardMessages.ApiProfileWizardPage_1);
        this.fProfile = profile;
        this.setTitle(WizardMessages.ApiProfileWizardPage_1);
        if (profile == null) {
            this.setMessage(WizardMessages.ApiProfileWizardPage_3);
        } else {
            this.setMessage(WizardMessages.ApiProfileWizardPage_4);
        }
        this.setImageDescriptor(ApiUIPlugin.getImageDescriptor("IMG_WIZBAN_PROFILE"));
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 4, 1, 768);
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiProfileWizardPage_5, 1);
        this.nametext = SWTFactory.createText(comp, 2052, 3, 769);
        this.nametext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApiBaselineWizardPage.this.setPageComplete(ApiBaselineWizardPage.this.pageValid());
            }
        });
        IExecutionEnvironment[] envs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < envs.length) {
            if (envs[i].getCompatibleVMs().length > 0) {
                items.add(envs[i].getId());
            }
            ++i;
        }
        Collections.sort(items, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiProfileWizardPage_9, 1);
        this.locationcombo = SWTFactory.createCombo(comp, 2052, 1, 769, null);
        this.locationcombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApiBaselineWizardPage.this.setPageComplete(ApiBaselineWizardPage.this.pageValid());
                ApiBaselineWizardPage.this.updateButtons();
            }
        });
        this.browsebutton = SWTFactory.createPushButton(comp, WizardMessages.ApiProfileWizardPage_10, null);
        this.browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newPath;
                DirectoryDialog dialog = new DirectoryDialog(ApiBaselineWizardPage.this.getShell());
                dialog.setMessage(WizardMessages.ApiProfileWizardPage_11);
                String loctext = ApiBaselineWizardPage.this.locationcombo.getText().trim();
                if (loctext.length() > 0) {
                    dialog.setFilterPath(loctext);
                }
                if (!((newPath = dialog.open()) == null || new Path(loctext).equals((Object)new Path(newPath)) && ApiBaselineWizardPage.this.getCurrentComponents().length != 0)) {
                    ApiBaselineWizardPage.this.locationcombo.setText(newPath);
                    ApiBaselineWizardPage.this.setErrorMessage(null);
                    ApiBaselineWizardPage.this.doReload();
                }
            }
        });
        this.reloadbutton = SWTFactory.createPushButton(comp, WizardMessages.ApiProfileWizardPage_12, null);
        this.reloadbutton.setEnabled(this.locationcombo.getText().trim().length() > 0);
        this.reloadbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiBaselineWizardPage.this.doReload();
            }
        });
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiProfileWizardPage_13, 4);
        Tree tree = new Tree(comp, 67586);
        GridData gd = new GridData(768);
        gd.heightHint = 250;
        gd.horizontalSpan = 4;
        tree.setLayoutData((Object)gd);
        this.treeviewer = new TreeViewer(tree);
        this.treeviewer.setLabelProvider((IBaseLabelProvider)new ApiToolsLabelProvider());
        this.treeviewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeviewer.setComparator(new ViewerComparator());
        this.treeviewer.setInput((Object)this.getCurrentComponents());
        this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ApiBaselineWizardPage.this.updateButtons();
            }
        });
        this.treeviewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IApiComponent) {
                    IApiComponent component = (IApiComponent)element;
                    try {
                        if (component.isSourceComponent() || component.isSystemComponent()) {
                            return false;
                        }
                    }
                    catch (CoreException e) {
                        ApiPlugin.log((Throwable)e);
                    }
                    return true;
                }
                return !(element instanceof SystemLibraryApiComponent);
            }
        });
        this.setControl((Control)comp);
        this.setPageComplete(this.fProfile != null);
        this.initialize();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.APIPROFILES_WIZARD_PAGE);
        Dialog.applyDialogFont((Control)comp);
    }

    protected void initialize() {
        block14: {
            this.initializing = true;
            try {
                URL url;
                IPath path;
                if (this.fProfile != null) {
                    this.originalname = this.fProfile.getName();
                    WorkingCopyOperation op = new WorkingCopyOperation(this.fProfile);
                    try {
                        this.getContainer().run(false, false, (IRunnableWithProgress)op);
                    }
                    catch (InvocationTargetException e) {
                        ApiUIPlugin.log(e);
                    }
                    catch (InterruptedException e) {
                        ApiUIPlugin.log(e);
                    }
                    this.fProfile = op.getWorkingCopy();
                    this.nametext.setText(this.fProfile.getName());
                    IApiComponent[] components = this.fProfile.getApiComponents();
                    HashSet<String> locations = new HashSet<String>();
                    String loc = this.fProfile.getLocation();
                    Path location = null;
                    if (loc != null) {
                        location = new Path(loc);
                        if (location.toFile().isDirectory()) {
                            locations.add(location.removeTrailingSeparator().toOSString());
                        }
                    } else {
                        int i = 0;
                        while (i < components.length) {
                            if (!components[i].isSystemComponent() && (location = new Path(components[i].getLocation()).removeLastSegments(1)).toFile().isDirectory()) {
                                locations.add(location.removeTrailingSeparator().toOSString());
                            }
                            ++i;
                        }
                    }
                    if (locations.size() > 0) {
                        this.locationcombo.setItems(locations.toArray(new String[locations.size()]));
                        this.locationcombo.select(0);
                    }
                    break block14;
                }
                Location location = Platform.getInstallLocation();
                if (location != null && (path = new Path((url = location.getURL()).getFile()).removeTrailingSeparator()).toFile().exists()) {
                    this.locationcombo.add(path.toOSString());
                    this.locationcombo.select(0);
                }
            }
            finally {
                this.initializing = false;
            }
        }
    }

    protected void doReload() {
        ReloadOperation op = new ReloadOperation(this.nametext.getText().trim(), this.locationcombo.getText().trim());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            this.treeviewer.setInput((Object)this.getCurrentComponents());
            this.treeviewer.refresh();
            this.setPageComplete(this.pageValid());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    protected boolean pageValid() {
        if (this.initializing) {
            return false;
        }
        this.setErrorMessage(null);
        if (!this.isNameValid(this.nametext.getText().trim())) {
            return false;
        }
        String text = this.locationcombo.getText().trim();
        if (text.length() < 1) {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_23);
            this.reloadbutton.setEnabled(false);
            return false;
        }
        if (!new Path(text).toFile().exists()) {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_24);
            this.reloadbutton.setEnabled(false);
            return false;
        }
        if (this.fProfile != null) {
            if (this.fProfile.getApiComponents().length == 0) {
                this.setErrorMessage(WizardMessages.ApiProfileWizardPage_2);
                return false;
            }
            IStatus status = this.fProfile.getExecutionEnvironmentStatus();
            if (status.getSeverity() == 4) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
        } else {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_location_needs_reset);
            return false;
        }
        return true;
    }

    private boolean isNameValid(String name) {
        if (name.length() < 1) {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_20);
            return false;
        }
        if (!name.equals(this.originalname) && ((ApiBaselineManager)ApiPlugin.getDefault().getApiBaselineManager()).isExistingProfileName(name) && !ApiBaselinePreferencePage.isRemovedBaseline(name)) {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_profile_with_that_name_exists);
            return false;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    protected IApiComponent[] getCurrentComponents() {
        if (this.fProfile != null) {
            return this.fProfile.getApiComponents();
        }
        return new IApiComponent[0];
    }

    protected void updateButtons() {
        String loctext = this.locationcombo.getText().trim();
        this.reloadbutton.setEnabled(loctext.length() > 0);
    }

    public IApiBaseline finish() throws IOException, CoreException {
        if (this.fProfile != null) {
            this.fProfile.setName(this.nametext.getText().trim());
        }
        return this.fProfile;
    }

    public boolean contentChanged() {
        return this.contentchange;
    }

    public void cancel() {
        if (this.fProfile != null) {
            this.fProfile.dispose();
        }
    }

    static class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IApiComponent) {
                try {
                    IApiComponent component = (IApiComponent)parentElement;
                    String[] ees = component.getExecutionEnvironments();
                    ArrayList<EEEntry> entries = new ArrayList<EEEntry>(ees.length);
                    int i = 0;
                    while (i < ees.length) {
                        entries.add(new EEEntry(ees[i]));
                        ++i;
                    }
                    return entries.toArray();
                }
                catch (CoreException e) {
                    ApiPlugin.log((Throwable)e);
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IApiComponent) {
                try {
                    IApiComponent component = (IApiComponent)element;
                    return component.getExecutionEnvironments().length > 0;
                }
                catch (CoreException e) {
                    ApiPlugin.log((Throwable)e);
                }
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IApiComponent[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class EEEntry {
        String name = null;

        public EEEntry(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    class ReloadOperation
    implements IRunnableWithProgress {
        private String location;
        private String name;

        public ReloadOperation(String name, String location) {
            this.location = location;
            this.name = name;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(WizardMessages.ApiProfileWizardPage_0, 10);
            Path path = new Path(this.location);
            File plugins = path.append("plugins").toFile();
            ApiUIPlugin apiUIPlugin = ApiUIPlugin.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITargetPlatformService service = (ITargetPlatformService)apiUIPlugin.acquireService(clazz.getName());
            IBundleContainer container = service.newProfileContainer(path.toOSString(), null);
            ITargetDefinition definition = service.newTarget();
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            container.resolve(definition, (IProgressMonitor)subMonitor);
            subMonitor.done();
            monitor.worked(1);
            IResolvedBundle[] bundles = container.getBundles();
            ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
            try {
                ApiBaselineWizardPage.this.fProfile = ApiModelFactory.newApiBaseline((String)this.name, (String)this.location);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            if (bundles.length > 0) {
                subMonitor = new SubProgressMonitor(monitor, 8);
                subMonitor.beginTask("", bundles.length);
                int i = 0;
                while (i < bundles.length) {
                    try {
                        IApiComponent component;
                        if (!bundles[i].isSourceBundle() && (component = ApiModelFactory.newApiComponent((IApiBaseline)ApiBaselineWizardPage.this.fProfile, (String)URIUtil.toFile((URI)bundles[i].getBundleInfo().getLocation()).getAbsolutePath())) != null) {
                            components.add(component);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    subMonitor.worked(1);
                    ++i;
                }
                subMonitor.done();
            } else {
                if (!plugins.exists() || !plugins.isDirectory()) {
                    plugins = path.toFile();
                }
                File[] files = this.scanLocation(plugins);
                monitor.worked(1);
                subMonitor = new SubProgressMonitor(monitor, 7);
                subMonitor.beginTask("", files.length);
                int i = 0;
                while (i < files.length) {
                    try {
                        IApiComponent component = ApiModelFactory.newApiComponent((IApiBaseline)ApiBaselineWizardPage.this.fProfile, (String)files[i].getPath());
                        if (component != null) {
                            components.add(component);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    subMonitor.worked(1);
                    ++i;
                }
                subMonitor.done();
            }
            try {
                ApiBaselineWizardPage.this.fProfile.addApiComponents(components.toArray(new IApiComponent[components.size()]));
                ApiBaselineWizardPage.this.contentchange = true;
            }
            catch (CoreException e) {
                ApiPlugin.log((Throwable)e);
            }
            monitor.worked(1);
            monitor.done();
        }

        private File[] scanLocation(File directory) {
            if (!directory.exists() && !directory.isDirectory()) {
                return new File[0];
            }
            HashSet<File> result = new HashSet<File>();
            File[] children = directory.listFiles();
            if (children != null) {
                int j = 0;
                while (j < children.length) {
                    result.add(children[j]);
                    ++j;
                }
            }
            return result.toArray(new File[result.size()]);
        }
    }

    static class WorkingCopyOperation
    implements IRunnableWithProgress {
        IApiBaseline original = null;
        IApiBaseline workingcopy = null;

        public WorkingCopyOperation(IApiBaseline original) {
            this.original = original;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                IApiComponent[] components = this.original.getApiComponents();
                SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)WizardMessages.ApiProfileWizardPage_create_working_copy, (int)(components.length + 1));
                localmonitor.subTask(WizardMessages.ApiProfileWizardPage_copy_profile_attribs);
                this.workingcopy = ApiModelFactory.newApiBaseline((String)this.original.getName(), (String)this.original.getLocation());
                localmonitor.worked(1);
                localmonitor.subTask(WizardMessages.ApiProfileWizardPage_copy_api_components);
                ArrayList<IApiComponent> comps = new ArrayList<IApiComponent>();
                IApiComponent comp = null;
                int i = 0;
                while (i < components.length) {
                    comp = ApiModelFactory.newApiComponent((IApiBaseline)this.workingcopy, (String)components[i].getLocation());
                    if (comp != null) {
                        comps.add(comp);
                    }
                    localmonitor.worked(1);
                    ++i;
                }
                this.workingcopy.addApiComponents(comps.toArray(new IApiComponent[comps.size()]));
            }
            catch (CoreException ce) {
                ApiUIPlugin.log(ce);
            }
        }

        public IApiBaseline getWorkingCopy() {
            return this.workingcopy;
        }
    }
}

