/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.PropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompoundQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.AbstractTargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.ResolvedBundle;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;

public class IUBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "InstallableUnit";
    private String[] fIds;
    private Version[] fVersions;
    private IInstallableUnit[] fUnits;
    private URI[] fRepos;
    private boolean fIncludeAllRequired = true;
    private boolean fIncludeMultipleEnvironments = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    IUBundleContainer(String[] ids, String[] versions, URI[] repositories) {
        this.fIds = ids;
        this.fVersions = new Version[versions.length];
        int i = 0;
        while (i < versions.length) {
            this.fVersions[i] = Version.create((String)versions[i]);
            ++i;
        }
        this.fRepos = repositories == null || repositories.length == 0 ? null : repositories;
    }

    IUBundleContainer(IInstallableUnit[] units, URI[] repositories) {
        this.fUnits = units;
        this.fIds = new String[units.length];
        this.fVersions = new Version[units.length];
        int i = 0;
        while (i < units.length) {
            this.fIds[i] = units[i].getId();
            this.fVersions[i] = units[i].getVersion();
            ++i;
        }
        this.fRepos = repositories == null || repositories.length == 0 ? null : repositories;
    }

    public String getLocation(boolean resolve) throws CoreException {
        return AbstractTargetHandle.BUNDLE_POOL.toOSString();
    }

    public String getType() {
        return TYPE;
    }

    protected IResolvedBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        if (this.fIncludeAllRequired) {
            return this.resolveWithPlanner(definition, monitor);
        }
        return this.resolveWithSlicer(definition, monitor);
    }

    private IResolvedBundle[] resolveWithPlanner(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        subMonitor.beginTask(Messages.IUBundleContainer_0, 200);
        IProfile profile = ((TargetDefinition)definition).getProfile();
        subMonitor.worked(10);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IInstallableUnit[] units = this.getInstallableUnits(profile);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(units);
        int i = 0;
        while (i < units.length) {
            IInstallableUnit unit = units[i];
            request.setInstallableUnitProfileProperty(unit, "org.eclipse.pde.core.installed_iu", (Object)Boolean.toString(true));
            ++i;
        }
        IPlanner planner = this.getPlanner();
        URI[] repositories = this.resolveRepositories();
        ProvisioningContext context = new ProvisioningContext(repositories);
        context.setArtifactRepositories(repositories);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        ProvisioningPlan plan = planner.getProvisioningPlan(request, context, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        IStatus status = plan.getStatus();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        ProvisioningPlan installerPlan = plan.getInstallerPlan();
        if (installerPlan != null) {
            PDECore.log((IStatus)new Status(1, "org.eclipse.pde.core", Messages.IUBundleContainer_6));
        }
        subMonitor.worked(10);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        PhaseSet phases = DefaultPhaseSet.createDefaultPhaseSet((int)(DefaultPhaseSet.PHASE_CHECK_TRUST | DefaultPhaseSet.PHASE_CONFIGURE | DefaultPhaseSet.PHASE_UNCONFIGURE | DefaultPhaseSet.PHASE_UNINSTALL));
        IEngine engine = this.getEngine();
        Operand[] operands = plan.getOperands();
        ArrayList<Object> allOps = new ArrayList<Object>(operands.length + 1);
        int i2 = 0;
        while (i2 < operands.length) {
            allOps.add(operands[i2]);
            ++i2;
        }
        allOps.add(new PropertyOperand("org.eclipse.pde.core.provision_mode", null, (Object)"planner"));
        allOps.add(new PropertyOperand("org.eclipse.pde.core.all_environments", null, (Object)Boolean.toString(false)));
        IStatus result = engine.perform(profile, phases, allOps.toArray(new Operand[allOps.size()]), context, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 140));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        if (!result.isOK()) {
            throw new CoreException(result);
        }
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)profile, (Dictionary)new Properties(), true, false, true, false, false);
        IQueryable slice = slicer.slice(units, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        BundleQuery query = new BundleQuery();
        Collector collector = new Collector();
        slice.query((Query)query, collector, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        LinkedHashMap<BundleInfo, IResolvedBundle> bundles = new LinkedHashMap<BundleInfo, IResolvedBundle>();
        IFileArtifactRepository repo = this.getBundlePool(profile);
        Iterator iterator = collector.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit unit = (IInstallableUnit)iterator.next();
            IArtifactKey[] artifacts = unit.getArtifacts();
            int i3 = 0;
            while (i3 < artifacts.length) {
                IResolvedBundle bundle;
                IArtifactKey key = artifacts[i3];
                File file = repo.getArtifactFile(key);
                if (file != null && (bundle = this.generateBundle(file)) != null) {
                    bundles.put(bundle.getBundleInfo(), bundle);
                }
                ++i3;
            }
        }
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IBundleContainer[] containers = definition.getBundleContainers();
        int i4 = 0;
        while (i4 < containers.length) {
            IUBundleContainer bc;
            IResolvedBundle[] included;
            IBundleContainer container = containers[i4];
            if (container == this) break;
            if (container instanceof IUBundleContainer && (included = (bc = (IUBundleContainer)container).getBundles()) != null) {
                int j = 0;
                while (j < included.length) {
                    bundles.remove(included[j].getBundleInfo());
                    ++j;
                }
            }
            ++i4;
        }
        subMonitor.worked(10);
        subMonitor.done();
        return bundles.values().toArray(new ResolvedBundle[bundles.size()]);
    }

    private IResolvedBundle[] resolveWithSlicer(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        subMonitor.beginTask(Messages.IUBundleContainer_0, 200);
        IProfile profile = ((TargetDefinition)definition).getProfile();
        subMonitor.worked(10);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IInstallableUnit[] units = this.getInstallableUnits(profile);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        URI[] repositories = this.resolveRepositories();
        int repoCount = repositories.length;
        if (repoCount == 0) {
            return new IResolvedBundle[0];
        }
        SubProgressMonitor loadMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 10);
        loadMonitor.beginTask(null, repoCount * 10);
        IMetadataRepository[] metadataRepos = new IMetadataRepository[repoCount];
        IMetadataRepositoryManager manager = this.getRepoManager();
        int i = 0;
        while (i < repoCount) {
            metadataRepos[i] = manager.loadRepository(repositories[i], (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)loadMonitor, 10));
            ++i;
        }
        loadMonitor.done();
        Object allMetadata = repoCount == 1 ? metadataRepos[0] : new CompoundQueryable((IQueryable[])metadataRepos);
        PermissiveSlicer slicer = null;
        if (this.getIncludeAllEnvironments()) {
            slicer = new PermissiveSlicer((IQueryable)allMetadata, (Dictionary)new Properties(), true, false, true, true, false);
        } else {
            Properties props = new Properties();
            props.setProperty("osgi.os", definition.getOS() != null ? definition.getOS() : Platform.getOS());
            props.setProperty("osgi.ws", definition.getWS() != null ? definition.getWS() : Platform.getWS());
            props.setProperty("osgi.arch", definition.getArch() != null ? definition.getArch() : Platform.getOSArch());
            props.setProperty("osgi.nl", definition.getNL() != null ? definition.getNL() : Platform.getNL());
            slicer = new PermissiveSlicer((IQueryable)allMetadata, (Dictionary)props, true, false, false, true, false);
        }
        IQueryable slice = slicer.slice(units, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        Collector collector = slice.query((Query)new InstallableUnitQuery(null), new Collector(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled() || collector.isEmpty()) {
            return new IResolvedBundle[0];
        }
        ArrayList<Object> operands = new ArrayList<Object>(collector.size());
        Iterator itor = collector.iterator();
        while (itor.hasNext()) {
            operands.add(new InstallableUnitOperand(null, (IInstallableUnit)itor.next()));
        }
        int i2 = 0;
        while (i2 < units.length) {
            IInstallableUnit unit = units[i2];
            operands.add(new InstallableUnitPropertyOperand(unit, "org.eclipse.pde.core.installed_iu", null, (Object)Boolean.toString(true)));
            ++i2;
        }
        operands.add(new PropertyOperand("org.eclipse.pde.core.provision_mode", null, (Object)"slicer"));
        operands.add(new PropertyOperand("org.eclipse.pde.core.all_environments", null, (Object)Boolean.toString(this.getIncludeAllEnvironments())));
        PhaseSet phases = DefaultPhaseSet.createDefaultPhaseSet((int)(DefaultPhaseSet.PHASE_CHECK_TRUST | DefaultPhaseSet.PHASE_CONFIGURE | DefaultPhaseSet.PHASE_UNCONFIGURE | DefaultPhaseSet.PHASE_UNINSTALL));
        IEngine engine = this.getEngine();
        ProvisioningContext context = new ProvisioningContext(repositories);
        context.setArtifactRepositories(repositories);
        IStatus result = engine.perform(profile, phases, operands.toArray(new Operand[operands.size()]), context, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 140));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        if (!result.isOK()) {
            throw new CoreException(result);
        }
        slicer = new PermissiveSlicer((IQueryable)profile, (Dictionary)new Properties(), true, false, true, false, false);
        slice = slicer.slice(units, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        collector = slice.query((Query)new BundleQuery(), new Collector(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        LinkedHashMap<BundleInfo, IResolvedBundle> bundles = new LinkedHashMap<BundleInfo, IResolvedBundle>();
        IFileArtifactRepository repo = this.getBundlePool(profile);
        Iterator iterator = collector.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit unit = (IInstallableUnit)iterator.next();
            IArtifactKey[] artifacts = unit.getArtifacts();
            int i3 = 0;
            while (i3 < artifacts.length) {
                IResolvedBundle bundle;
                IArtifactKey key = artifacts[i3];
                File file = repo.getArtifactFile(key);
                if (file != null && (bundle = this.generateBundle(file)) != null) {
                    bundles.put(bundle.getBundleInfo(), bundle);
                }
                ++i3;
            }
        }
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IBundleContainer[] containers = definition.getBundleContainers();
        int i4 = 0;
        while (i4 < containers.length) {
            IUBundleContainer bc;
            IResolvedBundle[] included;
            IBundleContainer container = containers[i4];
            if (container == this) break;
            if (container instanceof IUBundleContainer && (included = (bc = (IUBundleContainer)container).getBundles()) != null) {
                int j = 0;
                while (j < included.length) {
                    bundles.remove(included[j].getBundleInfo());
                    ++j;
                }
            }
            ++i4;
        }
        subMonitor.worked(10);
        subMonitor.done();
        return bundles.values().toArray(new ResolvedBundle[bundles.size()]);
    }

    public synchronized IInstallableUnit[] getInstallableUnits(IProfile profile) throws CoreException {
        if (this.fUnits == null) {
            this.fUnits = new IInstallableUnit[this.fIds.length];
            int i = 0;
            while (i < this.fIds.length) {
                InstallableUnitQuery query = new InstallableUnitQuery(this.fIds[i], this.fVersions[i]);
                Collector collector = profile.query((Query)query, new Collector(), null);
                if (collector.isEmpty()) {
                    URI[] repositories = this.resolveRepositories();
                    int j = 0;
                    while (j < repositories.length) {
                        IMetadataRepository repository = this.getRepository(repositories[j]);
                        collector = repository.query((Query)query, new Collector(), null);
                        if (!collector.isEmpty()) break;
                        ++j;
                    }
                }
                if (collector.isEmpty()) {
                    this.fUnits = null;
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.IUBundleContainer_1, (Object)this.fIds[i])));
                }
                this.fUnits[i] = (IInstallableUnit)collector.iterator().next();
                ++i;
            }
        }
        return this.fUnits;
    }

    private IMetadataRepository getRepository(URI uri) throws CoreException {
        IMetadataRepositoryManager manager = this.getRepoManager();
        IMetadataRepository repo = manager.loadRepository(uri, null);
        return repo;
    }

    private IMetadataRepositoryManager getRepoManager() throws CoreException {
        IMetadataRepositoryManager manager;
        PDECore pDECore = PDECore.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)pDECore.acquireService(clazz.getName())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_2));
        }
        return manager;
    }

    private IFileArtifactRepository getBundlePool(IProfile profile) throws CoreException {
        String path = profile.getProperty("org.eclipse.equinox.p2.cache");
        if (path != null) {
            URI uri = new File(path).toURI();
            IArtifactRepositoryManager manager = this.getArtifactRepositoryManager();
            try {
                return (IFileArtifactRepository)manager.loadRepository(uri, null);
            }
            catch (ProvisionException provisionException) {}
        }
        return null;
    }

    private IArtifactRepositoryManager getArtifactRepositoryManager() throws CoreException {
        IArtifactRepositoryManager manager;
        PDECore pDECore = PDECore.getDefault();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)pDECore.acquireService(clazz.getName())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_3));
        }
        return manager;
    }

    private IEngine getEngine() throws CoreException {
        IEngine engine = (IEngine)PDECore.getDefault().acquireService(IEngine.SERVICE_NAME);
        if (engine == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_4));
        }
        return engine;
    }

    private IPlanner getPlanner() throws CoreException {
        IPlanner planner;
        PDECore pDECore = PDECore.getDefault();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((planner = (IPlanner)pDECore.acquireService(clazz.getName())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_5));
        }
        return planner;
    }

    public boolean isContentEqual(AbstractBundleContainer container) {
        IUBundleContainer iuContainer;
        if (container instanceof IUBundleContainer && (iuContainer = (IUBundleContainer)container).getIncludeAllRequired() == this.getIncludeAllRequired() && (this.getIncludeAllRequired() || iuContainer.getIncludeAllEnvironments() == this.getIncludeAllEnvironments()) && this.isEqualOrNull(this.fIds, iuContainer.fIds) && this.isEqualOrNull(this.fVersions, iuContainer.fVersions) && this.isEqualOrNull(this.fRepos, iuContainer.fRepos)) {
            return super.isContentEqual(container);
        }
        return false;
    }

    public URI[] getRepositories() {
        return this.fRepos;
    }

    private URI[] resolveRepositories() throws CoreException {
        if (this.fRepos == null) {
            IMetadataRepositoryManager manager = this.getRepoManager();
            return manager.getKnownRepositories(0);
        }
        return this.fRepos;
    }

    public void setIncludeAllRequired(boolean include, ITargetDefinition definition) {
        IBundleContainer[] containers;
        this.fIncludeAllRequired = include;
        if (definition != null && (containers = definition.getBundleContainers()) != null) {
            int i = 0;
            while (i < containers.length) {
                if (containers[i] instanceof IUBundleContainer && containers[i] != this) {
                    ((IUBundleContainer)containers[i]).setIncludeAllRequired(include, null);
                }
                ++i;
            }
        }
    }

    public boolean getIncludeAllRequired() {
        return this.fIncludeAllRequired;
    }

    public void setIncludeAllEnvironments(boolean include, ITargetDefinition definition) {
        IBundleContainer[] containers;
        this.fIncludeMultipleEnvironments = include;
        if (definition != null && (containers = definition.getBundleContainers()) != null) {
            int i = 0;
            while (i < containers.length) {
                if (containers[i] instanceof IUBundleContainer && containers[i] != this) {
                    ((IUBundleContainer)containers[i]).setIncludeAllEnvironments(include, null);
                }
                ++i;
            }
        }
    }

    public boolean getIncludeAllEnvironments() {
        return this.fIncludeMultipleEnvironments;
    }

    String[] getIds() {
        return this.fIds;
    }

    Version[] getVersions() {
        return this.fVersions;
    }

    class BundleQuery
    extends MatchQuery {
        BundleQuery() {
        }

        public boolean isMatch(Object candidate) {
            if (candidate instanceof IInstallableUnit) {
                IInstallableUnit unit = (IInstallableUnit)candidate;
                IProvidedCapability[] provided = unit.getProvidedCapabilities();
                int i = 0;
                while (i < provided.length) {
                    if (provided[i].getNamespace().equals("osgi.bundle")) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

