/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.bre.Function_temp;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

public class BirtDuration
implements IScriptFunctionExecutor {
    private IScriptFunctionExecutor executor;
    private static final String PLUGIN_ID = "org.eclipse.birt.core.function";

    public BirtDuration(String functionName) throws BirtException {
        if ("year".equals(functionName)) {
            this.executor = new Function_Year();
        } else if ("month".equals(functionName)) {
            this.executor = new Function_Month();
        } else if ("day".equals(functionName)) {
            this.executor = new Function_Day();
        } else if ("hour".equals(functionName)) {
            this.executor = new Function_Hours();
        } else if ("minute".equals(functionName)) {
            this.executor = new Function_Minutes();
        } else if ("second".equals(functionName)) {
            this.executor = new Function_Seconds();
        } else if ("timeInMills".equals(functionName)) {
            this.executor = new Function_TimeInMills();
        } else if ("isLongerThan".equals(functionName)) {
            this.executor = new Function_Longer();
        } else if ("isShorterThan".equals(functionName)) {
            this.executor = new Function_Shorter();
        } else if ("getSign".equals(functionName)) {
            this.executor = new Function_GetSign();
        } else if ("multiply".equals(functionName)) {
            this.executor = new Function_Multiply();
        } else if ("negate".equals(functionName)) {
            this.executor = new Function_Negate();
        } else if ("subtract".equals(functionName)) {
            this.executor = new Function_Subtract();
        } else if ("add".equals(functionName)) {
            this.executor = new Function_Add();
        } else if ("addTo".equals(functionName)) {
            this.executor = new Function_AddTo();
        } else if ("compare".equals(functionName)) {
            this.executor = new Function_Compare();
        } else {
            throw new BirtException(PLUGIN_ID, null, (Object)(String.valueOf(Messages.getString("invalid.function.name")) + "BirtDuration." + functionName));
        }
    }

    public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
        return this.executor.execute(arguments, context);
    }

    private class Function_Add
    extends Function_temp {
        Function_Add() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.add(duration2).toString();
        }
    }

    private class Function_AddTo
    extends Function_temp {
        Function_AddTo() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Date date;
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
                date = DataTypeUtil.toDate((Object)args[1]);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            duration.addTo(date);
            return date;
        }
    }

    private class Function_Compare
    extends Function_temp {
        Function_Compare() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.compare(duration2);
        }
    }

    private class Function_Day
    extends Function_temp {
        Function_Day() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getDays();
        }
    }

    private class Function_GetSign
    extends Function_temp {
        Function_GetSign() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration.getSign();
        }
    }

    private class Function_Hours
    extends Function_temp {
        Function_Hours() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getHours();
        }
    }

    private class Function_Longer
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Longer() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.isLongerThan(duration2);
        }
    }

    private class Function_Minutes
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Minutes() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getMinutes();
        }
    }

    private class Function_Month
    extends Function_temp {
        Function_Month() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getMonths();
        }
    }

    private class Function_Multiply
    extends Function_temp {
        Function_Multiply() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            int factor;
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
                factor = DataTypeUtil.toInteger((Object)args[1]);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration.multiply(factor).toString();
        }
    }

    private class Function_Negate
    extends Function_temp {
        Function_Negate() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration.negate().toString();
        }
    }

    private class Function_Seconds
    extends Function_temp {
        Function_Seconds() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getSeconds();
        }
    }

    private class Function_Shorter
    extends Function_temp {
        Function_Shorter() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.isShorterThan(duration2);
        }
    }

    private class Function_Subtract
    extends Function_temp {
        Function_Subtract() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.subtract(duration2).toString();
        }
    }

    private class Function_TimeInMills
    extends Function_temp {
        Function_TimeInMills() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getTimeInMillis(DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private class Function_Year
    extends Function_temp {
        Function_Year() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getYears();
        }
    }
}

