/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.Meta;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RtfInfoElement
extends RtfElement {
    private static final byte[] INFO_AUTHOR = "\\author".getBytes();
    private static final byte[] INFO_SUBJECT = "\\subject".getBytes();
    private static final byte[] INFO_KEYWORDS = "\\keywords".getBytes();
    private static final byte[] INFO_TITLE = "\\title".getBytes();
    private static final byte[] INFO_PRODUCER = "\\operator".getBytes();
    private static final byte[] INFO_CREATION_DATE = "\\creationdate".getBytes();
    private int infoType = -1;
    private String content = "";

    public RtfInfoElement(RtfDocument rtfDocument, Meta meta) {
        super(rtfDocument);
        this.infoType = meta.type();
        this.content = meta.content();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(OPEN_GROUP);
            switch (this.infoType) {
                case 4: {
                    byteArrayOutputStream.write(INFO_AUTHOR);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(INFO_SUBJECT);
                    break;
                }
                case 3: {
                    byteArrayOutputStream.write(INFO_KEYWORDS);
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(INFO_TITLE);
                    break;
                }
                case 5: {
                    byteArrayOutputStream.write(INFO_PRODUCER);
                    break;
                }
                case 6: {
                    byteArrayOutputStream.write(INFO_CREATION_DATE);
                    break;
                }
                default: {
                    byteArrayOutputStream.write(INFO_AUTHOR);
                }
            }
            byteArrayOutputStream.write(DELIMITER);
            if (this.infoType == 6) {
                byteArrayOutputStream.write(this.convertDate(this.content).getBytes());
            } else {
                byteArrayOutputStream.write(this.content.getBytes());
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    private String convertDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        try {
            Date date = simpleDateFormat.parse(string);
            simpleDateFormat = new SimpleDateFormat("\\'yr'yyyy\\'mo'MM\\'dy'dd\\'hr'HH\\'min'mm\\'sec'ss");
            return simpleDateFormat.format(date);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return "";
        }
    }
}

