/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.BasicPdfWriter;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.Type3Glyph;
import java.io.IOException;
import java.util.HashMap;

public class Type3Font
extends BaseFont {
    private boolean[] usedSlot;
    private IntHashtable widths3 = new IntHashtable();
    private HashMap char2glyph = new HashMap();
    private BasicPdfWriter writer;
    private float llx = Float.NaN;
    private float lly;
    private float urx;
    private float ury;
    private PageResources pageResources = new PageResources();
    private boolean colorized;

    public Type3Font(BasicPdfWriter basicPdfWriter, char[] cArray, boolean bl) {
        this(basicPdfWriter, bl);
    }

    public Type3Font(BasicPdfWriter basicPdfWriter, boolean bl) {
        this.writer = basicPdfWriter;
        this.colorized = bl;
        this.fontType = 5;
        this.usedSlot = new boolean[256];
    }

    public PdfContentByte defineGlyph(char c, float f, float f2, float f3, float f4, float f5) {
        if (c == '\u0000' || c > '\u00ff') {
            throw new IllegalArgumentException("The char " + c + " doesn't belong in this Type3 font");
        }
        this.usedSlot[c] = true;
        Integer n = new Integer(c);
        Type3Glyph type3Glyph = (Type3Glyph)this.char2glyph.get(n);
        if (type3Glyph != null) {
            return type3Glyph;
        }
        this.widths3.put(c, (int)f);
        if (!this.colorized) {
            if (Float.isNaN(this.llx)) {
                this.llx = f2;
                this.lly = f3;
                this.urx = f4;
                this.ury = f5;
            } else {
                this.llx = Math.min(this.llx, f2);
                this.lly = Math.min(this.lly, f3);
                this.urx = Math.max(this.urx, f4);
                this.ury = Math.max(this.ury, f5);
            }
        }
        type3Glyph = new Type3Glyph(this.writer, this.pageResources, f, f2, f3, f4, f5, this.colorized);
        this.char2glyph.put(n, type3Glyph);
        return type3Glyph;
    }

    public String[][] getFamilyFontName() {
        return new String[0][];
    }

    public float getFontDescriptor(int n, float f) {
        return 0.0f;
    }

    public String[][] getFullFontName() {
        return new String[0][];
    }

    public int getKerning(char c, char c2) {
        return 0;
    }

    public String getPostscriptFontName() {
        return "";
    }

    protected int[] getRawCharBBox(int n, String string) {
        return null;
    }

    int getRawWidth(int n, String string) {
        return 0;
    }

    public boolean hasKernPairs() {
        return false;
    }

    public boolean setKerning(char c, char c2, int n) {
        return false;
    }

    public void setPostscriptFontName(String string) {
    }

    void writeFont(BasicPdfWriter basicPdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        int n;
        int n2;
        if (this.writer != basicPdfWriter) {
            throw new IllegalArgumentException("Type3 font used with the wrong BasicPdfWriter");
        }
        for (n2 = 0; n2 < this.usedSlot.length && !this.usedSlot[n2]; ++n2) {
        }
        if (n2 == this.usedSlot.length) {
            throw new DocumentException("No glyphs defined for Type3 font");
        }
        for (n = this.usedSlot.length - 1; n >= n2 && !this.usedSlot[n]; --n) {
        }
        int[] nArray = new int[n - n2 + 1];
        int[] nArray2 = new int[n - n2 + 1];
        int n3 = 0;
        int n4 = 0;
        int n5 = n2;
        while (n5 <= n) {
            if (this.usedSlot[n5]) {
                nArray2[n3++] = n5;
                nArray[n4] = this.widths3.get(n5);
            }
            ++n5;
            ++n4;
        }
        PdfArray pdfArray = new PdfArray();
        PdfDictionary pdfDictionary = new PdfDictionary();
        int n6 = -1;
        for (int i = 0; i < n3; ++i) {
            int n7 = nArray2[i];
            if (n7 > n6) {
                n6 = n7;
                pdfArray.add(new PdfNumber(n6));
            }
            ++n6;
            int n8 = nArray2[i];
            String string = GlyphList.unicodeToName(n8);
            if (string == null) {
                string = "a" + n8;
            }
            PdfName pdfName = new PdfName(string);
            pdfArray.add(pdfName);
            Type3Glyph type3Glyph = (Type3Glyph)this.char2glyph.get(new Integer(n8));
            PdfStream pdfStream = new PdfStream(type3Glyph.toPdf(null));
            pdfStream.flateCompress();
            PdfIndirectReference pdfIndirectReference2 = basicPdfWriter.addToBody(pdfStream).getIndirectReference();
            pdfDictionary.put(pdfName, pdfIndirectReference2);
        }
        PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.FONT);
        pdfDictionary2.put(PdfName.SUBTYPE, PdfName.TYPE3);
        if (this.colorized) {
            pdfDictionary2.put(PdfName.FONTBBOX, new PdfRectangle(0.0f, 0.0f, 0.0f, 0.0f));
        } else {
            pdfDictionary2.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        }
        pdfDictionary2.put(PdfName.FONTMATRIX, new PdfArray(new float[]{0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f}));
        pdfDictionary2.put(PdfName.CHARPROCS, basicPdfWriter.addToBody(pdfDictionary).getIndirectReference());
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        pdfDictionary3.put(PdfName.DIFFERENCES, pdfArray);
        pdfDictionary2.put(PdfName.ENCODING, basicPdfWriter.addToBody(pdfDictionary3).getIndirectReference());
        pdfDictionary2.put(PdfName.FIRSTCHAR, new PdfNumber(n2));
        pdfDictionary2.put(PdfName.LASTCHAR, new PdfNumber(n));
        pdfDictionary2.put(PdfName.WIDTHS, basicPdfWriter.addToBody(new PdfArray(nArray)).getIndirectReference());
        if (this.pageResources.hasResources()) {
            pdfDictionary2.put(PdfName.RESOURCES, basicPdfWriter.addToBody(this.pageResources.getResources()).getIndirectReference());
        }
        basicPdfWriter.addToBody((PdfObject)pdfDictionary2, pdfIndirectReference);
    }

    byte[] convertToBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (!this.charExists(c)) continue;
            byArray[n++] = (byte)c;
        }
        if (byArray.length == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    byte[] convertToBytes(char c) {
        if (this.charExists(c)) {
            return new byte[]{(byte)c};
        }
        return new byte[0];
    }

    public int getWidth(char c) {
        if (!this.widths3.containsKey(c)) {
            throw new IllegalArgumentException("The char " + c + " is not defined in a Type3 font");
        }
        return this.widths3.get(c);
    }

    public int getWidth(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            n += this.getWidth(cArray[i]);
        }
        return n;
    }

    public int[] getCharBBox(char c) {
        return null;
    }

    public boolean charExists(char c) {
        if (c > '\u0000' && c < '\u0100') {
            return this.usedSlot[c];
        }
        return false;
    }

    public boolean setCharAdvance(char c, int n) {
        return false;
    }
}

