/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.BasicPdfWriter;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class PdfFileSpecification
extends PdfDictionary {
    protected BasicPdfWriter writer;
    protected PdfIndirectReference ref;

    public PdfFileSpecification() {
        super(PdfName.FILESPEC);
    }

    public static PdfFileSpecification url(BasicPdfWriter basicPdfWriter, String string) {
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        pdfFileSpecification.writer = basicPdfWriter;
        pdfFileSpecification.put(PdfName.FS, PdfName.URL);
        pdfFileSpecification.put(PdfName.F, new PdfString(string));
        return pdfFileSpecification;
    }

    public static PdfFileSpecification fileEmbedded(BasicPdfWriter basicPdfWriter, String string, String string2, byte[] byArray) throws IOException {
        return PdfFileSpecification.fileEmbedded(basicPdfWriter, string, string2, byArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PdfFileSpecification fileEmbedded(BasicPdfWriter basicPdfWriter, String string, String string2, byte[] byArray, boolean bl) throws IOException {
        PdfIndirectReference pdfIndirectReference;
        Object object;
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        pdfFileSpecification.writer = basicPdfWriter;
        pdfFileSpecification.put(PdfName.F, new PdfString(string2));
        InputStream inputStream = null;
        try {
            PdfStream pdfStream;
            PdfIndirectReference pdfIndirectReference2 = basicPdfWriter.getPdfIndirectReference();
            if (byArray == null) {
                object = new File(string);
                if (((File)object).canRead()) {
                    inputStream = new FileInputStream(string);
                } else if (string.startsWith("file:/") || string.startsWith("http://") || string.startsWith("https://") || string.startsWith("jar:")) {
                    inputStream = new URL(string).openStream();
                } else {
                    inputStream = BaseFont.getResourceStream(string);
                    if (inputStream == null) {
                        throw new IOException(string + " not found as file or resource.");
                    }
                }
                pdfStream = new PdfStream(inputStream, basicPdfWriter);
            } else {
                pdfStream = new PdfStream(byArray);
            }
            pdfStream.put(PdfName.TYPE, PdfName.EMBEDDEDFILE);
            if (bl) {
                pdfStream.flateCompress();
            }
            pdfStream.put(PdfName.PARAMS, pdfIndirectReference2);
            pdfIndirectReference = basicPdfWriter.addToBody(pdfStream).getIndirectReference();
            if (byArray == null) {
                pdfStream.writeLength();
            }
            object = new PdfDictionary();
            ((PdfDictionary)object).put(PdfName.SIZE, new PdfNumber(pdfStream.getRawLength()));
            basicPdfWriter.addToBody((PdfObject)object, pdfIndirectReference2);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        object = new PdfDictionary();
        ((PdfDictionary)object).put(PdfName.F, pdfIndirectReference);
        pdfFileSpecification.put(PdfName.EF, (PdfObject)object);
        return pdfFileSpecification;
    }

    public static PdfFileSpecification fileExtern(BasicPdfWriter basicPdfWriter, String string) {
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        pdfFileSpecification.writer = basicPdfWriter;
        pdfFileSpecification.put(PdfName.F, new PdfString(string));
        return pdfFileSpecification;
    }

    public PdfIndirectReference getReference() throws IOException {
        if (this.ref != null) {
            return this.ref;
        }
        this.ref = this.writer.addToBody(this).getIndirectReference();
        return this.ref;
    }

    public void setMultiByteFileName(byte[] byArray) {
        this.put(PdfName.F, new PdfString(byArray).setHexWriting(true));
    }
}

