/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;

class CubeQueryValidator {
    private CubeQueryValidator() {
    }

    static void validateCubeQueryDefinition(BirtCubeView view, ICube cube) throws DataException {
        if (view.getColumnEdgeView() == null && view.getRowEdgeView() == null) {
            throw new DataException("data.olap.NoEdgeDefinitionFound");
        }
        if (view.getColumnEdgeView() != null) {
            CubeQueryValidator.validateOnEdgeDefinition(cube, view.getColumnEdgeView());
        }
        if (view.getRowEdgeView() != null) {
            CubeQueryValidator.validateOnEdgeDefinition(cube, view.getRowEdgeView());
        }
    }

    static void validateOnEdgeDefinition(ICube cube, BirtEdgeView edgeView) throws DataException {
        int i = 0;
        while (i < edgeView.getDimensionViews().size()) {
            BirtDimensionView birtDimensionView = (BirtDimensionView)edgeView.getDimensionViews().get(i);
            int j = 0;
            while (j < birtDimensionView.getMemberSelection().size()) {
                String hierarchyName;
                ILevelDefinition levelDefinition = (ILevelDefinition)birtDimensionView.getMemberSelection().get(j);
                String dimensionName = levelDefinition.getHierarchy().getDimension().getName();
                String levelName = levelDefinition.getName();
                if (!CubeQueryValidator.validateWithRawCube(cube, levelName, dimensionName, hierarchyName = levelDefinition.getHierarchy().getName())) {
                    throw new DataException("data.olap.CannotFindLevel", new Object[]{levelName, hierarchyName, dimensionName});
                }
                ++j;
            }
            ++i;
        }
    }

    static boolean validateWithRawCube(ICube cube, String levelName, String dimensionName, String hierarchyName) {
        boolean validate = false;
        int k = 0;
        while (k < cube.getDimesions().length) {
            if (cube.getDimesions()[k].isTime()) {
                return true;
            }
            if (dimensionName.equals(cube.getDimesions()[k].getName()) && hierarchyName.equals(cube.getDimesions()[k].getHierarchy().getName())) {
                int t = 0;
                while (t < cube.getDimesions()[k].getHierarchy().getLevels().length) {
                    if (levelName.equals(cube.getDimesions()[k].getHierarchy().getLevels()[t].getName())) {
                        validate = true;
                        return validate;
                    }
                    ++t;
                }
            }
            ++k;
        }
        return validate;
    }
}

