/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odi;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.DummyOutputStream;
import org.eclipse.birt.data.engine.odi.IAggrValueHolder;

public class AggrHolderManager {
    private List<IAggrValueHolder> holders = new ArrayList<IAggrValueHolder>();
    private HashMap<String, IAggrValueHolder> aggrIndex = new HashMap();

    public void addAggrValueHolder(IAggrValueHolder newHolder) throws DataException {
        this.holders.add(newHolder);
        Set<String> aggrNames = newHolder.getAggrNames();
        for (String aggrName : aggrNames) {
            this.aggrIndex.put(aggrName, newHolder);
        }
    }

    public void clear() throws DataException {
        this.holders.clear();
        this.aggrIndex.clear();
    }

    public Object getAggrValue(String aggrName) throws DataException {
        IAggrValueHolder holder = this.aggrIndex.get(aggrName);
        if (holder != null) {
            return holder.getAggrValue(aggrName);
        }
        throw new DataException("data.engine.InvalidBoundColumnName", aggrName);
    }

    public void doSave(OutputStream aggrIndexStream, OutputStream aggrStream) throws DataException {
        try {
            assert (aggrIndexStream instanceof DummyOutputStream);
            assert (aggrStream instanceof DummyOutputStream);
            DataOutputStream aggrIndexDos = new DataOutputStream(aggrIndexStream);
            DataOutputStream aggrDos = new DataOutputStream(aggrStream);
            IOUtil.writeInt((OutputStream)aggrIndexStream, (int)this.aggrIndex.size());
            for (IAggrValueHolder holder : this.holders) {
                for (String arrgBindingName : holder.getAggrNames()) {
                    IOUtil.writeString((DataOutputStream)aggrDos, (String)arrgBindingName);
                    IOUtil.writeString((DataOutputStream)aggrDos, (String)holder.getAggrInfo(arrgBindingName).getAggregation().getName());
                    IOUtil.writeInt((OutputStream)aggrDos, (int)holder.getAggrInfo(arrgBindingName).getGroupLevel());
                    List values = holder.getAggrValues(arrgBindingName);
                    assert (values.size() > 0);
                    IOUtil.writeInt((OutputStream)aggrStream, (int)values.size());
                    int i = 0;
                    while (i < values.size()) {
                        IOUtil.writeObject((DataOutputStream)aggrDos, values.get(i));
                        ++i;
                    }
                    IOUtil.writeLong((DataOutputStream)aggrIndexDos, (long)((DummyOutputStream)aggrStream).getOffset());
                }
            }
            aggrIndexStream.close();
            aggrStream.close();
            aggrIndexDos.close();
            aggrDos.close();
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public boolean isEmpty() {
        return this.aggrIndex.isEmpty();
    }
}

