/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ExpressionCollection;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;

public class ExprUtil {
    private static final int NULL_EXPRESSION = 0;
    private static final int SCRIPT_EXPRESSION = 1;
    private static final int CONDITIONAL_EXPRESSION = 2;
    private static final int COMBINED_EXPRESSION = 3;

    public static void saveBaseExpr(DataOutputStream dos, IBaseExpression baseExpr) throws IOException {
        if (baseExpr == null) {
            IOUtil.writeInt((OutputStream)dos, (int)0);
        } else if (baseExpr instanceof IScriptExpression) {
            IOUtil.writeInt((OutputStream)dos, (int)1);
            ExprUtil.saveScriptExpr(dos, (IScriptExpression)baseExpr);
        } else if (baseExpr instanceof IConditionalExpression) {
            IOUtil.writeInt((OutputStream)dos, (int)2);
            IConditionalExpression condExpr = (IConditionalExpression)baseExpr;
            ExprUtil.saveBaseExpr(dos, condExpr.getExpression());
            IOUtil.writeInt((OutputStream)dos, (int)condExpr.getOperator());
            ExprUtil.saveBaseExpr(dos, condExpr.getOperand1());
            ExprUtil.saveBaseExpr(dos, condExpr.getOperand2());
        } else if (baseExpr instanceof IExpressionCollection) {
            IOUtil.writeInt((OutputStream)dos, (int)3);
            IExpressionCollection combinedExpr = (IExpressionCollection)baseExpr;
            IOUtil.writeInt((OutputStream)dos, (int)combinedExpr.getDataType());
            Object[] exprs = combinedExpr.getExpressions().toArray();
            IOUtil.writeInt((OutputStream)dos, (int)exprs.length);
            int i = 0;
            while (i < exprs.length) {
                ExprUtil.saveBaseExpr(dos, (IBaseExpression)exprs[i]);
                ++i;
            }
        } else assert (false);
    }

    private static void saveScriptExpr(DataOutputStream dos, IScriptExpression scriptExpr) throws IOException {
        IOUtil.writeString((DataOutputStream)dos, (String)scriptExpr.getText());
        IOUtil.writeInt((OutputStream)dos, (int)scriptExpr.getDataType());
        IOUtil.writeString((DataOutputStream)dos, (String)scriptExpr.getGroupName());
    }

    public static IBaseExpression loadBaseExpr(DataInputStream dis) throws IOException {
        int exprType = IOUtil.readInt((InputStream)dis);
        if (exprType == 0) {
            return null;
        }
        if (exprType == 1) {
            return ExprUtil.loadScriptExpr(dis);
        }
        if (exprType == 2) {
            IScriptExpression expr = (IScriptExpression)ExprUtil.loadBaseExpr(dis);
            int operator = IOUtil.readInt((InputStream)dis);
            IBaseExpression op1 = ExprUtil.loadBaseExpr(dis);
            IBaseExpression op2 = ExprUtil.loadBaseExpr(dis);
            return new ConditionalExpression(expr, operator, op1, op2);
        }
        if (exprType == 3) {
            IOUtil.readInt((InputStream)dis);
            int size = IOUtil.readInt((InputStream)dis);
            IBaseExpression[] baseExpr = new IBaseExpression[size];
            int i = 0;
            while (i < size) {
                baseExpr[i] = ExprUtil.loadBaseExpr(dis);
                ++i;
            }
            return new ExpressionCollection(baseExpr);
        }
        assert (false);
        return null;
    }

    private static IScriptExpression loadScriptExpr(DataInputStream dis) throws IOException {
        ScriptExpression scriptExpr = new ScriptExpression(IOUtil.readString((DataInputStream)dis));
        scriptExpr.setDataType(IOUtil.readInt((InputStream)dis));
        scriptExpr.setGroupName(IOUtil.readString((DataInputStream)dis));
        return scriptExpr;
    }

    public static boolean isEqualExpression(IBaseExpression be, IBaseExpression be2) {
        if (be == be2) {
            return true;
        }
        if (be == null || be2 == null) {
            return false;
        }
        if (be instanceof IScriptExpression && be2 instanceof IScriptExpression) {
            IScriptExpression se = (IScriptExpression)be;
            IScriptExpression se2 = (IScriptExpression)be2;
            return ExprUtil.isEqualExpression2(se, se2);
        }
        if (be instanceof IConditionalExpression && be2 instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)be;
            IConditionalExpression ce2 = (IConditionalExpression)be2;
            return ce.getDataType() == ce2.getDataType() && ce.getOperator() == ce2.getOperator() && ExprUtil.isEqualExpression(ce.getExpression(), ce2.getExpression()) && ExprUtil.isEqualExpression(ce.getOperand1(), ce2.getOperand1()) && ExprUtil.isEqualExpression(ce.getOperand2(), ce2.getOperand2());
        }
        if (be instanceof IExpressionCollection && be2 instanceof IExpressionCollection) {
            return be.getDataType() == be2.getDataType() && ExprUtil.isEqualExpressionArray(((IExpressionCollection)be).getExpressions(), ((IExpressionCollection)be2).getExpressions());
        }
        return false;
    }

    private static boolean isEqualExpression2(IScriptExpression se, IScriptExpression se2) {
        if (se == se2) {
            return true;
        }
        if (se == null || se2 == null) {
            return false;
        }
        return se.getDataType() == se2.getDataType() && ExprUtil.isEqualObject(se.getText(), se2.getText());
    }

    private static boolean isEqualExpressionArray(Collection op1, Collection op2) {
        Object[] operands2;
        if (op1 == op2) {
            return true;
        }
        Object[] operands1 = op1.toArray();
        if (operands1.length != (operands2 = op2.toArray()).length) {
            return false;
        }
        int i = 0;
        while (i < operands1.length) {
            if (!ExprUtil.isEqualExpression((IBaseExpression)operands1[i], (IBaseExpression)operands2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isEqualObject(Object ob1, Object ob2) {
        if (ob1 == ob2) {
            return true;
        }
        if (ob1 == null || ob2 == null) {
            return false;
        }
        return ob1.equals(ob2);
    }

    public static int hashCode(IBaseExpression be) {
        if (be == null) {
            return 0;
        }
        if (be instanceof IScriptExpression) {
            return ExprUtil.hashCode2((IScriptExpression)be);
        }
        if (be instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)be;
            return ce.getDataType() + ce.getOperator() + ExprUtil.hashCode2(ce.getExpression()) + ExprUtil.hashCode2(ce.getOperand1()) + ExprUtil.hashCode2(ce.getOperand2());
        }
        return 0;
    }

    private static int hashCode2(IBaseExpression se) {
        if (se == null) {
            return 0;
        }
        if (se instanceof IScriptExpression) {
            return se.getDataType() + ((IScriptExpression)se).getText().trim().hashCode();
        }
        if (se instanceof IExpressionCollection) {
            int hashCode = 0;
            Object[] exprs = ((IExpressionCollection)se).getExpressions().toArray();
            int i = 0;
            while (i < exprs.length) {
                hashCode += ExprUtil.hashCode2((IBaseExpression)exprs[i]);
                ++i;
            }
            return se.getDataType() + hashCode;
        }
        return 0;
    }
}

