/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;

class GroupBindingColumn {
    private int groupLevel;
    private String groupKey;
    private Map bindings;
    private static Logger logger = Logger.getLogger(GroupBindingColumn.class.getName());

    GroupBindingColumn(String groupKey, int groupLevel, Map bindings) {
        Object[] params = new Object[]{groupKey, new Integer(groupLevel), bindings};
        logger.entering(GroupBindingColumn.class.getName(), "GroupBindingColumn", params);
        this.groupKey = groupKey;
        this.groupLevel = groupLevel;
        this.bindings = bindings;
        logger.exiting(GroupBindingColumn.class.getName(), "GroupBindingColumn");
    }

    String getGroupKey() {
        return this.groupKey;
    }

    int getGroupLevel() {
        return this.groupLevel;
    }

    Set getColumnNames() {
        return this.bindings.keySet();
    }

    IBaseExpression getExpression(String name) throws DataException {
        if (this.bindings.containsKey(name)) {
            return ((IBinding)this.bindings.get(name)).getExpression();
        }
        return null;
    }

    IBinding getBinding(String name) throws DataException {
        if (this.bindings.containsKey(name)) {
            return (IBinding)this.bindings.get(name);
        }
        return null;
    }
}

