/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IBindingMetaInfo;
import org.eclipse.birt.report.data.adapter.api.IDimensionLevel;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatAdapter;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SortkeyBuilder;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.widget.ExpressionValueCellEditor;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.SortElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CrosstabSortKeyBuilder
extends SortkeyBuilder {
    protected static final String VALUE_OF_THIS_DATA_ITEM = Messages.getString("CrosstabSortKeyBuilder.choice.ValueOfThisDataItem");
    protected final String[] columns = new String[]{" ", Messages.getString("SelColumnMemberValue.Column.Level"), Messages.getString("SelColumnMemberValue.Column.Value")};
    protected SortElementHandle sortElementHandle;
    protected List groupLevelList;
    protected List groupLevelNameList;
    protected Combo textKey;
    protected Combo comboGroupLevel;
    protected LevelViewHandle levelViewHandle;
    protected Table memberValueTable;
    protected TableViewer dynamicViewer;
    protected MemberValueHandle memberValueHandle;
    protected List referencedLevelList;
    protected Group group;
    private Combo comboLocale;
    private Combo comboStrength;
    protected Listener comboGroupLeveModify = new Listener(){

        public void handleEvent(Event e) {
            CrosstabSortKeyBuilder.this.updateBindings();
            CrosstabSortKeyBuilder.this.updateMemberValues();
        }
    };
    protected Listener comboKeySelection = new Listener(){

        public void handleEvent(Event e) {
            String newValue = CrosstabSortKeyBuilder.this.textKey.getText();
            if (newValue.length() > 0 && CrosstabSortKeyBuilder.this.textKey.getItemCount() > 0 && CrosstabSortKeyBuilder.this.textKey.indexOf(newValue) != -1) {
                String value;
                IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)CrosstabSortKeyBuilder.this.textKey);
                if (converter != null && (value = converter.getCubeBindingExpression(newValue)) != null) {
                    newValue = value;
                }
                CrosstabSortKeyBuilder.this.textKey.setText(newValue);
            }
            CrosstabSortKeyBuilder.this.updateMemberValues();
            CrosstabSortKeyBuilder.this.updateButtons();
        }
    };
    private ISelectionChangedListener selectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object obj;
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) != null && obj instanceof MemberValueHandle && CrosstabSortKeyBuilder.this.editor != null) {
                CrosstabSortKeyBuilder.this.editor.setMemberValue((MemberValueHandle)obj);
            }
        }
    };
    private static final String dummyChoice = "dummy";
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputObj) {
            if (!(inputObj instanceof List)) {
                return new Object[0];
            }
            return ((List)inputObj).toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element == CrosstabSortKeyBuilder.dummyChoice) {
                    return Messages.getString("CrosstabSortKeyBuilder.MSG.CreateNew");
                }
                if (element instanceof RuleHandle) {
                    return ((RuleHandle)element).getDisplayExpression();
                }
                return "";
            }
            if (columnIndex == 1) {
                return ((MemberValueHandle)element).getLevel().getName();
            }
            if (columnIndex == 2) {
                String value = ((MemberValueHandle)element).getValue();
                return value == null ? "" : value;
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ICellModifier cellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            return Arrays.asList(CrosstabSortKeyBuilder.this.columns).indexOf(property) == 2;
        }

        public Object getValue(Object element, String property) {
            if (Arrays.asList(CrosstabSortKeyBuilder.this.columns).indexOf(property) != 2) {
                return "";
            }
            String value = ((MemberValueHandle)element).getValue();
            return value == null ? "" : value;
        }

        public void modify(Object element, String property, Object value) {
            if (Arrays.asList(CrosstabSortKeyBuilder.this.columns).indexOf(property) != 2) {
                return;
            }
            TableItem item = (TableItem)element;
            MemberValueHandle memberValue = (MemberValueHandle)item.getData();
            try {
                memberValue.setValue((String)value);
            }
            catch (SemanticException e) {
                CrosstabSortKeyBuilder.this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            CrosstabSortKeyBuilder.this.dynamicViewer.refresh();
        }
    };
    private ExpressionValueCellEditor editor;

    public void setHandle(DesignElementHandle handle) {
        this.handle = handle;
        if (this.editor != null) {
            this.editor.setExpressionProvider((IExpressionProvider)new ExpressionProvider(handle));
        }
    }

    public void setInput(SortElementHandle input, LevelViewHandle levelViewHandle) {
        this.sortElementHandle = input;
        this.levelViewHandle = levelViewHandle;
    }

    protected boolean initDialog() {
        if (this.sortElementHandle == null) {
            this.textKey.setText("");
            if (this.comboGroupLevel.getItemCount() == 0) {
                this.comboGroupLevel.add(DEUtil.resolveNull(null));
            }
            if (this.textKey.getItemCount() == 0) {
                this.textKey.add(DEUtil.resolveNull(null));
            }
            this.comboGroupLevel.select(0);
            this.comboDirection.select(0);
            this.updateBindings();
            this.updateMemberValues();
            return true;
        }
        this.getLevels();
        int levelIndex = this.groupLevelList.indexOf(this.levelViewHandle);
        if (levelIndex >= 0) {
            this.comboGroupLevel.select(levelIndex);
            this.updateBindings();
        }
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.textKey, (Object)this.sortElementHandle, (String)"key");
        if (this.sortElementHandle.getDirection() != null && this.sortElementHandle.getDirection().trim().length() != 0) {
            int index;
            String value = this.sortElementHandle.getDirection().trim();
            IChoice choice = this.choiceSet.findChoice(value);
            if (choice != null) {
                value = choice.getDisplayName();
            }
            index = (index = this.comboDirection.indexOf(value)) < 0 ? 0 : index;
            this.comboDirection.select(index);
        }
        if (this.sortElementHandle.getLocale() != null) {
            String locale = null;
            for (Map.Entry entry : FormatAdapter.LOCALE_TABLE.entrySet()) {
                if (!this.sortElementHandle.getLocale().equals(entry.getValue())) continue;
                locale = (String)entry.getKey();
            }
            if (locale != null) {
                int index = this.comboLocale.indexOf(locale);
                this.comboLocale.select(index < 0 ? 0 : index);
            }
        }
        String strength = null;
        for (Map.Entry entry : STRENGTH_MAP.entrySet()) {
            if (this.sortElementHandle.getStrength() != ((Integer)entry.getValue()).intValue()) continue;
            strength = (String)entry.getKey();
        }
        if (strength != null) {
            int index = this.comboStrength.indexOf(strength);
            this.comboStrength.select(index < 0 ? 0 : index);
        }
        this.updateButtons();
        return true;
    }

    protected void okPressed() {
        LevelViewHandle level = (LevelViewHandle)this.groupLevelList.get(this.comboGroupLevel.getSelectionIndex());
        String direction = this.comboDirection.getText();
        IChoice choice = this.choiceSet.findChoiceByDisplayName(direction);
        if (choice != null) {
            direction = choice.getDisplayName();
        }
        int index = this.comboDirection.indexOf(direction);
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(this.title);
        try {
            if (this.sortElementHandle == null) {
                this.sortElementHandle = DesignElementFactory.getInstance().newSortElement();
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.textKey, (Object)this.sortElementHandle, (String)"key");
                if (index >= 0) {
                    this.sortElementHandle.setDirection(choice.getName());
                }
                if (this.referencedLevelList != null && this.referencedLevelList.size() > 0) {
                    this.sortElementHandle.add("member", (DesignElementHandle)this.memberValueHandle);
                }
                DesignElementHandle designElement = level.getModelHandle();
                designElement.add("sort", (DesignElementHandle)this.sortElementHandle);
            } else if (level == this.levelViewHandle) {
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.textKey, (Object)this.sortElementHandle, (String)"key");
                if (index >= 0) {
                    this.sortElementHandle.setDirection(choice.getName());
                }
                if (this.sortElementHandle.getMember() != null) {
                    this.sortElementHandle.drop("member", 0);
                }
                if (this.referencedLevelList != null && this.referencedLevelList.size() > 0) {
                    this.sortElementHandle.add("member", (DesignElementHandle)this.memberValueHandle);
                }
            } else {
                SortElementHandle sortElement = DesignElementFactory.getInstance().newSortElement();
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.textKey, (Object)sortElement, (String)"key");
                if (index >= 0) {
                    sortElement.setDirection(choice.getName());
                }
                if (this.referencedLevelList != null && this.referencedLevelList.size() > 0) {
                    sortElement.add("member", (DesignElementHandle)this.memberValueHandle);
                }
                this.levelViewHandle.getModelHandle().drop("sort", (DesignElementHandle)this.sortElementHandle);
                level.getModelHandle().add("sort", (DesignElementHandle)sortElement);
            }
            String locale = this.comboLocale.getText();
            if (FormatAdapter.LOCALE_TABLE.containsKey(locale)) {
                this.sortElementHandle.setLocale((ULocale)FormatAdapter.LOCALE_TABLE.get(locale));
            } else {
                this.sortElementHandle.setLocale(null);
            }
            String strength = this.comboStrength.getText();
            if (STRENGTH_MAP.containsKey(strength)) {
                this.sortElementHandle.setStrength(((Integer)STRENGTH_MAP.get(strength)).intValue());
            } else {
                this.sortElementHandle.setStrength(-1);
            }
            stack.commit();
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e, (String)Messages.getString("SortkeyBuilder.DialogTitle.Error.SetSortKey.Title"), (String)e.getLocalizedMessage());
            stack.rollback();
        }
        this.setReturnCode(0);
        this.close();
    }

    public CrosstabSortKeyBuilder(String title, String message) {
        this(UIUtil.getDefaultShell(), title, message);
    }

    public CrosstabSortKeyBuilder(Shell parentShell, String title, String message) {
        super(parentShell, title, message);
    }

    protected Composite createInputContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CrossTabSorterBuilder_ID");
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(768));
        GridLayout glayout = new GridLayout(3, false);
        content.setLayout((Layout)glayout);
        Label groupLevel = new Label(content, 0);
        groupLevel.setText(Messages.getString("CrosstabSortkeyBuilder.DialogTitle.Label.GroupLevel"));
        this.comboGroupLevel = new Combo(content, 2056);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.comboGroupLevel.setLayoutData((Object)gdata);
        this.comboGroupLevel.setVisibleItemCount(30);
        this.comboGroupLevel.addListener(13, this.comboGroupLeveModify);
        this.getLevels();
        String[] groupLeveNames = this.groupLevelNameList.toArray(new String[this.groupLevelNameList.size()]);
        this.comboGroupLevel.setItems(groupLeveNames);
        Label labelKey = new Label(content, 0);
        labelKey.setText(Messages.getString("SortkeyBuilder.DialogTitle.Label.Key"));
        this.textKey = new Combo(content, 2048);
        gdata = new GridData(768);
        this.textKey.setLayoutData((Object)gdata);
        this.textKey.setVisibleItemCount(30);
        this.textKey.addListener(13, this.comboKeySelection);
        this.textKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabSortKeyBuilder.this.updateMemberValues();
                CrosstabSortKeyBuilder.this.updateButtons();
            }
        });
        if (this.textKey.getItemCount() == 0) {
            this.textKey.add(DEUtil.resolveNull(null));
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                CrosstabSortKeyBuilder.this.updateButtons();
            }
        };
        ExpressionButtonUtil.createExpressionButton((Composite)content, (Control)this.textKey, (IExpressionProvider)this.getExpressionProvider(), (Object)this.handle, (Listener)listener);
        Label labelDirection = new Label(content, 0);
        labelDirection.setText(Messages.getString("SortkeyBuilder.DialogTitle.Label.Direction"));
        this.comboDirection = new Combo(content, 2056);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.comboDirection.setLayoutData((Object)gdata);
        this.comboDirection.setVisibleItemCount(30);
        String[] displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)this.choiceSet);
        this.comboDirection.setItems(displayNames);
        Label labelLocale = new Label(content, 0);
        labelLocale.setText(Messages.getString("SortkeyBuilder.Label.Locale"));
        this.comboLocale = new Combo(content, 2056);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.comboLocale.setLayoutData((Object)gdata);
        this.comboLocale.setVisibleItemCount(30);
        ArrayList<String> localeNames = new ArrayList<String>();
        localeNames.add(Messages.getString("SortkeyBuilder.Locale.Auto"));
        localeNames.addAll(FormatAdapter.LOCALE_TABLE.keySet());
        this.comboLocale.setItems(localeNames.toArray(new String[0]));
        this.comboLocale.select(0);
        Label labelStrength = new Label(content, 0);
        labelStrength.setText(Messages.getString("SortkeyBuilder.Label.Strength"));
        this.comboStrength = new Combo(content, 2056);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.comboStrength.setLayoutData((Object)gdata);
        this.comboStrength.setVisibleItemCount(30);
        ArrayList strengthNames = new ArrayList(STRENGTH_MAP.keySet());
        Collections.sort(strengthNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return (Integer)STRENGTH_MAP.get(o1) - (Integer)STRENGTH_MAP.get(o2);
            }
        });
        this.comboStrength.setItems(strengthNames.toArray(new String[0]));
        this.comboStrength.select(0);
        this.createMemberValuesGroup(content);
        return content;
    }

    private ExpressionProvider getExpressionProvider() {
        ExpressionProvider expressionProvider = new ExpressionProvider(this.handle);
        expressionProvider.addFilter(new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                if ("Category".equals(parentElement) && ExpressionProvider.COLUMN_BINDINGS.equals(element)) {
                    return false;
                }
                if (ExpressionProvider.CURRENT_CUBE.equals(parentElement) && element instanceof PropertyHandle) {
                    PropertyHandle property = (PropertyHandle)element;
                    return "dimensions".equals(property.getPropertyDefn().getName());
                }
                return true;
            }
        });
        return expressionProvider;
    }

    protected void createMemberValuesGroup(Composite content) {
        this.group = new Group(content, 0);
        this.group.setText(Messages.getString("CrosstabSortKeyBuilder.Label.SelColumnMemberValue"));
        this.group.setLayout((Layout)new GridLayout());
        this.memberValueTable = new Table((Composite)this.group, 68356);
        this.memberValueTable.setLinesVisible(true);
        this.memberValueTable.setHeaderVisible(true);
        this.memberValueTable.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.horizontalSpan = 3;
        this.group.setLayoutData((Object)gd);
        this.dynamicViewer = new TableViewer(this.memberValueTable);
        TableColumn column = new TableColumn(this.memberValueTable, 16384);
        column.setText(this.columns[0]);
        column.setWidth(15);
        TableColumn column1 = new TableColumn(this.memberValueTable, 16384);
        column1.setResizable(this.columns[1] != null);
        if (this.columns[1] != null) {
            column1.setText(this.columns[1]);
        }
        column1.setWidth(200);
        TableColumn column2 = new TableColumn(this.memberValueTable, 16384);
        column2.setResizable(this.columns[2] != null);
        if (this.columns[2] != null) {
            column2.setText(this.columns[2]);
        }
        column2.setWidth(200);
        this.dynamicViewer.setColumnProperties(this.columns);
        this.editor = new ExpressionValueCellEditor((Composite)this.dynamicViewer.getTable(), 8);
        TextCellEditor textEditor = new TextCellEditor((Composite)this.dynamicViewer.getTable(), 8);
        TextCellEditor textEditor2 = new TextCellEditor((Composite)this.dynamicViewer.getTable(), 8);
        CellEditor[] cellEditors = new CellEditor[]{textEditor, textEditor2, this.editor};
        if (this.handle != null) {
            this.editor.setExpressionProvider((IExpressionProvider)new ExpressionProvider(this.handle));
            this.editor.setReportElement((ExtendedItemHandle)this.handle);
        }
        this.dynamicViewer.setCellEditors(cellEditors);
        this.dynamicViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.dynamicViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.dynamicViewer.setCellModifier(this.cellModifier);
        this.dynamicViewer.addSelectionChangedListener(this.selectionChangeListener);
    }

    protected boolean isConditionOK() {
        return this.textKey.getText().trim().length() != 0 && this.comboGroupLevel.getText().trim().length() != 0;
    }

    private List getLevels() {
        DesignElementHandle elementHandle;
        if (this.groupLevelList != null) {
            return this.groupLevelList;
        }
        this.groupLevelList = new ArrayList();
        this.groupLevelNameList = new ArrayList();
        ExtendedItemHandle element = (ExtendedItemHandle)this.handle;
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTab == null) {
            return this.groupLevelList;
        }
        if (crossTab.getCrosstabView(1) != null) {
            elementHandle = crossTab.getCrosstabView(1).getModelHandle();
            this.getLevel((ExtendedItemHandle)elementHandle);
        }
        if (crossTab.getCrosstabView(0) != null) {
            elementHandle = crossTab.getCrosstabView(0).getModelHandle();
            this.getLevel((ExtendedItemHandle)elementHandle);
        }
        return this.groupLevelList;
    }

    private void getLevel(ExtendedItemHandle handle) {
        CrosstabViewHandle crossTabViewHandle = null;
        try {
            crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        if (crossTabViewHandle == null) {
            return;
        }
        int dimensionCount = crossTabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crossTabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                this.groupLevelList.add(levelHandle);
                if (levelHandle.getCubeLevel() != null) {
                    this.groupLevelNameList.add(levelHandle.getCubeLevel().getFullName());
                }
                ++j;
            }
            ++i;
        }
    }

    private void updateBindings() {
        LevelViewHandle level = null;
        if (this.comboGroupLevel.getSelectionIndex() != -1 && this.groupLevelList != null && this.groupLevelList.size() > 0) {
            level = (LevelViewHandle)this.groupLevelList.get(this.comboGroupLevel.getSelectionIndex());
        }
        if (level == null) {
            this.textKey.setItems(new String[]{DEUtil.resolveNull(null)});
            return;
        }
        this.textKey.removeAll();
        List bindingList = this.getReferableBindings(level);
        int i = 0;
        while (i < bindingList.size()) {
            this.textKey.add(((IBindingMetaInfo)bindingList.get(i)).getBindingName());
            ++i;
        }
        if (this.textKey.getItemCount() == 0) {
            this.textKey.add(DEUtil.resolveNull(null));
        }
        if (this.textKey.indexOf(this.textKey.getText()) < 0 && ExpressionButtonUtil.getCurrentExpressionConverter((Control)this.textKey) != null) {
            this.textKey.setText(ExpressionButtonUtil.getCurrentExpressionConverter((Control)this.textKey).getCubeBindingExpression(this.textKey.getItem(0)));
        }
    }

    private void updateMemberValues() {
        if (this.comboGroupLevel.getSelectionIndex() < 0 || this.textKey.getText().length() == 0) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        boolean enabled = false;
        String name = null;
        IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)this.textKey, (boolean)false);
        if (converter != null) {
            int i = 0;
            while (i < this.textKey.getItemCount()) {
                String tempValue;
                String value = this.textKey.getText();
                if (value.equals(tempValue = converter.getCubeBindingExpression(this.textKey.getItem(i)))) {
                    name = this.textKey.getItem(i);
                    enabled = true;
                }
                ++i;
            }
        }
        if (!enabled) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        LevelViewHandle level = null;
        if (this.comboGroupLevel.getSelectionIndex() != -1 && this.groupLevelList != null && this.groupLevelList.size() > 0) {
            level = (LevelViewHandle)this.groupLevelList.get(this.comboGroupLevel.getSelectionIndex());
        }
        if (level == null) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        if (level.getAxisType() == 1) {
            this.group.setText(Messages.getString("CrosstabSortKeyBuilder.Label.SelColumnMemberValue"));
        } else {
            this.group.setText(Messages.getString("CrosstabSortKeyBuilder.Label.SelRowMemberValue"));
        }
        String bindingExpr = ExpressionUtil.createJSDataExpression(name);
        this.referencedLevelList = CrosstabUtil.getReferencedLevels((LevelViewHandle)level, (String)bindingExpr);
        if (this.referencedLevelList == null || this.referencedLevelList.size() == 0) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        this.editor.setReferencedLevelList(this.referencedLevelList);
        this.memberValueTable.setEnabled(true);
        this.memberValueHandle = null;
        if (level == this.levelViewHandle) {
            this.memberValueHandle = this.sortElementHandle.getMember();
        }
        if (this.memberValueHandle == null) {
            this.memberValueHandle = DesignElementFactory.getInstance().newMemberValue();
        }
        this.memberValueHandle = this.updateMemberValuesFromLevelList(this.referencedLevelList, this.memberValueHandle);
        List memList = this.getMemberValueList(this.memberValueHandle);
        this.dynamicViewer.setInput((Object)memList);
    }

    private List getReferableBindings(LevelViewHandle level) {
        List retList = new ArrayList();
        if (level.getCubeLevel() == null) {
            return retList;
        }
        DimensionHandle dimensionHandle = CrosstabAdaptUtil.getDimensionHandle(level.getCubeLevel());
        String targetLevel = ExpressionUtil.createJSDimensionExpression((String)dimensionHandle.getName(), (String)level.getCubeLevel().getName());
        ICubeQueryDefinition cubeQueryDefn = null;
        DataRequestSession session = null;
        try {
            try {
                session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
                cubeQueryDefn = CrosstabUIHelper.createBindingQuery(level.getCrosstab());
                retList = session.getCubeQueryUtil().getReferableBindings(targetLevel, cubeQueryDefn, true);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                if (session != null) {
                    session.shutdown();
                }
            }
        }
        finally {
            if (session != null) {
                session.shutdown();
            }
        }
        return retList;
    }

    private int getBindingIndex(String dataExpression) {
        int ret = -1;
        int i = 0;
        while (i < this.textKey.getItemCount()) {
            String expression = this.textKey.getItem(i);
            if (expression.equals(dataExpression)) {
                return i;
            }
            ++i;
        }
        return ret;
    }

    private MemberValueHandle getChildMemberValue(MemberValueHandle memberValue) {
        if (memberValue.getContentCount("memberValues") != 1 || memberValue.getContent("memberValues", 0) == null) {
            return null;
        }
        return (MemberValueHandle)memberValue.getContent("memberValues", 0);
    }

    private void dropChildMemberValue(MemberValueHandle memberValue) {
        MemberValueHandle child = this.getChildMemberValue(memberValue);
        if (child == null) {
            return;
        }
        try {
            memberValue.drop("memberValues", 0);
        }
        catch (SemanticException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private MemberValueHandle updateMemberValuesFromLevelList(List referenceLevels, MemberValueHandle memberValue) {
        int count = referenceLevels.size();
        MemberValueHandle lastMemberValue = memberValue;
        int hasCount = 0;
        while (true) {
            LevelHandle tempLevel = this.getLevelHandle((IDimensionLevel)referenceLevels.get(++hasCount - 1));
            if (lastMemberValue.getLevel() != tempLevel) {
                try {
                    lastMemberValue.setLevel(tempLevel);
                    this.dropChildMemberValue(lastMemberValue);
                }
                catch (SemanticException e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
                break;
            }
            if (this.getChildMemberValue(lastMemberValue) == null) break;
            if (hasCount >= count) {
                this.dropChildMemberValue(lastMemberValue);
                break;
            }
            lastMemberValue = this.getChildMemberValue(lastMemberValue);
        }
        int i = hasCount;
        while (i < count) {
            MemberValueHandle newValue = DesignElementFactory.getInstance().newMemberValue();
            LevelHandle tempLevel = this.getLevelHandle((IDimensionLevel)referenceLevels.get(i));
            try {
                newValue.setLevel(tempLevel);
                lastMemberValue.add("memberValues", (DesignElementHandle)newValue);
            }
            catch (SemanticException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            lastMemberValue = newValue;
            ++i;
        }
        return memberValue;
    }

    private LevelHandle getLevelHandle(IDimensionLevel levelInfo) {
        LevelHandle levelHandle = null;
        String levelName = levelInfo.getLevelName();
        String dimensionName = levelInfo.getDimensionName();
        ExtendedItemHandle extHandle = (ExtendedItemHandle)this.handle;
        CrosstabReportItemHandle crosstab = null;
        try {
            crosstab = (CrosstabReportItemHandle)extHandle.getReportItem();
        }
        catch (ExtendedElementException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        DimensionViewHandle dimension = crosstab.getDimension(dimensionName);
        LevelViewHandle level = dimension.findLevel(levelName);
        levelHandle = level.getCubeLevel();
        return levelHandle;
    }

    private List getMemberValueList(MemberValueHandle parent) {
        ArrayList<MemberValueHandle> list = new ArrayList<MemberValueHandle>();
        if (parent == null) {
            return list;
        }
        MemberValueHandle memberValue = parent;
        while (true) {
            list.add(memberValue);
            if (memberValue.getContentCount("memberValues") != 1 || memberValue.getContent("memberValues", 0) == null) break;
            memberValue = (MemberValueHandle)memberValue.getContent("memberValues", 0);
        }
        return list;
    }
}

