/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import java.util.Map;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.gef.commands.Command;

public class CrosstabCellCreateCommand
extends Command {
    private Object parent;
    private Object after;
    private Map extendsData;

    public CrosstabCellCreateCommand(Map extendsData) {
        this.extendsData = extendsData;
    }

    public void execute() {
        try {
            if (this.parent instanceof CrosstabCellAdapter) {
                CrosstabCellAdapter cellAdapter = (CrosstabCellAdapter)this.parent;
                CrosstabCellHandle handle = cellAdapter.getCrosstabCellHandle();
                int pos = this.findInsertPosition(handle, this.after);
                Object obj = this.getNewObject();
                if (obj instanceof DesignElementHandle && ((DesignElementHandle)obj).getContainer() == null) {
                    handle.addContent((DesignElementHandle)obj, pos);
                } else if (obj instanceof Object[]) {
                    Object[] objs = (Object[])obj;
                    int i = 0;
                    while (i < objs.length) {
                        if (objs[i] instanceof DesignElementHandle) {
                            handle.addContent((DesignElementHandle)objs[i], pos);
                            ++pos;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("CreateCommand >> Failed");
            }
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private int findInsertPosition(CrosstabCellHandle handle, Object after) {
        if (after == null) {
            return handle.getContents().size();
        }
        return handle.getContents().indexOf(after);
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setAfter(Object model) {
        this.after = model;
    }

    public Object getNewObject() {
        return this.extendsData.get("newObject");
    }
}

