/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabHandleAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class CreateDimensionViewCommand
extends AbstractCrosstabCommand {
    private CrosstabHandleAdapter handleAdpter;
    private int type = -1;
    private DimensionHandle[] dimensionHandles;
    private LevelHandle[] levelHandles;
    private static final String NAME = Messages.getString("CreateDimensionViewCommand.TransName");

    public CreateDimensionViewCommand(CrosstabHandleAdapter handleAdpter, int type, DimensionHandle dimensionHandle) {
        this(handleAdpter, type, new DimensionHandle[]{dimensionHandle});
    }

    public CreateDimensionViewCommand(CrosstabHandleAdapter handleAdpter, int type, DimensionHandle[] dimensionHandles) {
        super((DesignElementHandle)dimensionHandles[0]);
        this.setHandleAdpter(handleAdpter);
        this.setType(type);
        this.setDimensionHandles(dimensionHandles);
        this.setLabel(NAME);
    }

    public void setHandleAdpter(CrosstabHandleAdapter handleAdpter) {
        this.handleAdpter = handleAdpter;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean canExecute() {
        return this.getType() != -1;
    }

    public void execute() {
        this.transStart(NAME);
        CrosstabReportItemHandle crosstabHandle = (CrosstabReportItemHandle)this.handleAdpter.getCrosstabItemHandle();
        int i = 0;
        while (i < this.dimensionHandles.length) {
            DimensionHandle dimensionHandle = this.dimensionHandles[i];
            try {
                if (crosstabHandle.getCube() == null) {
                    crosstabHandle.setCube(CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)dimensionHandle));
                }
                DimensionViewHandle viewHandle = crosstabHandle.insertDimension(dimensionHandle, this.getType(), i);
                LevelHandle[] levels = this.getLevelHandles(dimensionHandle);
                int j = 0;
                while (j < levels.length) {
                    LevelHandle levelHandle = levels[j];
                    if (levelHandle == null) {
                        this.rollBack();
                        return;
                    }
                    DataItemHandle dataHandle = CrosstabAdaptUtil.createColumnBindingAndDataItem((ReportItemHandle)((ExtendedItemHandle)crosstabHandle.getModelHandle()), levelHandle);
                    LevelViewHandle levelViewHandle = viewHandle.insertLevel(levelHandle, j);
                    CrosstabCellHandle cellHandle = levelViewHandle.getCell();
                    cellHandle.addContent((DesignElementHandle)dataHandle);
                    ++j;
                }
            }
            catch (Exception e) {
                this.rollBack();
                ExceptionUtil.handle((Throwable)e);
            }
            ++i;
        }
        this.transEnd();
    }

    public DimensionHandle[] getDimensionHandles() {
        return this.dimensionHandles;
    }

    public void setDimensionHandles(DimensionHandle[] dimensionHandles) {
        this.dimensionHandles = dimensionHandles;
    }

    public LevelHandle[] getLevelHandles(DimensionHandle dimensionHandle) {
        if (this.levelHandles == null) {
            LevelHandle[] dimensionLevelHandles = new LevelHandle[dimensionHandle.getDefaultHierarchy().getLevelCount()];
            int i = 0;
            while (i < dimensionLevelHandles.length) {
                dimensionLevelHandles[i] = dimensionHandle.getDefaultHierarchy().getLevel(i);
                ++i;
            }
            return dimensionLevelHandles;
        }
        return this.levelHandles;
    }

    public void setLevelHandles(LevelHandle[] levelHandles) {
        this.levelHandles = levelHandles;
    }
}

