/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class LogConfig {
    private static String className = OdaJdbcDriver.class.getName();
    private static Logger logger = Logger.getLogger(className);

    static void setLogConfiguration(LogConfiguration logConfig) throws OdaException {
        String formatterClassName;
        String className = OdaJdbcDriver.class.getName();
        Logger pkgLogger = Logger.getLogger(className.substring(0, className.lastIndexOf(".")));
        switch (logConfig.getLogLevel()) {
            case -2147483648: {
                pkgLogger.setLevel(Level.ALL);
                break;
            }
            case 300: {
                pkgLogger.setLevel(Level.FINEST);
                break;
            }
            case 400: {
                pkgLogger.setLevel(Level.FINER);
                break;
            }
            case 500: {
                pkgLogger.setLevel(Level.FINE);
                break;
            }
            case 700: {
                pkgLogger.setLevel(Level.CONFIG);
                break;
            }
            case 800: {
                pkgLogger.setLevel(Level.INFO);
                break;
            }
            case 900: {
                pkgLogger.setLevel(Level.WARNING);
                break;
            }
            case 1000: {
                pkgLogger.setLevel(Level.SEVERE);
                break;
            }
            case 0x7FFFFFFF: {
                pkgLogger.setLevel(Level.OFF);
                break;
            }
            default: {
                if (logConfig.getLogLevel() > 1000) {
                    pkgLogger.setLevel(Level.OFF);
                    break;
                }
                logger.logp(Level.WARNING, className, "setLogConfiguration", String.valueOf(logConfig.getLogLevel()) + " is not a valid log level.");
            }
        }
        if (pkgLogger.getLevel() == Level.OFF) {
            return;
        }
        Handler handler = LogConfig.setLogHandler(pkgLogger, logConfig);
        if (handler == null) {
            logger.logp(Level.WARNING, className, "setLogConfiguration", "Cannot create log handler for package.");
            return;
        }
        if (pkgLogger.getLevel() != null) {
            handler.setLevel(pkgLogger.getLevel());
        }
        if ((formatterClassName = logConfig.getFormatterClassName()) == null || formatterClassName.length() == 0) {
            return;
        }
        if (handler.getFormatter() != null && formatterClassName.equals(handler.getFormatter().getClass().getName())) {
            return;
        }
        try {
            Class<?> formatterClass = Class.forName(formatterClassName);
            handler.setFormatter((Formatter)formatterClass.newInstance());
        }
        catch (Exception ex) {
            logger.logp(Level.WARNING, className, "setLogConfiguration", "Cannot setup Formatter object.", ex);
        }
    }

    private static Handler setLogHandler(Logger pkgLogger, LogConfiguration logConfig) {
        Handler handler = null;
        Handler[] handlers = pkgLogger.getHandlers();
        int numHandlers = handlers.length;
        String logDirectory = logConfig.getLogDirectory();
        String logPrefix = logConfig.getLogPrefix();
        if (logDirectory == null || logDirectory.length() == 0 || logPrefix == null || logPrefix.length() == 0) {
            int i = 0;
            while (i < numHandlers) {
                handler = handlers[i];
                if (handler instanceof ConsoleHandler) {
                    return handler;
                }
                ++i;
            }
            handler = new ConsoleHandler();
            pkgLogger.addHandler(handler);
            return handler;
        }
        int i = 0;
        while (i < numHandlers) {
            handler = handlers[i];
            if (handler instanceof FileHandler) {
                return handler;
            }
            ++i;
        }
        try {
            handler = new FileHandler(LogConfig.generateFileName(logDirectory, logPrefix), true);
            pkgLogger.addHandler(handler);
        }
        catch (Exception ex) {
            logger.logp(Level.WARNING, className, "setLogHandler", "Cannot create FileHandler.", ex);
        }
        return handler;
    }

    private static String generateFileName(String logDirectory, String logPrefix) {
        File logDir = new File(logDirectory);
        if (logDir.isDirectory() && !logDir.isAbsolute() || logDirectory.startsWith(".")) {
            try {
                URL url = OdaJdbcDriver.getInstallDirectory();
                if (url != null) {
                    String driverHomeDir = url.getPath();
                    logDir = new File(driverHomeDir, LogConfig.getQualifiedLogDir(logDirectory));
                    if (!logDir.exists()) {
                        logDir.mkdir();
                    }
                    logDirectory = logDir.getPath();
                }
            }
            catch (OdaException odaException) {
            }
            catch (IOException iOException) {}
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String logfileName = logDirectory.endsWith("/") || logDirectory.endsWith("\\") ? logDirectory : String.valueOf(logDirectory) + File.separator;
        logfileName = String.valueOf(logfileName) + logPrefix + "-";
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        logfileName = String.valueOf(logfileName) + dateFormat.format((Date)timestamp) + ".log";
        return logfileName;
    }

    private static String getQualifiedLogDir(String logDir) {
        if (logDir.startsWith(".")) {
            logDir = logDir.substring(1);
        }
        return logDir;
    }
}

