/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;
import org.eclipse.birt.report.engine.layout.emitter.Image;

public class ImageData
extends SheetData {
    private String altText;
    private String imageUrl;
    private byte[] imageData;
    private Image imageInfo;
    private int width;

    public ImageData(IImageContent image, int styleId, int datatype, Image imageInfo, XlsContainer currentContainer, int heightDpi, int widthDpi) {
        this.dataType = datatype;
        this.styleId = styleId;
        this.height = ExcelUtil.convertDimensionType(image.getHeight(), (float)imageInfo.getHeight() * 72.0f / (float)heightDpi, heightDpi) / 1000;
        int imageWidth = ExcelUtil.convertDimensionType(image.getWidth(), (float)imageInfo.getWidth() * 72.0f / (float)widthDpi, widthDpi);
        this.width = Math.min(currentContainer.getSizeInfo().getWidth(), imageWidth);
        this.altText = image.getAltText();
        this.imageUrl = image.getURI();
        this.imageData = imageInfo.getData();
        this.rowSpanInDesign = 0;
        this.imageInfo = imageInfo;
    }

    public String getDescription() {
        return this.altText;
    }

    public void setDescription(String description) {
        this.altText = description;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setUrl(String url) {
        this.imageUrl = url;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public Image getImageInfo() {
        return this.imageInfo;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getEndX() {
        return this.getStartX() + this.width;
    }
}

