/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.impl.DataRequestSessionImpl;
import org.mozilla.javascript.Scriptable;

public class DataSetIteratorForTempPK
implements IDatasetIterator {
    private static String COUNT_BINDING_NAME = "COUNT";
    private int rowCount;
    private int currRowNum = -1;

    DataSetIteratorForTempPK(DataRequestSessionImpl session, IQueryDefinition query, Map appContext) throws BirtException {
        Binding b = new Binding(COUNT_BINDING_NAME);
        b.setAggrFunction("COUNT");
        query.addBinding((IBinding)b);
        this.executeQuery(session, query, appContext);
    }

    private void executeQuery(DataRequestSessionImpl session, IQueryDefinition query, Map appContext) throws AdapterException {
        try {
            Scriptable scope = session.getScope();
            IResultIterator it = session.prepare(query, appContext).execute(scope).getResultIterator();
            this.rowCount = it.getInteger(COUNT_BINDING_NAME);
            it.close();
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    public void close() throws BirtException {
    }

    public int getFieldIndex(String name) throws BirtException {
        return 1;
    }

    public int getFieldType(String name) throws BirtException {
        return 2;
    }

    public Object getValue(int fieldIndex) throws BirtException {
        return this.currRowNum;
    }

    public boolean next() throws BirtException {
        if (this.rowCount > 0 && this.currRowNum < this.rowCount) {
            ++this.currRowNum;
            return true;
        }
        return false;
    }
}

