/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDMaxFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDMaxInclusiveFacetImpl
extends XSDMaxFacetImpl
implements XSDMaxInclusiveFacet {
    public static XSDMaxInclusiveFacet createMaxInclusiveFacet(Node node) {
        if (XSDConstants.nodeType(node) == 24) {
            XSDMaxInclusiveFacet xsdMaxInclusiveFacet = XSDFactory.eINSTANCE.createXSDMaxInclusiveFacet();
            xsdMaxInclusiveFacet.setElement((Element)node);
            return xsdMaxInclusiveFacet;
        }
        return null;
    }

    protected XSDMaxInclusiveFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_MAX_INCLUSIVE_FACET;
    }

    public Element createElement() {
        Element newElement = this.createElement(24);
        this.setElement(newElement);
        return newElement;
    }

    protected boolean analyze() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
        super.analyze();
        String theLexicalValue = this.getLexicalValue();
        Object newValue = null;
        if (theLexicalValue != null && (xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer()) != null) {
            try {
                newValue = xsdSimpleTypeDefinition.getValue(this.getElement(), theLexicalValue);
            }
            catch (RuntimeException runtimeException) {}
        }
        if (newValue == null ? this.getValue() != null : !newValue.equals(this.getValue())) {
            this.setValue(newValue);
        }
        return true;
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.Literals.XSD_FACET__LEXICAL_VALUE) {
            this.traverseToRootForAnalysis();
        }
    }

    public boolean isConstraintSatisfied(Object value) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer();
        if (xsdSimpleTypeDefinition != null) {
            return xsdSimpleTypeDefinition.compareValues(value, this.getValue()) <= 0;
        }
        return false;
    }

    public Object getEffectiveValue() {
        return this.getValue();
    }

    public boolean isInclusive() {
        return true;
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDMaxInclusiveFacetImpl clonedMaxInclusiveFacet = (XSDMaxInclusiveFacetImpl)this.getXSDFactory().createXSDMaxInclusiveFacet();
        clonedMaxInclusiveFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedMaxInclusiveFacet.setLexicalValue(this.getLexicalValue());
        }
        if (this.isSetFixed()) {
            clonedMaxInclusiveFacet.setFixed(this.isFixed());
        }
        if (deep && this.getAnnotation() != null) {
            clonedMaxInclusiveFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedMaxInclusiveFacet.setElement(this.getElement());
        }
        clonedMaxInclusiveFacet.isReconciling = shareDOM;
        return clonedMaxInclusiveFacet;
    }
}

