/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;

public class SvgFile {
    private static Logger logger = Logger.getLogger(SvgFile.class.getName());
    static boolean isSvg = false;

    public static boolean isSvg(String uri) {
        isSvg = uri != null && uri.endsWith(".svg");
        return isSvg;
    }

    public static boolean isSvg(String mimeType, String uri, String extension) {
        isSvg = mimeType != null && mimeType.equalsIgnoreCase("image/svg+xml") || uri != null && uri.toLowerCase().endsWith(".svg") || extension != null && extension.toLowerCase().endsWith(".svg");
        return isSvg;
    }

    public static byte[] transSvgToArray(String uri) throws IOException {
        InputStream in = new URL(uri).openStream();
        try {
            byte[] byArray = SvgFile.transSvgToArray(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static byte[] transSvgToArray(InputStream inputStream) throws IOException {
        JPEGTranscoder transcoder = new JPEGTranscoder();
        transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        TranscoderInput input = new TranscoderInput(inputStream);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        try {
            transcoder.transcode(input, output);
        }
        catch (TranscoderException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        ostream.flush();
        return ostream.toByteArray();
    }
}

