/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.instance;

import org.eclipse.birt.report.engine.api.script.instance.IAbstractTextInstance;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.instance.ReportItemInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;

public abstract class ForeignTextInstance
extends ReportItemInstance
implements IAbstractTextInstance {
    public ForeignTextInstance(IForeignContent content, ExecutionContext context, RunningState runningState) {
        super(content, context, runningState);
    }

    protected ForeignTextInstance(ExecutionContext context, RunningState runningState) {
        super(context, runningState);
    }

    public String getText() {
        IForeignContent fc = (IForeignContent)this.content;
        String type = fc.getRawType();
        if ("text/template".equals(type)) {
            Object[] rawValue = (Object[])fc.getRawValue();
            if (rawValue[0] != null) {
                return (String)rawValue[0];
            }
        } else if ("text/html".equals(type) || "text/plaintext".equals(type)) {
            return fc.getRawValue() == null ? null : fc.getRawValue().toString();
        }
        return null;
    }

    public void setText(String value) {
        IForeignContent foreignContent = (IForeignContent)this.content;
        if (foreignContent.getRawType().equals("text/template")) {
            Object[] rawValue = (Object[])foreignContent.getRawValue();
            rawValue[0] = value;
        } else {
            foreignContent.setRawValue(value);
        }
    }
}

