/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.nLayout.area.impl.ITextListener;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;

public class InlineTextRenderListener
implements ITextListener {
    private int textStartPos = -1;
    private int textLength = 0;
    private int readTextLength = 0;
    private boolean listeningStatus = false;
    private int offset = 0;
    private int dimension = 0;
    private InlineTextArea inlineContainer = null;
    int lastTotalWidth = 0;

    public InlineTextRenderListener(InlineTextArea inlineContainer, int offset, int dimension) {
        this.inlineContainer = inlineContainer;
        this.offset = offset;
        this.dimension = dimension;
        this.onNewLineEvent();
    }

    public int getTextStart() {
        return this.textStartPos;
    }

    public int getTextLength() {
        return this.textLength;
    }

    public void onAddEvent(TextArea textArea) {
        if (this.listeningStatus) {
            if (this.textStartPos == -1) {
                this.textStartPos = textArea.offset;
            }
            this.readTextLength += textArea.textLength;
        }
    }

    public void onNewLineEvent() {
        this.lastTotalWidth += this.inlineContainer.getAllocatedWidth();
        if (this.lastTotalWidth < this.offset || this.lastTotalWidth > this.offset + this.dimension) {
            this.listeningStatus = false;
        } else {
            this.listeningStatus = true;
            this.textLength = this.readTextLength;
        }
    }

    public void onTextEndEvent() {
        if (this.listeningStatus) {
            this.textLength = this.readTextLength;
        }
    }

    public String getSplitText() {
        ITextContent textContent = (ITextContent)this.inlineContainer.content;
        if (this.textStartPos == -1 || this.textLength == 0) {
            return "";
        }
        String splitText = textContent.getText().substring(this.textStartPos, this.textStartPos + this.textLength);
        return splitText;
    }
}

