/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.ibm.icu.util.ULocale;
import com.lowagie.text.Image;
import java.util.Locale;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.ObjectContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageBlockContainer;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageInlineContainer;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineStackingArea;
import org.eclipse.birt.report.engine.util.FlashFile;
import org.eclipse.birt.report.engine.util.SvgFile;

public class ImageAreaLayout
implements ILayout {
    public static final int TYPE_IMAGE_OBJECT = 0;
    public static final int TYPE_FLASH_OBJECT = 1;
    public static final int TYPE_SVG_OBJECT = 2;
    private static final int RESOURCE_UNREACHABLE = 0;
    private static final int UNSUPPORTED_OBJECTS = 1;
    public int objectType = 0;
    private ILayout layout = null;
    private ContainerArea parent;
    private IImageContent content;
    private LayoutContext context;
    protected static Logger logger = Logger.getLogger(ImageAreaLayout.class.getName());

    public ImageAreaLayout(ContainerArea parent, LayoutContext context, IImageContent content) {
        this.parent = parent;
        this.content = content;
        this.context = context;
    }

    public void layout() throws BirtException {
        this.initialize();
        if (this.layout != null) {
            this.layout.layout();
        }
    }

    protected void initialize() throws BirtException {
        this.checkObjectType();
        IImageContent imageContent = this.content;
        Image imageObject = null;
        if (this.isOutputSupported(this.objectType)) {
            if (this.objectType == 0) {
                imageObject = EmitterUtil.getImage(imageContent);
            }
            this.layout = imageObject != null && this.objectType == 0 || this.objectType == 1 || this.objectType == 2 ? new ConcreteImageLayout(this.context, this.parent, this.content, imageObject) : this.createAltTextLayout(0);
        } else {
            if (this.objectType == 2 && (imageObject = EmitterUtil.getImage(imageContent)) != null) {
                this.layout = new ConcreteImageLayout(this.context, this.parent, this.content, imageObject);
                return;
            }
            this.layout = this.createAltTextLayout(1);
        }
    }

    private ILayout createAltTextLayout(int altTextType) {
        ITextContent altTextContent = this.createAltText(this.content, altTextType);
        if (altTextContent == null) {
            return null;
        }
        return new BlockTextArea(this.parent, this.context, altTextContent);
    }

    private ITextContent createAltText(IImageContent imageContent, int altTextType) {
        IReportContent report = imageContent.getReportContent();
        if (report == null) {
            return null;
        }
        ITextContent altTextContent = report.createTextContent(imageContent);
        altTextContent.setParent(imageContent.getParent());
        String alt = imageContent.getAltText();
        if (alt == null) {
            ULocale locale = ULocale.forLocale((Locale)this.context.getLocale());
            if (locale == null) {
                locale = ULocale.getDefault();
            }
            EngineResourceHandle resourceHandle = new EngineResourceHandle(locale);
            if (altTextType == 1) {
                alt = this.objectType == 1 ? resourceHandle.getMessage("Error.FlashObjectNotSupported") : resourceHandle.getMessage("Error.ReportItemNotSupported");
            }
            if (altTextType == 0) {
                alt = resourceHandle.getMessage("Error.ResourceUnreachable");
            }
        }
        altTextContent.setText(alt);
        return altTextContent;
    }

    protected void checkObjectType() {
        String extension;
        IImageContent image = this.content;
        String uri = image.getURI();
        String mimeType = image.getMIMEType();
        this.objectType = FlashFile.isFlash(mimeType, uri, extension = image.getExtension()) ? 1 : (SvgFile.isSvg(mimeType, uri, extension) ? 2 : 0);
    }

    private boolean isOutputSupported(int type) {
        String supportedImageFormats = this.context.getSupportedImageFormats();
        return type == 0 ? -1 != supportedImageFormats.indexOf("PNG") || -1 != supportedImageFormats.indexOf("GIF") || -1 != supportedImageFormats.indexOf("BMP") || -1 != supportedImageFormats.indexOf("JPG") : (type == 1 ? -1 != supportedImageFormats.indexOf("SWF") : type == 2 && -1 != supportedImageFormats.indexOf("SVG"));
    }

    class ConcreteImageLayout
    implements ILayout {
        private int resolutionX = 0;
        private int resolutionY = 0;
        private Image imageObject = null;
        private ContainerArea parent;
        protected static final int DEFAULT_WIDHT = 212000;
        protected static final int DEFAULT_HEIGHT = 130000;
        protected IImageContent image;
        protected ContainerArea root;
        private Dimension intrinsic;
        private static final String BOOKMARK_PREFIX = "javascript:catchBookmark('";
        private LayoutContext context;
        private boolean fitToContainer = false;
        private BlockTextArea innerText = null;

        public ConcreteImageLayout(LayoutContext context, ContainerArea parent, IImageContent content, Image imageObject) {
            this.context = context;
            this.image = content;
            this.parent = parent;
            this.imageObject = imageObject;
            Object reportItemDesign = content.getGenerateBy();
            if (reportItemDesign != null && reportItemDesign instanceof ImageItemDesign) {
                this.fitToContainer = ((ImageItemDesign)reportItemDesign).isFitToContainer();
            }
        }

        protected Dimension getIntrinsicDimension(IImageContent content, Image image) {
            if (image != null) {
                return new Dimension((int)(image.plainWidth() * 1000.0f / (float)this.resolutionX * 72.0f), (int)(image.plainHeight() * 1000.0f / (float)this.resolutionY * 72.0f));
            }
            return null;
        }

        protected Dimension getSpecifiedDimension(IImageContent content, int pWidth, boolean scale) {
            int imageFileDpiX = 0;
            int imageFileDpiY = 0;
            if (this.imageObject != null) {
                imageFileDpiX = this.imageObject.getDpiX();
                imageFileDpiY = this.imageObject.getDpiY();
            }
            this.resolutionX = PropertyUtil.getImageDpi(content, imageFileDpiX, this.context.getDpi());
            this.resolutionY = PropertyUtil.getImageDpi(content, imageFileDpiY, this.context.getDpi());
            try {
                this.intrinsic = this.getIntrinsicDimension(content, this.imageObject);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage());
            }
            int specifiedWidth = PropertyUtil.getImageDimensionValue(content, content.getWidth(), this.resolutionX, pWidth);
            int specifiedHeight = PropertyUtil.getImageDimensionValue(content, content.getHeight(), this.resolutionY, 0);
            Dimension dim = new Dimension(212000, 130000);
            if (this.intrinsic == null) {
                dim.setDimension(specifiedWidth == -1 ? 212000 : specifiedWidth, specifiedHeight == -1 ? 130000 : specifiedHeight);
                return dim;
            }
            if (scale) {
                double ratio = this.intrinsic.getRatio();
                if (specifiedWidth >= 0) {
                    if (specifiedHeight >= 0) {
                        dim.setDimension(specifiedWidth, specifiedHeight);
                    } else {
                        dim.setDimension(specifiedWidth, (int)((double)specifiedWidth / ratio));
                    }
                } else if (specifiedHeight >= 0) {
                    dim.setDimension((int)((double)specifiedHeight * ratio), specifiedHeight);
                } else {
                    dim.setDimension(this.intrinsic.getWidth(), this.intrinsic.getHeight());
                }
            } else if (specifiedWidth >= 0) {
                if (specifiedHeight >= 0) {
                    dim.setDimension(specifiedWidth, specifiedHeight);
                } else {
                    dim.setDimension(specifiedWidth, this.intrinsic.getHeight());
                }
            } else if (specifiedHeight >= 0) {
                dim.setDimension(this.intrinsic.getWidth(), specifiedHeight);
            } else {
                dim.setDimension(this.intrinsic.getWidth(), this.intrinsic.getHeight());
            }
            return dim;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void layout() throws BirtException {
            int aHeight;
            this.init();
            boolean isEmptyLine = true;
            boolean innerTextInserted = false;
            if ("pdf".equalsIgnoreCase(this.context.getFormat()) && ImageAreaLayout.this.objectType == 1) {
                innerTextInserted = true;
                this.innerText = this.createInnerTextLayout();
                this.innerText.content.getStyle().setProperty(24, IStyle.CENTER_VALUE);
                this.innerText.setVerticalAlign(IStyle.MIDDLE_VALUE);
                this.innerText.setIgnoreReordering(true);
                if (PropertyUtil.isInlineElement(this.image)) {
                    InlineStackingArea lineParent = (InlineStackingArea)this.parent;
                    isEmptyLine = lineParent.isEmptyLine();
                }
                int lastIP = this.root.currentIP;
                int lastBP = this.root.currentBP;
                this.innerText.layout();
                this.innerText.setAllocatedPosition(0, 0);
                this.root.currentIP = lastIP;
                this.root.currentBP = lastBP;
            }
            if (PropertyUtil.isInlineElement(this.image)) {
                assert (this.parent instanceof InlineStackingArea);
                InlineStackingArea lineParent = (InlineStackingArea)this.parent;
                if (this.root.getAllocatedWidth() <= this.parent.getCurrentMaxContentWidth()) {
                    this.parent.add(this.root);
                    this.root.finished = true;
                    this.parent.update(this.root);
                    return;
                }
                if (innerTextInserted && !isEmptyLine || !innerTextInserted && !lineParent.isEmptyLine()) {
                    lineParent.endLine(false);
                    this.layout();
                    return;
                }
                this.parent.add(this.root);
                this.root.finished = true;
                this.parent.update(this.root);
                return;
            }
            this.parent.add(this.root);
            if (!this.parent.isInInlineStacking && this.context.isAutoPageBreak() && (aHeight = this.root.getAllocatedHeight()) + this.parent.getAbsoluteBP() > this.context.getMaxBP()) {
                this.parent.autoPageBreak();
            }
            this.root.finished = true;
            this.parent.update(this.root);
        }

        protected void init() throws BirtException {
            this.root = PropertyUtil.isInlineElement(this.image) ? new ImageInlineContainer(this.parent, this.context, this.image) : new ImageBlockContainer(this.parent, this.context, this.image);
            this.root.initialize();
            this.root.setAllocatedWidth(this.parent.getMaxAvaWidth());
            this.root.setMaxAvaWidth(this.root.getContentWidth());
            Dimension contentDimension = this.getSpecifiedDimension(this.image, this.root.getContentWidth(), true);
            ImageArea imageArea = this.createImageArea(this.image);
            imageArea.setParent(this.root);
            int maxHeight = this.root.getMaxAvaHeight();
            int maxWidth = this.root.getMaxAvaWidth();
            int cHeight = contentDimension.getHeight();
            int cWidth = contentDimension.getWidth();
            int actualHeight = cHeight;
            int actualWidth = cWidth;
            if (cHeight > maxHeight || cWidth > maxWidth) {
                if (this.fitToContainer) {
                    float rh = (float)maxHeight / (float)cHeight;
                    float rw = (float)maxWidth / (float)cWidth;
                    if (rh > rw) {
                        actualHeight = (int)((float)cHeight * (float)maxWidth / (float)cWidth);
                        actualWidth = maxWidth;
                    } else {
                        actualHeight = maxHeight;
                        actualWidth = (int)((float)cWidth * (float)maxHeight / (float)cHeight);
                    }
                    imageArea.setWidth(actualWidth);
                    imageArea.setHeight(actualHeight);
                    this.root.setContentWidth(imageArea.getWidth());
                    this.root.setContentHeight(imageArea.getHeight());
                } else if (this.context.getPageOverflow() == 2 || this.context.getPageOverflow() == 8) {
                    imageArea.setWidth(actualWidth);
                    imageArea.setHeight(actualHeight);
                    this.root.setContentHeight(actualHeight);
                    this.root.setContentWidth(actualWidth);
                } else {
                    imageArea.setWidth(actualWidth);
                    imageArea.setHeight(actualHeight);
                    this.root.setNeedClip(true);
                    this.root.setAllocatedHeight(Math.min(maxHeight, cHeight));
                    this.root.setAllocatedWidth(Math.min(maxWidth, cWidth));
                }
            } else {
                imageArea.setWidth(actualWidth);
                imageArea.setHeight(actualHeight);
                this.root.setContentWidth(imageArea.getWidth());
                this.root.setContentHeight(imageArea.getHeight());
            }
            this.root.addChild(imageArea);
            imageArea.setPosition(this.root.getContentX(), this.root.getContentY());
            if (this.context.getEngineTaskType() != 1) {
                this.processChartLegend(this.image, imageArea);
            }
            this.root.finished = false;
        }

        protected ImageArea createImageArea(IImageContent content) {
            ImageArea area = new ImageArea();
            String mimeType = content.getMIMEType();
            String extension = content.getExtension();
            area.setExtension(extension);
            area.setMIMEType(mimeType);
            switch (content.getImageSource()) {
                case 0: 
                case 3: {
                    area.setUrl(content.getURI());
                    break;
                }
                case 1: {
                    area.setUrl("NamedImage_" + content.getURI());
                    break;
                }
            }
            if (SvgFile.isSvg(mimeType, null, extension)) {
                if (this.imageObject != null) {
                    area.setMIMEType("image/jpeg");
                    area.setExtension(".jpg");
                    area.setData(this.imageObject.rawData());
                } else {
                    area.setMIMEType("image/svg+xml");
                    area.setExtension(".svg");
                    area.setData(content.getData());
                }
            } else {
                area.setData(content.getData());
            }
            if (content instanceof ObjectContent) {
                ObjectContent object = (ObjectContent)content;
                area.setParameters(object.getParamters());
            }
            area.setAction(content.getHyperlinkAction());
            return area;
        }

        private BlockTextArea createInnerTextLayout() {
            IReportContent report = this.image.getReportContent();
            if (report == null) {
                return null;
            }
            ITextContent promptTextContent = report.createTextContent(this.image);
            ULocale locale = ULocale.forLocale((Locale)this.context.getLocale());
            if (locale == null) {
                locale = ULocale.getDefault();
            }
            EngineResourceHandle resourceHandle = new EngineResourceHandle(locale);
            String prompt = resourceHandle.getMessage("Error.UpdateUserAgent");
            promptTextContent.setText(prompt);
            return new BlockTextArea(this.root, this.context, promptTextContent);
        }

        private void processChartLegend(IImageContent imageContent, IImageArea imageArea) {
            boolean hasImageMap;
            if (this.intrinsic == null) {
                return;
            }
            Object imageMapObject = imageContent.getImageMap();
            boolean bl = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
            if (hasImageMap) {
                this.createImageMap((String)imageMapObject, imageArea);
            }
        }

        private void createImageMap(String imageMapObject, IImageArea imageArea) {
            if (imageMapObject == null) {
                return;
            }
            String[] maps = imageMapObject.split("/>");
            Pattern pattern = Pattern.compile(" ([^=]*)=\"([^\"]*)\"");
            String[] stringArray = maps;
            int n = maps.length;
            int n2 = 0;
            while (n2 < n) {
                String map = stringArray[n2];
                if ((map = map.trim()).length() != 0) {
                    TreeMap<String, String> attributes = new TreeMap<String, String>();
                    Matcher matcher = pattern.matcher(map);
                    while (matcher.find()) {
                        attributes.put(matcher.group(1), matcher.group(2));
                    }
                    try {
                        if (attributes.size() > 0) {
                            int[] area = this.getArea((String)attributes.get("coords"));
                            if (area == null) {
                                return;
                            }
                            String url = (String)attributes.get("href");
                            String targetWindow = (String)attributes.get("target");
                            this.createImageMap(area, imageArea, url, targetWindow);
                        }
                    }
                    catch (NumberFormatException e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                ++n2;
            }
        }

        private void createImageMap(int[] area, IImageArea imageArea, String url, String targetWindow) {
            if (url == null) {
                return;
            }
            url = url.replaceAll("&amp;", "&");
            ActionContent link = new ActionContent();
            if (this.isBookmark(url)) {
                String bookmark = this.getBookmark(url);
                link.setBookmark(bookmark);
            } else {
                link.setHyperlink(url, targetWindow);
            }
            area = this.getAbsoluteArea(area, imageArea);
            this.createImageMapContainer(area[0], area[1], area[2], area[3], link);
        }

        private void createImageMapContainer(int x, int y, int width, int height, IHyperlinkAction link) {
            BlockContainerArea area = new BlockContainerArea();
            area.setAction(link);
            area.setPosition(x, y);
            area.setWidth(width);
            area.setHeight(height);
            this.root.addChild(area);
        }

        private int[] getAbsoluteArea(int[] area, IImageArea imageArea) {
            assert (this.intrinsic != null);
            int i = 0;
            while (i < 4) {
                area[i] = this.getTranslatedLengthX(area[i]);
                area[++i] = this.getTranslatedLengthY(area[i]);
                ++i;
            }
            int[] result = new int[4];
            int imageX = imageArea.getX();
            int imageY = imageArea.getY();
            int imageHeight = imageArea.getHeight();
            int imageWidth = imageArea.getWidth();
            int intrinsicWidth = this.intrinsic.getWidth();
            int intrinsicHeight = this.intrinsic.getHeight();
            float ratio = (float)imageWidth / (float)intrinsicWidth;
            result[0] = imageX + (int)((float)area[0] * ratio);
            result[2] = (int)((float)area[2] * ratio);
            ratio = (float)imageHeight / (float)intrinsicHeight;
            result[1] = imageY + (int)((float)area[1] * ratio);
            result[3] = (int)((float)area[3] * ratio);
            return result;
        }

        private int[] getArea(String string) {
            String[] rawDatas = string.split(",");
            if (rawDatas.length == 8) {
                int[] area;
                area = new int[]{Integer.parseInt(rawDatas[0]), Integer.parseInt(rawDatas[1]), Integer.parseInt(rawDatas[4]) - area[0], Integer.parseInt(rawDatas[5]) - area[1]};
                return area;
            }
            return null;
        }

        private int getTranslatedLengthX(int length) {
            return length * 1000 / this.resolutionX * 72;
        }

        private int getTranslatedLengthY(int length) {
            return length * 1000 / this.resolutionY * 72;
        }

        private boolean isBookmark(String url) {
            return url.startsWith(BOOKMARK_PREFIX) && url.endsWith("')");
        }

        private String getBookmark(String url) {
            int start = url.indexOf(BOOKMARK_PREFIX) + BOOKMARK_PREFIX.length();
            int end = url.length() - 2;
            return url.substring(start, end);
        }

        protected void close() {
        }
    }
}

