/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class CharSegment {
    int start;
    int end;
    String name;

    public CharSegment(int start, int end, String name) {
        this.start = start;
        this.end = end;
        this.name = name;
    }

    public CharSegment(CharSegment seg) {
        this.start = seg.start;
        this.end = seg.end;
        this.name = seg.name;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public static int search(CharSegment[] segments, int ch) {
        int index = Arrays.binarySearch(segments, new Integer(ch), new SearchingComparator());
        if (index < 0) {
            return -1;
        }
        return index;
    }

    public static CharSegment[] merge(CharSegment[][] mergedSegs) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < mergedSegs.length) {
            list = CharSegment.merge(list, mergedSegs[i]);
            ++i;
        }
        return list.toArray(new CharSegment[0]);
    }

    public static CharSegment[] merge(ArrayList segments) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < segments.size()) {
            list = CharSegment.merge(list, (CharSegment[])segments.get(i));
            ++i;
        }
        return list.toArray(new CharSegment[0]);
    }

    public static CharSegment[] normalize(CharSegment[] segs) {
        CharSegment.sort(segs);
        if (segs.length < 2) {
            return segs;
        }
        ArrayList<CharSegment> list = new ArrayList<CharSegment>();
        CharSegment prev = segs[0];
        int i = 1;
        while (i < segs.length) {
            CharSegment next = segs[i];
            if (prev.start == next.start) {
                if (prev.end < next.end) {
                    prev.end = next.end;
                }
            } else {
                list.add(prev);
                prev = next;
            }
            ++i;
        }
        list.add(prev);
        return list.toArray(new CharSegment[0]);
    }

    protected static ArrayList merge(ArrayList src1, CharSegment[] src2) {
        ArrayList<CharSegment> tgt = new ArrayList<CharSegment>(src1.size());
        int index1 = 0;
        int index2 = 0;
        int start1 = -1;
        int end1 = 0;
        index1 = 0;
        while (index1 < src1.size()) {
            CharSegment seg1 = (CharSegment)src1.get(index1);
            end1 = seg1.start - 1;
            while (index2 < src2.length) {
                CharSegment seg2 = src2[index2];
                int start2 = seg2.start;
                int end2 = seg2.end;
                if (end2 < start1) {
                    ++index2;
                    continue;
                }
                if (start2 > end1) break;
                if (start2 >= start1) {
                    if (end2 <= end1) {
                        tgt.add(seg2);
                        ++index2;
                        continue;
                    }
                    tgt.add(new CharSegment(start2, end1, seg2.name));
                    break;
                }
                if (end2 <= end1) {
                    tgt.add(new CharSegment(start1, end2, seg2.name));
                    ++index2;
                    continue;
                }
                tgt.add(new CharSegment(start1, end1, seg2.name));
                break;
            }
            tgt.add(seg1);
            start1 = seg1.end + 1;
            ++index1;
        }
        while (index2 < src2.length) {
            CharSegment seg2 = src2[index2];
            int start2 = seg2.start;
            int end2 = seg2.end;
            if (end2 >= start1) {
                if (start2 >= start1) {
                    tgt.add(seg2);
                } else {
                    tgt.add(new CharSegment(start1, end2, seg2.name));
                }
            }
            ++index2;
        }
        return tgt;
    }

    public static void sort(CharSegment[] segments) {
        Arrays.sort(segments, new SortingComparator());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.start == this.end) {
            buffer.append(this.start);
        } else {
            buffer.append(this.start);
            buffer.append('-');
            buffer.append(this.end);
        }
        buffer.append('[');
        buffer.append(this.name);
        buffer.append(']');
        return buffer.toString();
    }

    static class SearchingComparator
    implements Comparator {
        SearchingComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            CharSegment seg = (CharSegment)arg0;
            int c = (Integer)arg1;
            if (seg.end < c) {
                return -1;
            }
            if (seg.start > c) {
                return 1;
            }
            return 0;
        }
    }

    static class SortingComparator
    implements Comparator {
        SortingComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            CharSegment seg0 = (CharSegment)arg0;
            CharSegment seg1 = (CharSegment)arg1;
            return seg0.start - seg1.start;
        }
    }
}

