/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.impl.SizeBasedContent;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.SizeBasedPageSection;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLLayoutPageHintManager {
    protected HTMLLayoutContext context;
    protected HashMap layoutHint = new HashMap();
    protected HashMap<String, SizeBasedContent> sizeBasedContentMapping = new HashMap();
    protected ArrayList pageHints = new ArrayList();
    protected HashMap<String, UnresolvedRowHint> lastPageUnresolvedRowHints = new HashMap();
    protected HashMap<String, UnresolvedRowHint> currentPageUnresolvedRowHints = new HashMap();
    protected HashMap<String, UnresolvedRowHint> parallelPagesUnresolvedRowHints = new HashMap();
    protected ArrayList columnHints = new ArrayList();

    public HTMLLayoutPageHintManager(HTMLLayoutContext context) {
        this.context = context;
    }

    public void setPageHint(List hints) {
        this.pageHints.addAll(hints);
    }

    public ArrayList getPageHint() {
        ArrayList hints = new ArrayList();
        hints.addAll(this.pageHints);
        return hints;
    }

    public void reset() {
        this.layoutHint = new HashMap();
        this.sizeBasedContentMapping = new HashMap();
        this.context.setFinish(false);
        this.context.setAllowPageBreak(true);
        this.context.setMasterPage(null);
    }

    public void addLayoutHint(IContent content, boolean finished) {
        this.layoutHint.put(content, new Boolean(finished));
    }

    public void removeLayoutHint(IContent content) {
        this.layoutHint.remove(content);
    }

    public boolean getLayoutHint(IContent content) {
        Object finished = this.layoutHint.get(content);
        if (finished != null && finished instanceof Boolean) {
            return (Boolean)finished;
        }
        return true;
    }

    public void removeLayoutHint() {
        this.layoutHint.clear();
    }

    public void generatePageRowHints(Collection<String> keys) {
        this.lastPageUnresolvedRowHints.clear();
        for (String key : keys) {
            UnresolvedRowHint hint = this.parallelPagesUnresolvedRowHints.get(key);
            if (hint == null) continue;
            this.lastPageUnresolvedRowHints.put(key, hint);
        }
    }

    public HashMap<String, UnresolvedRowHint> getUnresolvedRowHints() {
        return this.lastPageUnresolvedRowHints;
    }

    public List getTableColumnHints() {
        return this.columnHints;
    }

    public void addTableColumnHints(List hints) {
        this.columnHints.addAll(hints);
    }

    public void addTableColumnHint(TableColumnHint hint) {
        this.columnHints.add(hint);
    }

    public UnresolvedRowHint getUnresolvedRowHint(String key) {
        if (this.parallelPagesUnresolvedRowHints.size() > 0) {
            return this.parallelPagesUnresolvedRowHints.get(key);
        }
        return null;
    }

    public void addUnresolvedRowHint(String key, UnresolvedRowHint hint) {
        this.currentPageUnresolvedRowHints.put(key, hint);
    }

    public void clearPageHint() {
        this.columnHints.clear();
        this.pageHints.clear();
    }

    public void resetRowHint() {
        if (!this.context.emptyPage) {
            this.parallelPagesUnresolvedRowHints.clear();
            this.parallelPagesUnresolvedRowHints.putAll(this.currentPageUnresolvedRowHints);
            this.currentPageUnresolvedRowHints.clear();
        }
    }

    public void setLayoutPageHint(IPageHint pageHint) {
        if (pageHint != null) {
            this.context.pageNumber = pageHint.getPageNumber();
            this.context.masterPage = pageHint.getMasterPage();
            int count = pageHint.getTableColumnHintCount();
            int i = 0;
            while (i < count) {
                this.columnHints.add(pageHint.getTableColumnHint(i));
                ++i;
            }
            count = pageHint.getUnresolvedRowCount();
            if (count > 0) {
                i = 0;
                while (i < count) {
                    UnresolvedRowHint hint = pageHint.getUnresolvedRowHint(i);
                    String key = this.getHintMapKey(hint.getTableId());
                    this.parallelPagesUnresolvedRowHints.put(key, hint);
                    ++i;
                }
            }
            i = 0;
            while (i < pageHint.getSectionCount()) {
                PageSection section = pageHint.getSection(i);
                if (section instanceof SizeBasedPageSection) {
                    InstanceID endID;
                    InstanceID startID;
                    SizeBasedPageSection sizeBasedSection = (SizeBasedPageSection)section;
                    if (sizeBasedSection.start.dimension != -1 && (startID = sizeBasedSection.starts[sizeBasedSection.starts.length - 1].getInstanceID()) != null) {
                        this.sizeBasedContentMapping.put(startID.toUniqueString(), sizeBasedSection.start);
                    }
                    if (sizeBasedSection.end.dimension != -1 && (endID = sizeBasedSection.ends[sizeBasedSection.ends.length - 1].getInstanceID()) != null) {
                        this.sizeBasedContentMapping.put(endID.toUniqueString(), sizeBasedSection.end);
                    }
                }
                ++i;
            }
        }
    }

    public HashMap<String, SizeBasedContent> getSizeBasedContentMapping() {
        return this.sizeBasedContentMapping;
    }

    public String getHintMapKey(String tableId) {
        String key = tableId;
        List hints = this.getTableColumnHint(key);
        for (int[] vs : hints) {
            key = String.valueOf(key) + "-" + vs[0] + "-" + vs[1];
        }
        return key;
    }

    public List getTableColumnHint(String tableId) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        if (this.columnHints.size() > 0) {
            for (TableColumnHint hint : this.columnHints) {
                if (!tableId.equals(hint.getTableId())) continue;
                list.add(new int[]{hint.getStart(), hint.getStart() + hint.getColumnCount()});
            }
        }
        return list;
    }
}

