/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.HashMap;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.engine.IDataExtension;
import org.eclipse.birt.report.engine.extension.engine.IDocumentExtension;
import org.eclipse.birt.report.engine.extension.engine.IGenerateExtension;
import org.eclipse.birt.report.engine.extension.engine.IRenderExtension;
import org.eclipse.birt.report.engine.extension.engine.IReportEngineExtension;
import org.eclipse.birt.report.engine.extension.internal.RenderContext;
import org.eclipse.birt.report.engine.extension.internal.RunContext;

public class EngineExtensionManager {
    ExecutionContext context;
    HashMap<String, IRenderExtension> renderExtensions = new HashMap();
    HashMap<String, IGenerateExtension> generateExtensions = new HashMap();
    HashMap<String, IDocumentExtension> documentExtensions = new HashMap();
    HashMap<String, IDataExtension> dataExtensions = new HashMap();

    public EngineExtensionManager(ExecutionContext context) {
        this.context = context;
    }

    protected IReportEngineExtension getEngineExtension(String name) throws EngineException {
        ReportEngine engine = this.context.getEngine();
        if (engine != null) {
            IReportEngineExtension ext = engine.getEngineExtension(name);
            if (ext == null) {
                throw new EngineException("Unsupported engine extension {0} ", new Object[]{name});
            }
            return ext;
        }
        return null;
    }

    public IRenderExtension getRenderExtension(String name) throws EngineException {
        if (this.renderExtensions.containsKey(name)) {
            return this.renderExtensions.get(name);
        }
        IReportEngineExtension extension = this.getEngineExtension(name);
        if (extension != null) {
            IRenderExtension renderExtension = extension.createRenderExtension(new RenderContext(this.context));
            this.renderExtensions.put(name, renderExtension);
            return renderExtension;
        }
        return null;
    }

    public IGenerateExtension getGenerateExtension(String name) throws EngineException {
        if (this.generateExtensions.containsKey(name)) {
            return this.generateExtensions.get(name);
        }
        IReportEngineExtension extension = this.getEngineExtension(name);
        if (extension != null) {
            IGenerateExtension generateExtension = extension.createGenerateExtension(new RunContext(this.context));
            this.generateExtensions.put(name, generateExtension);
            return generateExtension;
        }
        return null;
    }

    public IDocumentExtension getDocumentExtension(String name) throws EngineException {
        if (this.documentExtensions.containsKey(name)) {
            return this.documentExtensions.get(name);
        }
        IReportEngineExtension extension = this.getEngineExtension(name);
        if (extension != null) {
            IDocumentExtension documentExtension = extension.createDocumentExtension(new RunContext(this.context));
            this.documentExtensions.put(name, documentExtension);
            return documentExtension;
        }
        return null;
    }

    public IDataExtension getDataExtension(String name) throws EngineException {
        if (this.dataExtensions.containsKey(name)) {
            return this.dataExtensions.get(name);
        }
        IReportEngineExtension extension = this.getEngineExtension(name);
        if (extension != null) {
            IDataExtension dataExtension = extension.createDataExtension(new RunContext(this.context));
            this.dataExtensions.put(name, dataExtension);
            return dataExtension;
        }
        return null;
    }

    public void close() {
        for (IGenerateExtension generateExt : this.generateExtensions.values()) {
            if (generateExt == null) continue;
            generateExt.close();
        }
        for (IRenderExtension renderExt : this.renderExtensions.values()) {
            if (renderExt == null) continue;
            renderExt.close();
        }
        for (IDocumentExtension documentExt : this.documentExtensions.values()) {
            if (documentExt == null) continue;
            documentExt.close();
        }
        for (IDataExtension dataExt : this.dataExtensions.values()) {
            if (dataExt == null) continue;
            dataExt.close();
        }
        this.generateExtensions.clear();
        this.renderExtensions.clear();
        this.documentExtensions.clear();
    }
}

