/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ResultSetIndex {
    private Map<String, QueryResultSets> queries = new HashMap<String, QueryResultSets>();

    public void addResultSet(String query, String parent, String row, String rset) {
        QueryResultSets rsets = this.queries.get(query);
        if (rsets == null) {
            rsets = new QueryResultSets();
            this.queries.put(query, rsets);
        }
        rsets.addResultSet(parent, row, rset);
    }

    public String getResultSet(String query, String parent, String row) {
        QueryResultSets rsets = this.queries.get(query);
        if (rsets != null) {
            int charAt;
            String rset = rsets.getResultSet(parent, row);
            if (rset == null && parent != null && (charAt = parent.indexOf("_")) != -1) {
                String root = parent.substring(0, charAt);
                return rsets.getResultSet(root, row);
            }
            return rset;
        }
        return null;
    }

    private static class QueryResultSets {
        Map<String, ResultSets> results = new HashMap<String, ResultSets>();

        private QueryResultSets() {
        }

        void addResultSet(String parent, String row, String rset) {
            ResultSets rsets = this.results.get(parent);
            if (rsets == null) {
                rsets = new ResultSets();
                this.results.put(parent, rsets);
            }
            rsets.addResultSet(row, rset);
        }

        String getResultSet(String parent, String row) {
            ResultSets rsets = this.results.get(parent);
            if (rsets == null) {
                return null;
            }
            return rsets.getResultSet(row);
        }
    }

    private static class ResultSetEntry {
        int row;
        String rset;

        ResultSetEntry(int row, String rset) {
            this.row = row;
            this.rset = rset;
        }
    }

    private static class ResultSets {
        static Comparator<ResultSetEntry> comparator = new Comparator<ResultSetEntry>(){

            @Override
            public int compare(ResultSetEntry e1, ResultSetEntry e2) {
                if (e1.row == e2.row) {
                    return 0;
                }
                if (e1.row < e2.row) {
                    return -1;
                }
                return 1;
            }
        };
        ResultSetEntry[] entries;
        Collection<ResultSetEntry> rsets = new ArrayList<ResultSetEntry>();
        Map<String, String> stringIdResets = new HashMap<String, String>();

        private ResultSets() {
        }

        void addResultSet(String rowId, String rset) {
            try {
                int intRowId = Integer.parseInt(rowId);
                this.addWithIntId(intRowId, rset);
            }
            catch (NumberFormatException numberFormatException) {
                this.addWithStringId(rowId, rset);
            }
        }

        String getResultSet(String rowId) {
            try {
                int intRowId = Integer.parseInt(rowId);
                return this.getIntRowId(intRowId);
            }
            catch (NumberFormatException numberFormatException) {
                return this.getResultSetWithStringRowId(rowId);
            }
        }

        private void addWithIntId(int rowId, String rset) {
            if (this.entries != null) {
                throw new IllegalStateException();
            }
            this.rsets.add(new ResultSetEntry(rowId, rset));
        }

        private void addWithStringId(String rowId, String rset) {
            this.stringIdResets.put(rowId, rset);
        }

        private String getResultSetWithStringRowId(String rowId) {
            return this.stringIdResets.get(rowId);
        }

        private String getIntRowId(int rowId) {
            int index;
            if (this.entries == null) {
                this.entries = this.rsets.toArray(new ResultSetEntry[this.rsets.size()]);
                Arrays.sort(this.entries, comparator);
            }
            if ((index = Arrays.binarySearch(this.entries, new ResultSetEntry(rowId, ""), comparator)) < 0) {
                index = -(index + 1) - 1;
            }
            if (index < 0) {
                index = 0;
            }
            if (index >= 0 && index < this.entries.length) {
                return this.entries[index].rset;
            }
            return null;
        }
    }
}

