/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.css.dom.CompositeStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class Column
implements IColumn {
    protected transient ReportContent report;
    protected transient CSSEngine cssEngine;
    protected DimensionType width;
    protected String styleClass;
    protected InstanceID instanceId;
    protected String visibleFormat;
    protected IStyle inlineStyle;
    protected transient IStyle style;
    protected transient IStyle computedStyle;
    protected transient Object generateBy;
    protected Boolean isColumnHeader = null;
    protected boolean isRepeated;
    protected static final int VERSION = 0;
    static final int FIELD_NONE = -1;
    static final int FIELD_WIDTH = 0;
    static final int FIELD_STYLECLASS = 1;
    static final int FIELD_INSTANCE_ID = 2;
    static final int FIELD_VISIBLE_FORMAT = 3;
    static final int FIELD_INLINESTYLE_VERSION_0 = 8;
    static final int FIELD_ISCOLUMNHEADER = 9;
    static final int FIELD_INLINESTYLE_VERSION_1 = 10;
    static final int FIELD_ISREPEAT = 11;

    public Column(IReportContent report) {
        assert (report != null && report instanceof ReportContent);
        this.report = (ReportContent)report;
        this.cssEngine = this.report.getCSSEngine();
    }

    public IStyle getStyle() {
        if (this.style == null) {
            if (this.inlineStyle == null) {
                this.inlineStyle = this.report.createStyle();
            }
            String styleClass = this.getStyleClass();
            IStyle classStyle = this.report.findStyle(styleClass);
            this.style = new CompositeStyle(classStyle, this.inlineStyle);
        }
        return this.style;
    }

    public boolean isColumnHeader() {
        if (this.isColumnHeader != null) {
            return this.isColumnHeader;
        }
        if (this.generateBy instanceof ColumnDesign) {
            return ((ColumnDesign)this.generateBy).isColumnHeader();
        }
        return false;
    }

    public void setColumnHeaderState(boolean isColumnHeader) {
        this.isColumnHeader = isColumnHeader;
    }

    public DimensionType getWidth() {
        if (this.width != null) {
            return this.width;
        }
        if (this.generateBy instanceof ColumnDesign) {
            return ((ColumnDesign)this.generateBy).getWidth();
        }
        return null;
    }

    public void setWidth(DimensionType width) {
        this.width = width;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        if (this.generateBy instanceof ColumnDesign) {
            return ((ColumnDesign)this.generateBy).getStyleName();
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public InstanceID getInstanceID() {
        return this.instanceId;
    }

    public void setInstanceID(InstanceID id) {
        this.instanceId = id;
    }

    public String getVisibleFormat() {
        return this.visibleFormat;
    }

    public void setVisibleFormat(String visibleFormat) {
        this.visibleFormat = visibleFormat;
    }

    public void setInlineStyle(IStyle style) {
        this.inlineStyle = style;
        this.style = null;
        this.computedStyle = null;
    }

    public IStyle getInlineStyle() {
        return this.inlineStyle;
    }

    public void setGenerateBy(Object generateBy) {
        this.generateBy = generateBy;
    }

    public Object getGenerateBy() {
        return this.generateBy;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        if (this.width != null) {
            IOUtil.writeInt((OutputStream)out, (int)0);
            this.width.writeObject(out);
        }
        if (this.styleClass != null) {
            IOUtil.writeInt((OutputStream)out, (int)1);
            IOUtil.writeString((DataOutputStream)out, (String)this.styleClass);
        }
        if (this.instanceId != null) {
            IOUtil.writeInt((OutputStream)out, (int)2);
            IOUtil.writeString((DataOutputStream)out, (String)this.instanceId.toString());
        }
        if (this.visibleFormat != null) {
            IOUtil.writeInt((OutputStream)out, (int)3);
            IOUtil.writeString((DataOutputStream)out, (String)this.visibleFormat);
        }
        if (this.inlineStyle != null && !this.inlineStyle.isEmpty()) {
            IOUtil.writeInt((OutputStream)out, (int)10);
            this.inlineStyle.write(out);
        }
        if (this.isColumnHeader != null && this.isColumnHeader.booleanValue()) {
            IOUtil.writeInt((OutputStream)out, (int)9);
            IOUtil.writeBool((OutputStream)out, (boolean)this.isColumnHeader);
        }
        if (this.isRepeated) {
            IOUtil.writeInt((OutputStream)out, (int)11);
            IOUtil.writeBool((OutputStream)out, (boolean)this.isRepeated);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 0: {
                this.width = new DimensionType();
                this.width.readObject(in);
                break;
            }
            case 1: {
                this.styleClass = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 2: {
                String value = IOUtil.readString((DataInputStream)in);
                this.instanceId = InstanceID.parse(value);
                break;
            }
            case 3: {
                this.visibleFormat = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 8: {
                String styleCssText = IOUtil.readString((DataInputStream)in);
                if (styleCssText == null || styleCssText.length() == 0) break;
                this.inlineStyle = new StyleDeclaration(this.cssEngine);
                this.inlineStyle.setCssText(styleCssText);
                break;
            }
            case 10: {
                StyleDeclaration style = new StyleDeclaration(this.cssEngine);
                if (style == null) break;
                style.read(in);
                if (style.isEmpty()) break;
                this.inlineStyle = style;
                break;
            }
            case 9: {
                this.isColumnHeader = IOUtil.readBool((InputStream)in);
                break;
            }
            case 11: {
                this.isRepeated = IOUtil.readBool((InputStream)in);
            }
        }
    }

    public void readObject(DataInputStream in, ClassLoader loader) throws IOException {
        int version = IOUtil.readInt((InputStream)in);
        int filedId = IOUtil.readInt((InputStream)in);
        while (filedId != -1) {
            this.readField(version, filedId, in, loader);
            filedId = IOUtil.readInt((InputStream)in);
        }
    }

    public void writeObject(DataOutputStream out) throws IOException {
        IOUtil.writeInt((OutputStream)out, (int)0);
        this.writeFields(out);
        IOUtil.writeInt((OutputStream)out, (int)-1);
    }

    public CSSEngine getCssEngine() {
        return this.cssEngine;
    }

    public boolean hasDataItemsInDetail() {
        if (this.generateBy instanceof ColumnDesign) {
            return ((ColumnDesign)this.generateBy).hasDataItemsInDetail();
        }
        return false;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    public void setRepeated(boolean isRepeated) {
        this.isRepeated = isRepeated;
    }

    public IStyle getComputedStyle() {
        return this.getStyle();
    }
}

