/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;

public class SubqueryResultMetaData
implements IResultMetaData {
    ArrayList<MetaData> metas = new ArrayList();

    public SubqueryResultMetaData(ISubqueryDefinition subquery, HashMap map) throws BirtException {
        MetaData meta;
        String columnName;
        int index;
        int columnCount;
        ResultMetaData metaData;
        HashSet<String> names = new HashSet<String>();
        ISubqueryDefinition tmpQuery = subquery;
        while (tmpQuery instanceof ISubqueryDefinition) {
            metaData = (ResultMetaData)map.get(tmpQuery);
            columnCount = metaData.getColumnCount();
            index = 0;
            while (index < columnCount) {
                columnName = metaData.getColumnName(index);
                if (!(names.contains(columnName) || tmpQuery != subquery && this.columnIsAggregateOn(columnName, (IBaseQueryDefinition)tmpQuery))) {
                    meta = new MetaData();
                    meta.columnName = columnName;
                    meta.columnAlias = metaData.getColumnAlias(index);
                    meta.columnLabel = metaData.getColumnLabel(index);
                    meta.columnType = metaData.getColumnType(index);
                    meta.columnTypeName = metaData.getColumnTypeName(index);
                    this.metas.add(meta);
                    names.add(columnName);
                }
                ++index;
            }
            tmpQuery = tmpQuery.getParentQuery();
        }
        metaData = (ResultMetaData)map.get(tmpQuery);
        columnCount = metaData.getColumnCount();
        index = 0;
        while (index < columnCount) {
            columnName = metaData.getColumnName(index);
            if (!(names.contains(columnName) || tmpQuery != subquery && this.columnIsAggregateOn(columnName, (IBaseQueryDefinition)tmpQuery))) {
                meta = new MetaData();
                meta.columnName = columnName;
                meta.columnAlias = metaData.getColumnAlias(index);
                meta.columnLabel = metaData.getColumnLabel(index);
                meta.columnType = metaData.getColumnType(index);
                meta.columnTypeName = metaData.getColumnTypeName(index);
                this.metas.add(meta);
                names.add(columnName);
            }
            ++index;
        }
    }

    private boolean columnIsAggregateOn(String column, IBaseQueryDefinition query) throws BirtException {
        boolean result = false;
        Map bindings = query.getBindings();
        IBinding binding = (IBinding)bindings.get(column);
        if (binding != null) {
            List aggregates = binding.getAggregatOns();
            if (aggregates != null && aggregates.size() > 0 || binding.getAggrFunction() != null) {
                result = true;
            } else {
                IBaseExpression expr = binding.getExpression();
                if (expr instanceof IScriptExpression && ExpressionUtil.hasAggregation((String)((IScriptExpression)expr).getText())) {
                    result = true;
                }
            }
        }
        return result;
    }

    public String getColumnAlias(int index) throws BirtException {
        return this.metas.get((int)index).columnAlias;
    }

    public int getColumnCount() {
        return this.metas.size();
    }

    public String getColumnLabel(int index) throws BirtException {
        return this.metas.get((int)index).columnLabel;
    }

    public String getColumnName(int index) throws BirtException {
        return this.metas.get((int)index).columnName;
    }

    public int getColumnType(int index) throws BirtException {
        return this.metas.get((int)index).columnType;
    }

    public String getColumnTypeName(int index) throws BirtException {
        return this.metas.get((int)index).columnTypeName;
    }

    private class MetaData {
        String columnName;
        String columnAlias;
        String columnLabel;
        int columnType;
        String columnTypeName;

        private MetaData() {
        }
    }
}

