/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.LabelAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PieTitleSheet
extends AbstractPopupSheet
implements Listener {
    private Composite cmpContent = null;
    private LabelAttributesComposite lacTitle = null;
    private SeriesDefinition seriesDefn = null;

    public PieTitleSheet(String title, ChartWizardContext context, SeriesDefinition seriesDefn) {
        super(title, context, false);
        this.seriesDefn = seriesDefn;
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.TextFormat_ID");
        GridLayout glContent = new GridLayout();
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        LabelAttributesComposite.LabelAttributesContext attributesContext = new LabelAttributesComposite.LabelAttributesContext();
        attributesContext.isFontAlignmentEnabled = false;
        this.lacTitle = new LabelAttributesComposite(this.cmpContent, 0, this.getContext(), attributesContext, Messages.getString("OrthogonalSeriesLabelAttributeSheetImpl.Lbl.Title"), this.getSeriesForProcessing().getTitlePosition(), this.getLabel(), this.getChart().getUnits(), 15);
        GridData gdLACTitle = new GridData(768);
        gdLACTitle.widthHint = 200;
        this.lacTitle.setLayoutData(gdLACTitle);
        this.lacTitle.addListener(this);
        return this.cmpContent;
    }

    private PieSeries getSeriesForProcessing() {
        return (PieSeries)this.seriesDefn.getDesignTimeSeries();
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.lacTitle)) {
            switch (event.type) {
                case 1: {
                    this.getLabel().setVisible(((Boolean)event.data).booleanValue());
                    break;
                }
                case 2: {
                    this.getSeriesForProcessing().setTitlePosition((Position)event.data);
                    break;
                }
                case 3: {
                    this.getLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
                    this.getLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
                    break;
                }
                case 4: {
                    this.getLabel().setBackground((Fill)event.data);
                    break;
                }
                case 5: {
                    this.getLabel().setShadowColor((ColorDefinition)event.data);
                    break;
                }
                case 6: {
                    this.getLabel().getOutline().setStyle((LineStyle)event.data);
                    break;
                }
                case 7: {
                    this.getLabel().getOutline().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 8: {
                    this.getLabel().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 9: {
                    this.getLabel().getOutline().setVisible(((Boolean)event.data).booleanValue());
                    break;
                }
                case 10: {
                    this.getLabel().setInsets((Insets)event.data);
                }
            }
        }
    }

    private Label getLabel() {
        return this.getSeriesForProcessing().getTitle();
    }
}

