/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart;

import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Direction;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Stretch;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.InsetsComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class LegendLayoutSheet
extends AbstractPopupSheet
implements Listener,
ModifyListener,
SelectionListener {
    private transient Combo cmbAnchor;
    private transient Combo cmbStretch;
    private transient LineAttributesComposite outlineLegend;
    private transient InsetsComposite icLegend;
    private transient Combo cmbOrientation;
    private transient Combo cmbPosition;
    private transient FillChooserComposite fccBackground;
    private transient Combo cmbDirection;
    private transient LocalizedNumberEditorComposite txtWrapping;
    private transient Label lblDirection;
    private transient Label lblBackground;
    private transient Label lblStretch;
    private transient Label lblAnchor;
    private transient Label lblPosition;
    private transient Label lblOrientation;
    private transient Label lblWrapping;
    private Spinner spnMaxPercent;
    private Spinner spnTitlePercent;

    public LegendLayoutSheet(String title, ChartWizardContext context) {
        super(title, context, false);
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.LegendLayout_ID");
        Composite cmpContent = new Composite(parent, 0);
        cmpContent.setLayout((Layout)new GridLayout());
        Group grpLegendArea = new Group(cmpContent, 0);
        grpLegendArea.setLayout((Layout)new GridLayout(2, false));
        grpLegendArea.setLayoutData((Object)new GridData(768));
        grpLegendArea.setText(Messages.getString("MoreOptionsChartLegendSheet.Label.LegendArea"));
        Composite cmpLegLeft = new Composite((Composite)grpLegendArea, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginRight = 4;
        gl.horizontalSpacing = 8;
        cmpLegLeft.setLayout((Layout)gl);
        cmpLegLeft.setLayoutData((Object)new GridData(770));
        this.getComponentLegendLeftArea(cmpLegLeft);
        Composite cmpLegRight = new Composite((Composite)grpLegendArea, 0);
        GridLayout gl2 = new GridLayout();
        gl2.marginHeight = 0;
        gl2.marginWidth = 0;
        gl2.verticalSpacing = 10;
        cmpLegRight.setLayout((Layout)gl2);
        GridData gd = new GridData(768);
        gd.verticalAlignment = 1;
        cmpLegRight.setLayoutData((Object)gd);
        this.getComponentLegendRightArea(cmpLegRight);
        this.populateLists();
        return cmpContent;
    }

    private Spinner createSpinner(Composite cmp, String sCaption, double dValue, boolean bEnableUI) {
        new Label(cmp, 0).setText(sCaption);
        Spinner spn = new Spinner(cmp, 2048);
        int spnValue = (int)(dValue * 100.0);
        spn.setValues(spnValue, 1, 100, 0, 1, 10);
        GridData gd = new GridData(768);
        spn.setLayoutData((Object)gd);
        spn.setEnabled(bEnableUI);
        spn.addListener(13, (Listener)this);
        return spn;
    }

    private void getComponentLegendLeftArea(Composite cmpLegLeft) {
        boolean bEnableUI = this.getBlockForProcessing().isVisible();
        this.lblOrientation = new Label(cmpLegLeft, 0);
        this.lblOrientation.setText(Messages.getString("BlockAttributeComposite.Lbl.Orientation"));
        this.lblOrientation.setEnabled(bEnableUI);
        this.cmbOrientation = new Combo(cmpLegLeft, 12);
        GridData gdCMBOrientation = new GridData(768);
        this.cmbOrientation.setLayoutData((Object)gdCMBOrientation);
        this.cmbOrientation.addSelectionListener((SelectionListener)this);
        this.cmbOrientation.setEnabled(bEnableUI);
        this.lblPosition = new Label(cmpLegLeft, 0);
        this.lblPosition.setText(Messages.getString("BlockAttributeComposite.Lbl.Position"));
        this.lblPosition.setEnabled(bEnableUI);
        this.cmbPosition = new Combo(cmpLegLeft, 12);
        GridData gdCMBPosition = new GridData(768);
        this.cmbPosition.setLayoutData((Object)gdCMBPosition);
        this.cmbPosition.addSelectionListener((SelectionListener)this);
        this.cmbPosition.setEnabled(bEnableUI);
        this.lblAnchor = new Label(cmpLegLeft, 0);
        this.lblAnchor.setText(Messages.getString("BlockAttributeComposite.Lbl.Anchor"));
        this.lblAnchor.setEnabled(bEnableUI);
        this.cmbAnchor = new Combo(cmpLegLeft, 12);
        GridData gdCBAnchor = new GridData(768);
        this.cmbAnchor.setLayoutData((Object)gdCBAnchor);
        this.cmbAnchor.addSelectionListener((SelectionListener)this);
        this.cmbAnchor.setEnabled(bEnableUI);
        this.lblStretch = new Label(cmpLegLeft, 0);
        this.lblStretch.setText(Messages.getString("BlockAttributeComposite.Lbl.Stretch"));
        this.lblStretch.setEnabled(bEnableUI);
        this.cmbStretch = new Combo(cmpLegLeft, 12);
        GridData gdCBStretch = new GridData(768);
        this.cmbStretch.setLayoutData((Object)gdCBStretch);
        this.cmbStretch.addSelectionListener((SelectionListener)this);
        this.cmbStretch.setEnabled(bEnableUI);
        this.lblBackground = new Label(cmpLegLeft, 0);
        this.lblBackground.setText(Messages.getString("Shared.mne.Background_K"));
        this.lblBackground.setEnabled(bEnableUI);
        this.fccBackground = new FillChooserComposite(cmpLegLeft, 0, this.getContext(), this.getBlockForProcessing().getBackground(), true, true);
        GridData gdFCCBackground = new GridData(768);
        this.fccBackground.setLayoutData(gdFCCBackground);
        this.fccBackground.addListener(this);
        this.fccBackground.setEnabled(bEnableUI);
        this.lblDirection = new Label(cmpLegLeft, 0);
        this.lblDirection.setText(Messages.getString("BlockAttributeComposite.Lbl.Direction"));
        this.lblDirection.setEnabled(bEnableUI);
        this.cmbDirection = new Combo(cmpLegLeft, 12);
        GridData gdCMBDirection = new GridData(768);
        this.cmbDirection.setLayoutData((Object)gdCMBDirection);
        this.cmbDirection.addSelectionListener((SelectionListener)this);
        this.cmbDirection.setEnabled(bEnableUI);
        this.lblWrapping = new Label(cmpLegLeft, 0);
        this.lblWrapping.setText(Messages.getString("LegendLayoutSheet.Label.WrappingWidth"));
        this.lblWrapping.setEnabled(bEnableUI);
        this.txtWrapping = new LocalizedNumberEditorComposite(cmpLegLeft, 2052);
        new TextNumberEditorAssistField(this.txtWrapping.getTextControl(), null);
        GridData gd = new GridData(768);
        this.txtWrapping.setLayoutData(gd);
        this.txtWrapping.setValue(this.getBlockForProcessing().getWrappingSize());
        this.txtWrapping.addModifyListener(this);
        this.txtWrapping.setEnabled(bEnableUI);
        this.spnMaxPercent = this.createSpinner(cmpLegLeft, Messages.getString("LegendLayoutSheet.Label.MaxPercent"), this.getBlockForProcessing().getMaxPercent(), bEnableUI);
        this.spnTitlePercent = this.createSpinner(cmpLegLeft, Messages.getString("LegendLayoutSheet.Label.TitlePercent"), this.getBlockForProcessing().getTitlePercent(), bEnableUI);
    }

    private void getComponentLegendRightArea(Composite cmpLegRight) {
        Group grpOutline = new Group(cmpLegRight, 0);
        GridData gdGRPOutline = new GridData(768);
        grpOutline.setLayoutData((Object)gdGRPOutline);
        grpOutline.setLayout((Layout)new FillLayout());
        grpOutline.setText(Messages.getString("MoreOptionsChartLegendSheet.Label.Outline"));
        boolean bEnableUI = this.getBlockForProcessing().isVisible();
        this.outlineLegend = new LineAttributesComposite((Composite)grpOutline, 0, this.getContext(), this.getBlockForProcessing().getOutline(), true, true, true);
        this.outlineLegend.addListener(this);
        this.outlineLegend.setAttributesEnabled(bEnableUI);
        this.icLegend = new InsetsComposite(cmpLegRight, 0, this.getBlockForProcessing().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider());
        GridData gdICBlock = new GridData(768);
        this.icLegend.setLayoutData(gdICBlock);
        this.icLegend.addListener(this);
        this.icLegend.setEnabled(bEnableUI);
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.stretchSet;
        this.cmbStretch.setItems(ns.getDisplayNames());
        this.cmbStretch.select(ns.getSafeNameIndex(this.getBlockForProcessing().getStretch().getName()));
        ns = LiteralHelper.orientationSet;
        this.cmbOrientation.setItems(ns.getDisplayNames());
        this.cmbOrientation.select(ns.getSafeNameIndex(this.getBlockForProcessing().getOrientation().getName()));
        ns = LiteralHelper.directionSet;
        this.cmbDirection.setItems(ns.getDisplayNames());
        this.cmbDirection.select(ns.getSafeNameIndex(this.getBlockForProcessing().getDirection().getName()));
        ns = LiteralHelper.notOutPositionSet;
        this.cmbPosition.setItems(ns.getDisplayNames());
        this.cmbPosition.select(ns.getSafeNameIndex(this.getBlockForProcessing().getPosition().getName()));
        this.getAnchorSet();
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals((Object)this.txtWrapping)) {
            this.getBlockForProcessing().setWrappingSize(this.txtWrapping.getValue());
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccBackground)) {
            this.getBlockForProcessing().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.outlineLegend)) {
            switch (event.type) {
                case 1: {
                    this.getBlockForProcessing().getOutline().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.getBlockForProcessing().getOutline().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.getBlockForProcessing().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    this.getBlockForProcessing().getOutline().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (event.widget.equals((Object)this.icLegend)) {
            this.getBlockForProcessing().setInsets((Insets)event.data);
        } else if (event.widget == this.spnMaxPercent) {
            this.getBlockForProcessing().setMaxPercent((double)this.spnMaxPercent.getSelection() / 100.0);
        } else if (event.widget == this.spnTitlePercent) {
            this.getBlockForProcessing().setTitlePercent((double)this.spnTitlePercent.getSelection() / 100.0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.cmbAnchor)) {
            String positionValue = this.getBlockForProcessing().getPosition().getLiteral();
            NameSet ns = positionValue.equals(Position.LEFT_LITERAL.getLiteral()) || positionValue.equals(Position.RIGHT_LITERAL.getLiteral()) ? LiteralHelper.verticalAnchorSet : (positionValue.equals(Position.ABOVE_LITERAL.getLiteral()) || positionValue.equals(Position.BELOW_LITERAL.getLiteral()) ? LiteralHelper.horizontalAnchorSet : LiteralHelper.anchorSet);
            this.getBlockForProcessing().setAnchor(Anchor.getByName((String)ns.getNameByDisplayName(this.cmbAnchor.getText())));
        } else if (oSource.equals(this.cmbStretch)) {
            this.getBlockForProcessing().setStretch(Stretch.getByName((String)LiteralHelper.stretchSet.getNameByDisplayName(this.cmbStretch.getText())));
        } else if (oSource.equals(this.cmbOrientation)) {
            this.getBlockForProcessing().setOrientation(Orientation.getByName((String)LiteralHelper.orientationSet.getNameByDisplayName(this.cmbOrientation.getText())));
        } else if (oSource.equals(this.cmbDirection)) {
            this.getBlockForProcessing().setDirection(Direction.getByName((String)LiteralHelper.directionSet.getNameByDisplayName(this.cmbDirection.getText())));
        } else if (oSource.equals(this.cmbPosition)) {
            this.getBlockForProcessing().setPosition(Position.getByName((String)LiteralHelper.notOutPositionSet.getNameByDisplayName(this.cmbPosition.getText())));
            this.getAnchorSet();
        }
    }

    private Legend getBlockForProcessing() {
        return this.getChart().getLegend();
    }

    private void getAnchorSet() {
        String positionValue = this.getBlockForProcessing().getPosition().getLiteral();
        NameSet ns = positionValue.equals(Position.LEFT_LITERAL.getLiteral()) || positionValue.equals(Position.RIGHT_LITERAL.getLiteral()) ? LiteralHelper.verticalAnchorSet : (positionValue.equals(Position.ABOVE_LITERAL.getLiteral()) || positionValue.equals(Position.BELOW_LITERAL.getLiteral()) ? LiteralHelper.horizontalAnchorSet : LiteralHelper.anchorSet);
        this.cmbAnchor.setItems(ns.getDisplayNames());
        this.cmbAnchor.select(ns.getSafeNameIndex(this.getBlockForProcessing().getAnchor().getName()));
    }
}

