/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.IChartObject;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPreviewable;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.preview.ChartLivePreviewThread;
import org.eclipse.birt.chart.ui.swt.wizard.preview.LivePreviewTask;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.SimpleTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskSelectType
extends SimpleTask
implements SelectionListener,
ITaskChangeListener,
ITaskPreviewable {
    private Chart chartModel = null;
    private ChartAdapter adapter = null;
    private Composite cmpType = null;
    private Composite cmpMisc = null;
    private Composite cmpRight = null;
    private Composite cmpLeft = null;
    private Composite cmpTypeButtons = null;
    private Composite cmpSubTypes = null;
    protected IChartPreviewPainter previewPainter = null;
    private Canvas previewCanvas = null;
    private RowData rowData = new RowData(80, 80);
    protected String sSubType = null;
    protected String sType = null;
    private String sOldType = null;
    protected String sDimension = null;
    private Table table = null;
    private Vector<String> vSubTypeNames = null;
    protected Orientation orientation = null;
    private Label lblOrientation = null;
    private Button cbOrientation = null;
    private Label lblMultipleY = null;
    protected Combo cbMultipleY = null;
    private Label lblSeriesType = null;
    private Combo cbSeriesType = null;
    private Combo cbDimension = null;
    private SashForm foSashForm;
    protected int pageMargin = 80;
    private static final String LEADING_BLANKS = "  ";
    private static Hashtable<String, Series> htSeriesNames = null;
    private static String[] outputFormats;
    private static String[] outputDisplayNames;
    protected List<TaskSelectTypeUIDescriptor> lstDescriptor = new LinkedList<TaskSelectTypeUIDescriptor>();

    static {
        try {
            outputFormats = ChartUtil.getSupportedOutputFormats();
            outputDisplayNames = ChartUtil.getSupportedOutputDisplayNames();
        }
        catch (ChartException e) {
            WizardBase.displayException((Throwable)e);
            outputFormats = new String[0];
            outputDisplayNames = new String[0];
        }
    }

    public TaskSelectType() {
        super(Messages.getString("TaskSelectType.TaskExp"));
        this.setDescription(Messages.getString("TaskSelectType.Task.Description"));
        if (this.chartModel != null) {
            this.sOldType = this.sType = this.chartModel.getType();
            this.sSubType = this.chartModel.getSubType();
            this.sDimension = this.translateDimensionString(this.chartModel.getDimension().getName());
            if (this.chartModel instanceof ChartWithAxes) {
                this.orientation = ((ChartWithAxes)this.chartModel).getOrientation();
            }
        }
    }

    public void createControl(Composite parent) {
        if (this.topControl == null || this.topControl.isDisposed()) {
            this.topControl = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = this.pageMargin;
            this.topControl.setLayout((Layout)gridLayout);
            this.topControl.setLayoutData((Object)new GridData(1536));
            if (this.context != null) {
                this.chartModel = ((ChartWizardContext)this.context).getModel();
            }
            this.placeComponents();
            this.updateAdapters();
        }
        this.updateDimensionCombo(this.sType);
        if (((ChartWizardContext)this.getContext()).isMoreAxesSupported()) {
            this.createAndDisplayTypesSheet(this.sType);
            this.setDefaultSubtypeSelection();
            this.cmpMisc.layout();
        }
        this.updateSelection();
        this.doPreview();
        this.bindHelp();
    }

    protected void bindHelp() {
        ChartUIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.chart.cshelp.SelectChartType_ID");
    }

    private void placeComponents() {
        this.foSashForm = new SashForm(this.topControl, 512);
        GridLayout layout = new GridLayout();
        this.foSashForm.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 570;
        this.foSashForm.setLayoutData((Object)gridData);
        this.createPreviewArea();
        this.createTypeArea();
        this.setDefaultTypeSelection();
        if (this.chartModel == null) {
            this.refreshChart();
        }
        this.populateSeriesTypesList();
    }

    private void createPreviewArea() {
        Composite cmpPreview = new Composite((Composite)this.foSashForm, 0);
        cmpPreview.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 270;
        cmpPreview.setLayoutData((Object)gridData);
        Label label = new Label(cmpPreview, 0);
        label.setText(Messages.getString("TaskSelectType.Label.Preview"));
        label.setFont(JFaceResources.getBannerFont());
        this.previewCanvas = new Canvas(cmpPreview, 2048);
        this.previewCanvas.setLayoutData((Object)new GridData(1808));
        this.previewCanvas.setBackground(Display.getDefault().getSystemColor(22));
        this.previewPainter = this.createPreviewPainter();
    }

    private void createTypeArea() {
        ScrolledComposite sc = new ScrolledComposite((Composite)this.foSashForm, 512);
        GridLayout layout = new GridLayout();
        sc.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        sc.setLayoutData((Object)gridData);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.cmpType = new Composite((Composite)sc, 0);
        this.cmpType.setLayout((Layout)new GridLayout(2, false));
        this.cmpType.setLayoutData((Object)new GridData(768));
        sc.setContent((Control)this.cmpType);
        this.createTypeTable();
        this.addChartTypes();
        this.createDetails();
        Point size = this.cmpType.computeSize(-1, -1);
        sc.setMinSize(size);
    }

    private void createDetails() {
        this.cmpRight = new Composite(this.cmpType, 0);
        this.cmpRight.setLayout((Layout)new GridLayout());
        this.cmpRight.setLayoutData((Object)new GridData(1808));
        this.createComposite(new Vector<IChartSubType>());
        this.createMiscArea();
    }

    private void createMiscArea() {
        this.cmpMisc = new Composite(this.cmpRight, 0);
        this.cmpMisc.setLayout((Layout)new GridLayout(4, false));
        this.cmpMisc.setLayoutData((Object)new GridData(1808));
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(){

            public int getIndex() {
                return 10;
            }

            public void createControl(Composite parent) {
                Label lblDimension = new Label(parent, 64);
                GridData gd = new GridData(768);
                lblDimension.setLayoutData((Object)gd);
                lblDimension.setText(Messages.getString("TaskSelectType.Label.Dimension"));
                TaskSelectType.this.cbDimension = new Combo(parent, 12);
                gd = new GridData(768);
                TaskSelectType.this.cbDimension.setLayoutData((Object)gd);
                TaskSelectType.this.cbDimension.addSelectionListener((SelectionListener)TaskSelectType.this);
            }
        });
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(){

            public int getIndex() {
                return 30;
            }

            public void createControl(Composite parent) {
                TaskSelectType.this.lblMultipleY = new Label(parent, 64);
                GridData gd = new GridData(768);
                TaskSelectType.this.lblMultipleY.setLayoutData((Object)gd);
                TaskSelectType.this.lblMultipleY.setText(Messages.getString("TaskSelectType.Label.MultipleYAxis"));
                TaskSelectType.this.cbMultipleY = new Combo(parent, 12);
                TaskSelectType.this.cbMultipleY.setItems(new String[]{Messages.getString("TaskSelectType.Selection.None"), Messages.getString("TaskSelectType.Selection.SecondaryAxis"), Messages.getString("TaskSelectType.Selection.MoreAxes")});
                gd = new GridData(768);
                TaskSelectType.this.cbMultipleY.setLayoutData((Object)gd);
                TaskSelectType.this.cbMultipleY.addSelectionListener((SelectionListener)TaskSelectType.this);
                int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)TaskSelectType.this.chartModel);
                TaskSelectType.this.selectMultipleAxis(axisNum);
            }
        });
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(){

            public int getIndex() {
                return 40;
            }

            public void createControl(Composite parent) {
                TaskSelectType.this.lblSeriesType = new Label(parent, 64);
                GridData gd = new GridData(768);
                gd.horizontalIndent = 10;
                TaskSelectType.this.lblSeriesType.setLayoutData((Object)gd);
                TaskSelectType.this.lblSeriesType.setText(Messages.getString("TaskSelectType.Label.SeriesType"));
                TaskSelectType.this.lblSeriesType.setEnabled(false);
                TaskSelectType.this.cbSeriesType = new Combo(parent, 12);
                gd = new GridData(768);
                TaskSelectType.this.cbSeriesType.setLayoutData((Object)gd);
                TaskSelectType.this.cbSeriesType.setEnabled(false);
                TaskSelectType.this.cbSeriesType.addSelectionListener((SelectionListener)TaskSelectType.this);
            }
        });
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(){

            public int getIndex() {
                return 50;
            }

            public void createControl(Composite parent) {
                TaskSelectType.this.lblOrientation = new Label(parent, 64);
                GridData gd = new GridData(768);
                TaskSelectType.this.lblOrientation.setLayoutData((Object)gd);
                TaskSelectType.this.lblOrientation.setText(Messages.getString("TaskSelectType.Label.Oritention"));
                TaskSelectType.this.cbOrientation = new Button(parent, 32);
                TaskSelectType.this.cbOrientation.setText(Messages.getString("TaskSelectType.Label.FlipAxis"));
                gd = new GridData();
                TaskSelectType.this.cbOrientation.setLayoutData((Object)gd);
                TaskSelectType.this.cbOrientation.addSelectionListener((SelectionListener)TaskSelectType.this);
                if (TaskSelectType.this.orientation == Orientation.HORIZONTAL_LITERAL) {
                    TaskSelectType.this.cbOrientation.setSelection(true);
                } else {
                    TaskSelectType.this.cbOrientation.setSelection(false);
                }
            }
        });
        this.addOptionalUIDescriptor();
        this.createUIDescriptors(this.cmpMisc);
    }

    private void createTypeTable() {
        this.cmpLeft = new Composite(this.cmpType, 0);
        this.cmpLeft.setLayout((Layout)new GridLayout());
        this.cmpLeft.setLayoutData((Object)new GridData(1808));
        Label lblTypes = new Label(this.cmpLeft, 64);
        GridData gd = new GridData(768);
        lblTypes.setLayoutData((Object)gd);
        lblTypes.setText(Messages.getString("TaskSelectType.Label.SelectChartType"));
        this.table = new Table(this.cmpLeft, 2048);
        gd = new GridData(1808);
        this.table.setLayoutData((Object)gd);
        this.table.setToolTipText(Messages.getString("TaskSelectType.Label.ChartTypes"));
        this.table.addSelectionListener((SelectionListener)this);
    }

    private void addChartTypes() {
        ChartUIUtil.populateTypeTable((IWizardContext)this.getContext());
        Iterator iter = ChartUIUtil.getChartTypeNameIterator();
        while (iter.hasNext()) {
            String sTypeTmp = (String)iter.next();
            TableItem tItem = new TableItem(this.table, 0);
            tItem.setText(LEADING_BLANKS + ChartUIUtil.getChartType((String)sTypeTmp).getDisplayName());
            tItem.setData((Object)ChartUIUtil.getChartType((String)sTypeTmp).getName());
            tItem.setImage(ChartUIUtil.getChartType((String)sTypeTmp).getImage());
        }
    }

    protected Chart getChartModel() {
        return this.chartModel;
    }

    private void createComposite(Vector<IChartSubType> vSubTypes) {
        Label lblSubtypes = new Label(this.cmpRight, 524288);
        lblSubtypes.setText(Messages.getString("TaskSelectType.Label.SelectSubtype"));
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        lblSubtypes.setLayoutData((Object)gd);
        GridData gdTypes = new GridData(784);
        this.cmpSubTypes = new Composite(this.cmpRight, 0);
        this.createGroups(vSubTypes);
        this.cmpSubTypes.setLayoutData((Object)gdTypes);
        this.cmpSubTypes.setToolTipText(Messages.getString("TaskSelectType.Label.ChartSubtypes"));
        this.cmpSubTypes.setLayout((Layout)new GridLayout());
        this.cmpSubTypes.setVisible(true);
    }

    private void createGroups(Vector<IChartSubType> vSubTypes) {
        this.vSubTypeNames = new Vector();
        if (this.cmpTypeButtons != null && !this.cmpTypeButtons.isDisposed()) {
            this.cmpTypeButtons.dispose();
        }
        this.cmpTypeButtons = new Composite(this.cmpSubTypes, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 12;
        rowLayout.marginRight = 12;
        rowLayout.spacing = 4;
        this.cmpTypeButtons.setLayout((Layout)rowLayout);
        int iC = 0;
        while (iC < vSubTypes.size()) {
            IChartSubType subType = vSubTypes.get(iC);
            this.vSubTypeNames.add(subType.getName());
            Button btnType = new Button(this.cmpTypeButtons, 2);
            btnType.setData((Object)subType.getName());
            btnType.setImage(subType.getImage());
            btnType.setLayoutData((Object)this.rowData);
            btnType.addSelectionListener((SelectionListener)this);
            btnType.setToolTipText(subType.getDescription());
            btnType.getImage().setBackground(btnType.getBackground());
            btnType.setVisible(true);
            this.cmpTypeButtons.layout(true);
            if (this.getDataServiceProvider().checkState(32)) break;
            ++iC;
        }
        this.cmpTypeButtons.setLayoutData((Object)new GridData(1808));
        this.cmpSubTypes.layout(true);
    }

    private void populateSeriesTypes(Collection<IChartType> allChartType, Series series, Orientation orientation) {
        for (IChartType type : allChartType) {
            Series newSeries = type.getSeries();
            if (htSeriesNames == null) {
                htSeriesNames = new Hashtable(20);
            }
            if (!type.canCombine() || IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE.equals(this.sDimension) && newSeries instanceof AreaSeries) continue;
            if (!(newSeries instanceof StockSeries) || orientation.getValue() == 1) {
                String sDisplayName = newSeries.getDisplayName();
                htSeriesNames.put(sDisplayName, newSeries);
                this.cbSeriesType.add(sDisplayName);
            }
            if (!type.getName().equals(this.chartModel.getType())) continue;
            this.cbSeriesType.select(this.cbSeriesType.getItemCount() - 1);
        }
    }

    private String translateDimensionString(String sDimensionValue) {
        String dimensionName = "";
        if (sDimensionValue.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            dimensionName = IChartType.TWO_DIMENSION_TYPE;
        } else if (sDimensionValue.equals(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL.getName())) {
            dimensionName = IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE;
        } else if (sDimensionValue.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            dimensionName = IChartType.THREE_DIMENSION_TYPE;
        }
        return dimensionName;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        boolean needUpdateModel = false;
        Object oSelected = e.getSource();
        if (oSelected.getClass().equals(Button.class)) {
            needUpdateModel = true;
            if (oSelected.equals(this.cbOrientation)) {
                this.orientation = this.cbOrientation.getSelection() ? Orientation.HORIZONTAL_LITERAL : Orientation.VERTICAL_LITERAL;
                this.createAndDisplayTypesSheet(this.sType);
                this.setDefaultSubtypeSelection();
                this.populateSeriesTypesList();
                ChartCacheManager.getInstance().cacheOrientation(this.sType, this.orientation);
            } else {
                Button btn = (Button)e.getSource();
                if (btn.getSelection()) {
                    int iTypeIndex;
                    if (this.sSubType != null && !this.getSubtypeFromButton((Control)btn).equals(this.sSubType) && (iTypeIndex = this.vSubTypeNames.indexOf(this.sSubType)) >= 0) {
                        ((Button)this.cmpTypeButtons.getChildren()[iTypeIndex]).setSelection(false);
                        this.cmpTypeButtons.redraw();
                    }
                    ChartUIUtil.saveLabelPositionIntoCache((SeriesDefinition)this.getSeriesDefinitionForProcessing());
                    this.sSubType = this.getSubtypeFromButton((Control)btn);
                    ChartCacheManager.getInstance().cacheSubtype(this.sType, this.sSubType);
                } else if (this.sSubType != null && this.getSubtypeFromButton((Control)btn).equals(this.sSubType)) {
                    btn.setSelection(true);
                }
            }
        } else if (oSelected.getClass().equals(Table.class)) {
            this.sType = ((String)((TableItem)e.item).getData()).trim();
            if (!this.sOldType.equals(this.sType)) {
                this.sOldType = this.sType;
                if (!this.getDataServiceProvider().checkState(32) && this.chartModel != null && this.chartModel instanceof ChartWithAxes) {
                    Orientation lastOrientation = ChartCacheManager.getInstance().findOrientation(this.sType);
                    if (lastOrientation != null && this.orientation != lastOrientation) {
                        this.orientation = lastOrientation;
                        this.rotateAxisTitle((ChartWithAxes)this.chartModel);
                    }
                    if (lastOrientation == null) {
                        Orientation currentOrientation = this.orientation;
                        this.orientation = ChartUIUtil.getChartType((String)this.sType).getDefaultOrientation();
                        if (currentOrientation != this.orientation) {
                            this.rotateAxisTitle((ChartWithAxes)this.chartModel);
                        }
                    }
                }
                if (this.chartModel != null && this.chartModel instanceof ChartWithAxes && ChartCacheManager.getInstance().findCategory(this.sType) != null) {
                    boolean bCategory = ChartCacheManager.getInstance().findCategory(this.sType);
                    ((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).setCategoryAxis(bCategory);
                }
                this.sSubType = null;
                this.createAndDisplayTypesSheet(this.sType);
                this.setDefaultSubtypeSelection();
                this.cmpMisc.layout();
                needUpdateModel = true;
            }
        } else if (oSelected.equals(this.cbMultipleY)) {
            needUpdateModel = true;
            this.lblSeriesType.setEnabled(this.isTwoAxesEnabled());
            Axis xAxis = (Axis)((ChartWithAxes)this.chartModel).getAxes().get(0);
            ((ChartWizardContext)this.getContext()).setMoreAxesSupported(this.cbMultipleY.getSelectionIndex() == 2);
            if (this.chartModel instanceof ChartWithoutAxes) {
                throw new IllegalArgumentException(Messages.getString("TaskSelectType.Exception.CannotSupportAxes"));
            }
            ChartAdapter.beginIgnoreNotifications();
            int iAxisNumber = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel);
            if (this.cbMultipleY.getSelectionIndex() == 0) {
                ChartCacheManager.getInstance().cacheSeriesType(null);
                if (iAxisNumber > 1) {
                    ChartUIUtil.removeLastAxes((ChartWithAxes)((ChartWithAxes)this.chartModel), (int)(iAxisNumber - 1));
                }
            } else if (this.cbMultipleY.getSelectionIndex() == 1) {
                if (iAxisNumber == 1) {
                    ChartUIUtil.addAxis((ChartWithAxes)((ChartWithAxes)this.chartModel));
                } else if (iAxisNumber > 2) {
                    ChartUIUtil.removeLastAxes((ChartWithAxes)((ChartWithAxes)this.chartModel), (int)(iAxisNumber - 2));
                }
            }
            ChartAdapter.endIgnoreNotifications();
            if (xAxis.getAssociatedAxes().size() > 1) {
                String lastSeriesType = ChartCacheManager.getInstance().findSeriesType();
                if (lastSeriesType != null) {
                    this.cbSeriesType.setText(lastSeriesType);
                } else {
                    Axis overlayAxis = (Axis)xAxis.getAssociatedAxes().get(1);
                    String sDisplayName = ((SeriesDefinition)overlayAxis.getSeriesDefinitions().get(0)).getDesignTimeSeries().getDisplayName();
                    this.cbSeriesType.setText(sDisplayName);
                }
                this.changeOverlaySeriesType();
            }
            this.cbSeriesType.setEnabled(this.isTwoAxesEnabled());
            if (this.updateDimensionCombo(this.sType)) {
                this.createAndDisplayTypesSheet(this.sType);
                this.setDefaultSubtypeSelection();
            }
            this.cmpMisc.layout();
        } else if (oSelected.equals(this.cbDimension)) {
            String newDimension = this.cbDimension.getItem(this.cbDimension.getSelectionIndex());
            if (!newDimension.equals(this.sDimension)) {
                this.sDimension = newDimension;
                ChartCacheManager.getInstance().cacheDimension(this.sType, this.sDimension);
                this.createAndDisplayTypesSheet(this.sType);
                this.setDefaultSubtypeSelection();
                this.populateSeriesTypesList();
                needUpdateModel = true;
            }
        } else if (oSelected.equals(this.cbSeriesType)) {
            needUpdateModel = true;
            this.changeOverlaySeriesType();
            this.updateDimensionCombo(this.sType);
        }
        if (needUpdateModel) {
            ChartAdapter.notifyUpdateApply();
            this.refreshChart();
            if (oSelected.getClass().equals(Table.class)) {
                this.populateSeriesTypesList();
            } else if (oSelected.equals(this.cbOrientation) && this.chartModel instanceof ChartWithAxes) {
                this.rotateAxisTitle((ChartWithAxes)this.chartModel);
            }
            this.doPreview();
        }
    }

    private boolean isAreaSeriesMixed() {
        boolean hasAreaSeries = false;
        boolean hasNonAreaSeries = false;
        for (SeriesDefinition sd : ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.chartModel)) {
            if (sd.getDesignTimeSeries() instanceof AreaSeries) {
                hasAreaSeries = true;
            } else {
                hasNonAreaSeries = true;
            }
            if (!hasAreaSeries || !hasNonAreaSeries) continue;
            return true;
        }
        return false;
    }

    private boolean updateDimensionCombo(String sSelectedType) {
        boolean isOldExist = false;
        IChartType chartType = ChartUIUtil.getChartType((String)sSelectedType);
        String[] dimensionArray = chartType.getSupportedDimensions();
        int axesNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel);
        if (this.sDimension == null) {
            this.sDimension = chartType.getDefaultDimension();
            isOldExist = true;
        }
        this.cbDimension.removeAll();
        boolean bAreaSeriesMixed = this.isAreaSeriesMixed();
        int i = 0;
        while (i < dimensionArray.length) {
            block9: {
                boolean isSupported;
                block8: {
                    isSupported = chartType.isDimensionSupported(dimensionArray[i], (ChartWizardContext)this.context, axesNum, 0);
                    if (!isSupported) break block8;
                    if (bAreaSeriesMixed && dimensionArray[i].equals(IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE)) break block9;
                    this.cbDimension.add(dimensionArray[i]);
                }
                if (!isOldExist && this.sDimension.equals(dimensionArray[i])) {
                    isOldExist = isSupported;
                }
            }
            ++i;
        }
        String cache = ChartCacheManager.getInstance().getDimension(sSelectedType);
        if (cache != null) {
            this.sDimension = cache;
            isOldExist = true;
        }
        if (!isOldExist) {
            this.sDimension = chartType.getDefaultDimension();
        }
        this.cbDimension.setText(this.sDimension);
        return !isOldExist;
    }

    private boolean isTwoAxesEnabled() {
        return this.cbMultipleY.getSelectionIndex() == 1;
    }

    protected EObject getChartModelObject() {
        return ((ChartWizardContext)this.context).getModel();
    }

    private void updateAdapters() {
        EObject model = this.getChartModelObject();
        if (this.container instanceof ChartWizard) {
            EContentAdapter adapter = ((ChartWizard)this.container).getAdapter();
            model.eAdapters().remove((Object)adapter);
            TreeIterator iterator = model.eAllContents();
            while (iterator.hasNext()) {
                EObject oModel = (EObject)iterator.next();
                oModel.eAdapters().remove((Object)adapter);
            }
            model.eAdapters().add((Object)adapter);
        } else {
            EList adapters = model.eAdapters();
            if (adapters.isEmpty()) {
                if (this.adapter == null) {
                    this.adapter = new ChartAdapter(this.container);
                    this.adapter.addListener((ITaskChangeListener)this);
                }
                adapters.add((Object)this.adapter);
            } else if (adapters.get(0) instanceof ChartAdapter) {
                ((ChartAdapter)adapters.get(0)).addListener((ITaskChangeListener)this);
            }
        }
    }

    private boolean is3D() {
        return IChartType.THREE_DIMENSION_TYPE.equals(this.sDimension);
    }

    private boolean isMultiAxisSupported() {
        boolean bOutXtab;
        boolean bl = bOutXtab = !this.getDataServiceProvider().checkState(32);
        return bOutXtab && !this.is3D() && (!IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE.equals(this.sDimension) || !"Area Chart".equals(this.sType));
    }

    private void changeOverlaySeriesType() {
        if (this.getCurrentChartType().canCombine()) {
            ChartCacheManager.getInstance().cacheSeriesType(this.cbSeriesType.getText());
        }
        try {
            try {
                Axis XAxis = (Axis)((ChartWithAxes)this.chartModel).getAxes().get(0);
                int iSeriesDefinitionIndex = ((Axis)XAxis.getAssociatedAxes().get(0)).getSeriesDefinitions().size();
                int iOverlaySeriesCount = ((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().size();
                ChartAdapter.beginIgnoreNotifications();
                int i = 0;
                while (i < iOverlaySeriesCount) {
                    Series lastSeries = ((SeriesDefinition)((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().get(i)).getDesignTimeSeries();
                    if (!lastSeries.getDisplayName().equals(this.cbSeriesType.getText())) {
                        String name = htSeriesNames.get(this.cbSeriesType.getText()).getClass().getName();
                        Series newSeries = ChartCacheManager.getInstance().findSeries(name, iSeriesDefinitionIndex + i);
                        if (newSeries == null || newSeries instanceof BarSeries) {
                            newSeries = htSeriesNames.get(this.cbSeriesType.getText()).copyInstance();
                            newSeries.translateFrom(lastSeries, iSeriesDefinitionIndex, this.chartModel);
                        }
                        newSeries.eAdapters().addAll((Collection)this.chartModel.eAdapters());
                        ((SeriesDefinition)((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().get(i)).getSeries().clear();
                        ((SeriesDefinition)((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().get(i)).getSeries().add((Object)newSeries);
                        ChartUIUtil.setSeriesName((Chart)this.chartModel);
                    }
                    ++i;
                }
                ChartWizard.removeException((String)"TaskSelectType.changeOverlaySeriesType");
            }
            catch (Exception e) {
                ChartWizard.showException((String)"TaskSelectType.changeOverlaySeriesType", (String)e.getLocalizedMessage());
                ChartAdapter.endIgnoreNotifications();
            }
        }
        finally {
            ChartAdapter.endIgnoreNotifications();
        }
    }

    private void populateSeriesTypesList() {
        Axis xAxis;
        if (this.cbSeriesType == null) {
            return;
        }
        this.cbSeriesType.removeAll();
        Series series = this.getSeriesDefinitionForProcessing().getDesignTimeSeries();
        if (this.getCurrentChartType().canCombine()) {
            this.populateSeriesTypes(ChartUIExtensionsImpl.instance().getUIChartTypeExtensions(this.getContext().getClass().getSimpleName()), series, this.orientation);
        } else {
            String seriesName = series.getDisplayName();
            this.cbSeriesType.add(seriesName);
            this.cbSeriesType.select(0);
        }
        if (this.chartModel instanceof ChartWithAxes && (xAxis = (Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).getAssociatedAxes().size() > 1) {
            String lastType = ChartCacheManager.getInstance().findSeriesType();
            Axis overlayAxis = (Axis)xAxis.getAssociatedAxes().get(1);
            if (!overlayAxis.getSeriesDefinitions().isEmpty()) {
                Series oseries = ((SeriesDefinition)overlayAxis.getSeriesDefinitions().get(0)).getDesignTimeSeries();
                String sDisplayName = oseries.getDisplayName();
                if (lastType != null) {
                    this.cbSeriesType.setText(lastType);
                } else {
                    this.cbSeriesType.setText(sDisplayName);
                }
                String seriesName = oseries.getSeriesIdentifier().toString();
                if (seriesName.trim().length() != 0) {
                    for (Map.Entry<String, Series> entry : htSeriesNames.entrySet()) {
                        entry.getValue().setSeriesIdentifier((Object)seriesName);
                    }
                }
            }
            this.changeOverlaySeriesType();
        }
    }

    private void createAndDisplayTypesSheet(String sSelectedType) {
        Vector<IChartSubType> vSubTypes;
        IChartType chartType = ChartUIUtil.getChartType((String)sSelectedType);
        if (this.cbOrientation != null) {
            this.lblOrientation.setEnabled(chartType.supportsTransposition() && !this.is3D());
            this.cbOrientation.setEnabled(chartType.supportsTransposition() && !this.is3D());
        }
        this.updateDimensionCombo(sSelectedType);
        if (this.sDimension == null) {
            this.sDimension = chartType.getDefaultDimension();
        }
        if (this.orientation == null) {
            this.orientation = chartType.getDefaultOrientation();
        }
        if ((vSubTypes = new Vector<IChartSubType>(chartType.getChartSubtypes(this.sDimension, this.orientation))).size() == 0) {
            vSubTypes = new Vector(chartType.getChartSubtypes(chartType.getDefaultDimension(), chartType.getDefaultOrientation()));
            this.sDimension = chartType.getDefaultDimension();
            this.orientation = chartType.getDefaultOrientation();
        }
        if (this.cbOrientation == null || !this.cbOrientation.isEnabled()) {
            this.orientation = chartType.getDefaultOrientation();
        }
        ChartCacheManager.getInstance().cacheOrientation(this.sType, this.orientation);
        if (this.chartModel == null) {
            ChartCacheManager.getInstance().cacheCategory(this.sType, true);
        } else if (this.chartModel instanceof ChartWithAxes) {
            ChartCacheManager.getInstance().cacheCategory(this.sType, ((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).isCategoryAxis());
        }
        this.createGroups(vSubTypes);
        if (this.cbOrientation != null) {
            if (this.orientation == Orientation.HORIZONTAL_LITERAL) {
                this.cbOrientation.setSelection(true);
            } else {
                this.cbOrientation.setSelection(false);
            }
        }
        this.cmpRight.layout();
    }

    private void setDefaultSubtypeSelection() {
        if (this.sSubType == null) {
            this.sSubType = ChartCacheManager.getInstance().findSubtype(this.sType);
        }
        if (this.sSubType == null) {
            ((Button)this.cmpTypeButtons.getChildren()[0]).setSelection(true);
            this.sSubType = this.getSubtypeFromButton(this.cmpTypeButtons.getChildren()[0]);
            ChartCacheManager.getInstance().cacheSubtype(this.sType, this.sSubType);
        } else {
            Control[] buttons = this.cmpTypeButtons.getChildren();
            boolean bSelected = false;
            int iB = 0;
            while (iB < buttons.length) {
                if (this.getSubtypeFromButton(buttons[iB]).equals(this.sSubType)) {
                    ((Button)buttons[iB]).setSelection(true);
                    bSelected = true;
                    break;
                }
                ++iB;
            }
            if (!bSelected) {
                ((Button)this.cmpTypeButtons.getChildren()[0]).setSelection(true);
                this.sSubType = this.getSubtypeFromButton(this.cmpTypeButtons.getChildren()[0]);
                ChartCacheManager.getInstance().cacheSubtype(this.sType, this.sSubType);
            }
        }
        this.cmpTypeButtons.redraw();
    }

    private void setDefaultTypeSelection() {
        if (this.table.getItems().length > 0) {
            if (this.sType == null) {
                this.table.select(0);
                this.sType = (String)this.table.getSelection()[0].getData();
            } else {
                TableItem[] tiAll = this.table.getItems();
                int iTI = 0;
                while (iTI < tiAll.length) {
                    if (tiAll[iTI].getData().equals(this.sType)) {
                        this.table.select(iTI);
                        break;
                    }
                    ++iTI;
                }
            }
            this.sOldType = this.sType;
            this.createAndDisplayTypesSheet(this.sType);
            this.setDefaultSubtypeSelection();
        }
    }

    public void dispose() {
        super.dispose();
        this.lstDescriptor.clear();
        this.chartModel = null;
        this.adapter = null;
        if (this.previewPainter != null) {
            this.previewPainter.dispose();
        }
        this.previewPainter = null;
        this.sSubType = null;
        this.sType = null;
        this.sDimension = null;
        this.vSubTypeNames = null;
        this.orientation = null;
    }

    private void refreshChart() {
        ChartAdapter.beginIgnoreNotifications();
        IChartType chartType = ChartUIUtil.getChartType((String)this.sType);
        try {
            this.chartModel = chartType.getModel(this.sSubType, this.orientation, this.sDimension, this.chartModel);
            if (this.getDataServiceProvider().checkState(32)) {
                ChartWithAxes cwa = (ChartWithAxes)this.chartModel;
                ((Axis)cwa.getAxes().get(0)).setCategoryAxis(true);
                if (cwa.isTransposed()) {
                    cwa.setReverseCategory(true);
                }
            }
            ((ChartWizardContext)this.context).setModel(this.chartModel);
            ((ChartWizardContext)this.context).setChartType(chartType);
            this.updateAdapters();
            ChartWizard.removeException((String)"TaskSelectType.refreshChart");
        }
        catch (Exception e) {
            ChartWizard.showException((String)"TaskSelectType.refreshChart", (String)e.getLocalizedMessage());
        }
        ChartAdapter.endIgnoreNotifications();
        this.updateSelection();
        ((ChartWizardContext)this.context).setModel(this.chartModel);
        ((ChartWizardContext)this.context).setChartType(chartType);
        this.setContext(this.context);
    }

    private SeriesDefinition getSeriesDefinitionForProcessing() {
        SeriesDefinition sd = null;
        if (this.chartModel instanceof ChartWithAxes) {
            sd = (SeriesDefinition)((Axis)((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().get(0);
        } else if (this.chartModel instanceof ChartWithoutAxes) {
            sd = (SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.chartModel).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(0);
        }
        return sd;
    }

    protected void updateSelection() {
        boolean bOutXtab;
        boolean bl = bOutXtab = !this.getDataServiceProvider().checkState(32);
        if (this.chartModel instanceof ChartWithAxes) {
            if (this.cbMultipleY != null) {
                this.lblMultipleY.setEnabled(this.isMultiAxisSupported());
                this.cbMultipleY.setEnabled(this.isMultiAxisSupported());
            }
            if (this.cbSeriesType != null) {
                this.lblSeriesType.setEnabled(bOutXtab && this.isTwoAxesEnabled());
                this.cbSeriesType.setEnabled(bOutXtab && this.isTwoAxesEnabled());
            }
        } else {
            if (this.cbMultipleY != null) {
                this.cbMultipleY.select(0);
                ((ChartWizardContext)this.getContext()).setMoreAxesSupported(false);
                this.lblMultipleY.setEnabled(false);
                this.cbMultipleY.setEnabled(false);
            }
            if (this.cbSeriesType != null) {
                this.lblSeriesType.setEnabled(false);
                this.cbSeriesType.setEnabled(false);
            }
        }
        if (this.cbOrientation != null) {
            this.lblOrientation.setEnabled(bOutXtab && this.lblOrientation.isEnabled());
            this.cbOrientation.setEnabled(bOutXtab && this.cbOrientation.isEnabled());
        }
    }

    public IWizardContext getContext() {
        ChartWizardContext context = (ChartWizardContext)super.getContext();
        context.setModel(this.chartModel);
        return context;
    }

    public void setContext(IWizardContext context) {
        super.setContext(context);
        this.chartModel = ((ChartWizardContext)context).getModel();
        if (this.chartModel != null) {
            this.sType = ((ChartWizardContext)context).getChartType().getName();
            this.sSubType = this.chartModel.getSubType();
            this.sDimension = this.translateDimensionString(this.chartModel.getDimension().getName());
            if (this.chartModel instanceof ChartWithAxes) {
                this.orientation = ((ChartWithAxes)this.chartModel).getOrientation();
                int iYAxesCount = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel);
                if (iYAxesCount > 1 && this.lblMultipleY != null && !this.lblMultipleY.isDisposed()) {
                    this.lblMultipleY.setEnabled(!this.is3D());
                    this.cbMultipleY.setEnabled(!this.is3D());
                    this.lblSeriesType.setEnabled(!this.is3D() && this.isTwoAxesEnabled());
                    this.cbSeriesType.setEnabled(!this.is3D() && this.isTwoAxesEnabled());
                    this.selectMultipleAxis(iYAxesCount);
                }
            }
        }
    }

    private void selectMultipleAxis(int yAxisNum) {
        if (((ChartWizardContext)this.getContext()).isMoreAxesSupported()) {
            this.cbMultipleY.select(2);
        } else if (yAxisNum > 2) {
            this.cbMultipleY.select(2);
            ((ChartWizardContext)this.getContext()).setMoreAxesSupported(true);
        } else {
            this.cbMultipleY.select(yAxisNum > 0 ? yAxisNum - 1 : 0);
        }
    }

    public void changeTask(Notification notification) {
        if (this.previewPainter != null) {
            this.doPreview();
        }
    }

    private void checkDataTypeForChartWithAxes() {
        Series series;
        SeriesDefinition sd;
        ArrayList sdList = new ArrayList();
        sdList.addAll(ChartUIUtil.getBaseSeriesDefinitions((Chart)this.getChartModel()));
        int i = 0;
        while (i < sdList.size()) {
            sd = (SeriesDefinition)sdList.get(i);
            series = sd.getDesignTimeSeries();
            this.checkDataTypeForBaseSeries(ChartUIUtil.getDataQuery((SeriesDefinition)sd, (int)0), series);
            ++i;
        }
        sdList.clear();
        sdList.addAll(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.getChartModel()));
        i = 0;
        while (i < sdList.size()) {
            sd = (SeriesDefinition)sdList.get(i);
            series = sd.getDesignTimeSeries();
            this.checkDataTypeForOrthoSeries(ChartUIUtil.getDataQuery((SeriesDefinition)sd, (int)0), series);
            ++i;
        }
    }

    protected IDataServiceProvider getDataServiceProvider() {
        return ((ChartWizardContext)this.getContext()).getDataServiceProvider();
    }

    private String getSubtypeFromButton(Control button) {
        return (String)button.getData();
    }

    private void checkDataTypeForBaseSeries(Query query, Series series) {
        this.checkDataTypeImpl(query, series, true);
    }

    private void checkDataTypeForOrthoSeries(Query query, Series series) {
        this.checkDataTypeImpl(query, series, false);
    }

    private void checkDataTypeImpl(Query query, Series series, boolean isBaseSeries) {
        String expression = query.getDefinition();
        Axis axis = null;
        Query o = query;
        while (o != null) {
            if (!((o = o.eContainer()) instanceof Axis)) continue;
            axis = (Axis)o;
            break;
        }
        Collection cRegisteredEntries = ChartUIExtensionsImpl.instance().getSeriesUIComponents(this.getContext().getClass().getSimpleName());
        Iterator iterEntries = cRegisteredEntries.iterator();
        String sSeries = null;
        while (iterEntries.hasNext()) {
            ISeriesUIProvider provider = (ISeriesUIProvider)iterEntries.next();
            sSeries = provider.getSeriesClass();
            if (!sSeries.equals(series.getClass().getName())) continue;
            if (this.chartModel instanceof ChartWithAxes) {
                DataType dataType = this.getDataServiceProvider().getDataType(expression);
                SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.chartModel).get(0);
                SeriesDefinition orthSD = null;
                orthSD = (SeriesDefinition)series.eContainer();
                String aggFunc = null;
                try {
                    aggFunc = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)query);
                    ChartWizard.removeException((String)"PluginSettings.getAggregateFunc");
                }
                catch (ChartException e) {
                    ChartWizard.showException((String)"PluginSettings.getAggregateFunc", (String)e.getLocalizedMessage());
                }
                if (baseSD != null && !isBaseSeries && baseSD != orthSD && ChartUtil.isMagicAggregate((String)aggFunc)) {
                    dataType = DataType.NUMERIC_LITERAL;
                }
                if (this.isValidatedAxis(dataType, axis.getType())) {
                    ChartWizard.removeException((String)("CheckSeriesBindingType_" + series.eContainer().hashCode()));
                    break;
                }
                AxisType[] axisTypes = provider.getCompatibleAxisType(series);
                int i = 0;
                while (i < axisTypes.length) {
                    if (this.isValidatedAxis(dataType, axisTypes[i])) {
                        this.axisNotification(axis, axisTypes[i]);
                        ChartAdapter.beginIgnoreNotifications();
                        axis.setType(axisTypes[i]);
                        ChartAdapter.endIgnoreNotifications();
                        break;
                    }
                    ++i;
                }
            }
            try {
                provider.validateSeriesBindingType(series, this.getDataServiceProvider());
                ChartWizard.removeException((String)("CheckSeriesBindingType_" + series.eContainer().hashCode()));
            }
            catch (ChartException ce) {
                ChartWizard.showException((String)("CheckSeriesBindingType_" + series.eContainer().hashCode()), (String)Messages.getFormattedString("TaskSelectData.Warning.TypeCheck", new String[]{ce.getLocalizedMessage(), series.getDisplayName()}));
            }
            break;
        }
    }

    private boolean isValidatedAxis(DataType dataType, AxisType axisType) {
        if (dataType == null) {
            return true;
        }
        if (dataType == DataType.DATE_TIME_LITERAL && axisType == AxisType.DATE_TIME_LITERAL) {
            return true;
        }
        if (dataType == DataType.NUMERIC_LITERAL && (axisType == AxisType.LINEAR_LITERAL || axisType == AxisType.LOGARITHMIC_LITERAL)) {
            return true;
        }
        return dataType == DataType.TEXT_LITERAL && axisType == AxisType.TEXT_LITERAL;
    }

    private void axisNotification(Axis axis, AxisType type) {
        ChartAdapter.beginIgnoreNotifications();
        this.convertSampleData(axis, type);
        axis.setFormatSpecifier(null);
        EList markerLines = axis.getMarkerLines();
        int i = 0;
        while (i < markerLines.size()) {
            ((MarkerLine)markerLines.get(i)).setFormatSpecifier(null);
            ++i;
        }
        EList markerRanges = axis.getMarkerRanges();
        int i2 = 0;
        while (i2 < markerRanges.size()) {
            ((MarkerRange)markerRanges.get(i2)).setFormatSpecifier(null);
            ++i2;
        }
        ChartAdapter.endIgnoreNotifications();
    }

    private void convertSampleData(Axis axis, AxisType axisType) {
        if (axis.getAssociatedAxes() != null && axis.getAssociatedAxes().size() != 0) {
            BaseSampleData bsd = (BaseSampleData)this.chartModel.getSampleData().getBaseSampleData().get(0);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation(), (int)0));
        } else {
            int iStartIndex = this.getFirstSeriesDefinitionIndexForAxis(axis);
            int iEndIndex = iStartIndex + axis.getSeriesDefinitions().size();
            int iOSDSize = this.chartModel.getSampleData().getOrthogonalSampleData().size();
            int i = 0;
            while (i < iOSDSize) {
                OrthogonalSampleData osd = (OrthogonalSampleData)this.chartModel.getSampleData().getOrthogonalSampleData().get(i);
                if (osd.getSeriesDefinitionIndex() >= iStartIndex && osd.getSeriesDefinitionIndex() < iEndIndex) {
                    osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)osd.getDataSetRepresentation(), (int)i));
                }
                ++i;
            }
        }
    }

    private int getFirstSeriesDefinitionIndexForAxis(Axis axis) {
        EList axisList = ((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).getAssociatedAxes();
        int index = 0;
        int i = 0;
        while (i < axisList.size()) {
            if (axis.equals(axisList.get(i))) {
                index = i;
                break;
            }
            ++i;
        }
        int iTmp = 0;
        int i2 = 0;
        while (i2 < index) {
            iTmp += ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.chartModel), (int)i2).getSeriesDefinitions().size();
            ++i2;
        }
        return iTmp;
    }

    public Image getImage() {
        return UIHelper.getImage((String)"icons/obj16/selecttype.gif");
    }

    private void rotateAxisTitle(ChartWithAxes cwa) {
        boolean bRender = false;
        ChartAdapter.beginIgnoreNotifications();
        Axis aX = ChartUIUtil.getAxisXForProcessing((ChartWithAxes)cwa);
        if (aX.getTitle().isVisible()) {
            bRender = true;
        }
        double curRotation = aX.getTitle().getCaption().getFont().getRotation();
        aX.getTitle().getCaption().getFont().setRotation(curRotation >= 0.0 ? 90.0 - curRotation : -90.0 - curRotation);
        EList aYs = aX.getAssociatedAxes();
        int i = 0;
        while (i < aYs.size()) {
            Axis aY = (Axis)aYs.get(i);
            if (aY.getTitle().isVisible()) {
                bRender = true;
            }
            curRotation = aY.getTitle().getCaption().getFont().getRotation();
            aY.getTitle().getCaption().getFont().setRotation(curRotation >= 0.0 ? 90.0 - curRotation : -90.0 - curRotation);
            ++i;
        }
        ChartAdapter.endIgnoreNotifications();
        if (bRender) {
            this.doPreview();
        }
    }

    public IChartPreviewPainter createPreviewPainter() {
        ChartPreviewPainter painter = new ChartPreviewPainter((ChartWizardContext)this.getContext());
        this.getPreviewCanvas().addPaintListener((PaintListener)painter);
        this.getPreviewCanvas().addControlListener((ControlListener)painter);
        painter.setPreview(this.getPreviewCanvas());
        return painter;
    }

    public void doPreview() {
        LivePreviewTask lpt = new LivePreviewTask(Messages.getString("TaskFormatChart.LivePreviewTask.BindData"), null);
        lpt.addTask(new LivePreviewTask(){

            public void run() {
                if (TaskSelectType.this.previewPainter != null) {
                    this.setParameter("Chart Model", ChartUIUtil.prepareLivePreview((Chart)TaskSelectType.this.chartModel, (IDataServiceProvider)TaskSelectType.this.getDataServiceProvider(), (IActionEvaluator)((ChartWizardContext)TaskSelectType.this.context).getActionEvaluator()));
                }
            }
        });
        lpt.addTask(new LivePreviewTask(){

            public void run() {
                if (TaskSelectType.this.previewCanvas != null && TaskSelectType.this.previewCanvas.getDisplay() != null && !TaskSelectType.this.previewCanvas.getDisplay().isDisposed()) {
                    TaskSelectType.this.previewCanvas.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if ((this).TaskSelectType.this.previewPainter != null) {
                                Chart cm = (Chart)this.getParameter("Chart Model");
                                if (cm instanceof ChartWithAxes) {
                                    ChartAdapter.beginIgnoreNotifications();
                                    TaskSelectType.this.checkDataTypeForChartWithAxes();
                                    ChartAdapter.endIgnoreNotifications();
                                } else {
                                    ChartWizard.removeAllExceptions((String)"CheckSeriesBindingType_");
                                }
                                (this).TaskSelectType.this.previewPainter.renderModel((IChartObject)cm);
                            }
                        }
                    });
                }
            }
        });
        ((ChartLivePreviewThread)((ChartWizardContext)this.context).getLivePreviewThread()).setParentShell(this.getPreviewCanvas().getShell());
        ((ChartLivePreviewThread)((ChartWizardContext)this.context).getLivePreviewThread()).add(lpt);
    }

    public Canvas getPreviewCanvas() {
        return this.previewCanvas;
    }

    public boolean isPreviewable() {
        return true;
    }

    protected IChartType getCurrentChartType() {
        return ChartUIUtil.getChartType((String)this.sType);
    }

    private void createUIDescriptors(Composite parent) {
        for (TaskSelectTypeUIDescriptor descriptor : this.lstDescriptor) {
            if (!descriptor.isVisible()) continue;
            descriptor.createControl(parent);
        }
    }

    protected final void addTypeUIDescriptor(TaskSelectTypeUIDescriptor newDescriptor) {
        if (newDescriptor.getIndex() < 0) {
            this.lstDescriptor.add(newDescriptor);
            return;
        }
        int lastIndex = -1;
        int i = 0;
        while (i < this.lstDescriptor.size()) {
            TaskSelectTypeUIDescriptor descriptor = this.lstDescriptor.get(i);
            if (newDescriptor.getIndex() > lastIndex && newDescriptor.getIndex() <= descriptor.getIndex()) {
                this.lstDescriptor.add(i, newDescriptor);
                return;
            }
            lastIndex = descriptor.getIndex();
            ++i;
        }
        this.lstDescriptor.add(newDescriptor);
    }

    protected void addOptionalUIDescriptor() {
        this.addTypeUIDescriptor(new TaskSelectTypeUIDescriptor(){

            public int getIndex() {
                return 20;
            }

            public void createControl(Composite parent) {
                Label lblOutput = new Label(parent, 64);
                GridData gd = new GridData(768);
                gd.horizontalIndent = 10;
                lblOutput.setLayoutData((Object)gd);
                lblOutput.setText(Messages.getString("TaskSelectType.Label.OutputFormat"));
                final Combo cbOutput = new Combo(parent, 12);
                GridData gd2 = new GridData(768);
                cbOutput.setLayoutData((Object)gd2);
                cbOutput.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        String outputFormat = outputFormats[cbOutput.getSelectionIndex()];
                        ((ChartWizardContext)TaskSelectType.this.getContext()).setOutputFormat(outputFormat);
                        if (TaskSelectType.this.container != null && TaskSelectType.this.container instanceof ChartWizard) {
                            ((ChartWizard)TaskSelectType.this.container).updateApplyButton();
                        }
                    }
                });
                cbOutput.setItems(outputDisplayNames);
                String sCurrentFormat = ((ChartWizardContext)TaskSelectType.this.getContext()).getOutputFormat();
                int index = 0;
                while (index < outputFormats.length) {
                    if (outputFormats[index].equals(sCurrentFormat)) {
                        cbOutput.select(index);
                        break;
                    }
                    ++index;
                }
            }
        });
    }

    public abstract class TaskSelectTypeUIDescriptor {
        private boolean bVisible = true;

        public boolean isVisible() {
            return this.bVisible;
        }

        public void setVisible(boolean bVisible) {
            this.bVisible = bVisible;
        }

        public abstract int getIndex();

        public abstract void createControl(Composite var1);
    }
}

