/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.operations.jsf;

import java.util.List;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.w3c.dom.Element;

public abstract class TableBasedOperation
extends AbstractTransformOperation {
    public Element transform(Element srcElement, Element curElement) {
        Element tableElement = this.createElement("table");
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CopyAttributeOperation, new String[]{"styleClass"});
        operation.transform(srcElement, tableElement);
        operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_RenameAttributeOperation, new String[]{"styleClass", "class"});
        operation.transform(srcElement, tableElement);
        operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CopyAttributeOperation, new String[]{"style"});
        operation.transform(srcElement, tableElement);
        operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CopyAttributeOperation, new String[]{"border"});
        operation.transform(srcElement, tableElement);
        boolean layoutHorizontal = true;
        if ("pageDirection".equalsIgnoreCase(srcElement.getAttribute("layout"))) {
            layoutHorizontal = false;
        }
        Element itemContainer = layoutHorizontal ? this.appendChildElement("tr", tableElement) : tableElement;
        boolean isDisabled = Boolean.TRUE.toString().equalsIgnoreCase(srcElement.getAttribute("disabled"));
        boolean isReadOnly = Boolean.TRUE.toString().equalsIgnoreCase(srcElement.getAttribute("readonly"));
        List selectItemList = this.getChildElements(srcElement, "selectItem");
        for (Element selectItem : selectItemList) {
            String selectItemValue;
            String selectItemID;
            Element labelElement = this.createElement("label");
            Element inputElement = this.appendChildElement("input", labelElement);
            inputElement.setAttribute("type", this.getInputType());
            if (isDisabled || Boolean.TRUE.toString().equalsIgnoreCase(selectItem.getAttribute("itemDisabled"))) {
                inputElement.setAttribute("disabled", "disabled");
            }
            if (isReadOnly) {
                inputElement.setAttribute("readonly", "readonly");
            }
            if ((selectItemID = selectItem.getAttribute("id")) != null && selectItemID.length() > 0) {
                inputElement.setAttribute("id", selectItemID);
            }
            if ((selectItemValue = selectItem.getAttribute("value")) != null && selectItemValue.length() > 0) {
                inputElement.setAttribute("value", selectItemValue);
            }
            String label = this.getSelectItemLabel(selectItem);
            this.appendChildText(label, labelElement);
            if (layoutHorizontal) {
                Element tdElement = this.appendChildElement("td", itemContainer);
                tdElement.appendChild(labelElement);
                continue;
            }
            Element trElement = this.appendChildElement("tr", itemContainer);
            Element tdElement = this.appendChildElement("td", trElement);
            tdElement.appendChild(labelElement);
        }
        return tableElement;
    }

    protected abstract String getInputType();

    private String getSelectItemLabel(Element selectItem) {
        String attribute = selectItem.getAttribute("itemLabel");
        if (attribute != null && attribute.length() > 0) {
            return attribute;
        }
        attribute = selectItem.getAttribute("value");
        if (attribute != null && attribute.length() > 0) {
            return attribute;
        }
        attribute = selectItem.getAttribute("itemDescription");
        if (attribute != null && attribute.length() > 0) {
            return attribute;
        }
        attribute = selectItem.getAttribute("itemValue");
        if (attribute != null && attribute.length() > 0) {
            return attribute;
        }
        return "selectItem";
    }
}

