/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.valueexpr;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.manifest.CombinedExpressionOperatorDefinition;

public class CombinedValueExpressionOperator
implements IExecutableExtension {
    public static final String ADD = "Add";
    public static final String SUBTRACT = "Subtract";
    public static final String MULTIPLY = "Multiply";
    public static final String DIVIDE = "Divide";
    public static final String CONCATENATE = "Concatenate";
    public static final CombinedValueExpressionOperator ADD_LITERAL = new CombinedValueExpressionOperator("Add", "+");
    public static final CombinedValueExpressionOperator SUBTRACT_LITERAL = new CombinedValueExpressionOperator("Subtract", "-");
    public static final CombinedValueExpressionOperator MULTIPLY_LITERAL = new CombinedValueExpressionOperator("Multiply", "*");
    public static final CombinedValueExpressionOperator DIVIDE_LITERAL = new CombinedValueExpressionOperator("Divide", "/");
    public static final CombinedValueExpressionOperator CONCATENATE_LITERAL = new CombinedValueExpressionOperator("Concatenate", "+");
    private static Map<String, CombinedValueExpressionOperator> sm_builtInOperators = null;
    private String m_id;
    private String m_literal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final CombinedValueExpressionOperator get(String builtInOperatorId) {
        if (sm_builtInOperators != null) return sm_builtInOperators.get(builtInOperatorId);
        Class<CombinedValueExpressionOperator> clazz = CombinedValueExpressionOperator.class;
        synchronized (CombinedValueExpressionOperator.class) {
            if (sm_builtInOperators != null) return sm_builtInOperators.get(builtInOperatorId);
            sm_builtInOperators = new HashMap<String, CombinedValueExpressionOperator>(5);
            sm_builtInOperators.put(ADD, ADD_LITERAL);
            sm_builtInOperators.put(SUBTRACT, SUBTRACT_LITERAL);
            sm_builtInOperators.put(MULTIPLY, MULTIPLY_LITERAL);
            sm_builtInOperators.put(DIVIDE, DIVIDE_LITERAL);
            sm_builtInOperators.put(CONCATENATE, CONCATENATE_LITERAL);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sm_builtInOperators.get(builtInOperatorId);
        }
    }

    public CombinedValueExpressionOperator(String id, String literal) {
        this.setId(id);
        this.setLiteral(literal);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.setId(config);
        this.setLiteral(config);
    }

    protected void setId(IConfigurationElement config) throws CoreException {
        try {
            this.setId(CombinedExpressionOperatorDefinition.getIdAttributeValue(config));
        }
        catch (OdaException ex) {
            throw new CoreException((IStatus)new Status(4, config.getNamespaceIdentifier(), ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    protected void setLiteral(IConfigurationElement config) throws CoreException {
        try {
            this.setLiteral(CombinedExpressionOperatorDefinition.getCustomLiteralAttributeValue(config));
        }
        catch (OdaException ex) {
            throw new CoreException((IStatus)new Status(4, config.getNamespaceIdentifier(), ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    protected void setId(String id) {
        this.m_id = id;
    }

    protected void setLiteral(String literal) {
        this.m_literal = literal;
    }

    public String getId() {
        return this.m_id;
    }

    public String getLiteral() {
        return this.m_literal;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [id= " + this.m_id + ", literal= " + this.m_literal + "]";
    }
}

