/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionUtil;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.CombinedValueExpressionOperator;

public class CombinedExpressionOperatorDefinition {
    static final String SUPPORTED_ELEMENT_NAME = "supportedOdaCombinedOperator";
    static final String CUSTOM_ELEMENT_NAME = "combinedOperatorType";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_LITERAL = "literal";
    protected static final String ATTR_CLASS = "class";
    private String m_id;
    private CombinedValueExpressionOperator m_customInstance;

    CombinedExpressionOperatorDefinition(IConfigurationElement exprElement) throws OdaException {
        this.init(exprElement);
    }

    private CombinedExpressionOperatorDefinition() {
    }

    private void init(IConfigurationElement opElement) throws OdaException {
        ResultExtensionUtil.validateConfigurationElement(opElement);
        this.m_id = CombinedExpressionOperatorDefinition.getIdAttributeValue(opElement);
        this.m_customInstance = this.createCustomOperator(opElement);
    }

    public static String getIdAttributeValue(IConfigurationElement opElement) throws OdaException {
        return ResultExtensionUtil.getRequiredAttributeValue(opElement, ATTR_ID, SUPPORTED_ELEMENT_NAME);
    }

    public static String getCustomLiteralAttributeValue(IConfigurationElement opElement) throws OdaException {
        return opElement.getAttribute(ATTR_LITERAL);
    }

    protected CombinedValueExpressionOperator createCustomOperator(IConfigurationElement opElement) throws OdaException {
        String className = opElement.getAttribute(ATTR_CLASS);
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            Object clazz = opElement.createExecutableExtension(ATTR_CLASS);
            if (clazz instanceof CombinedValueExpressionOperator) {
                CombinedValueExpressionOperator customInstance = (CombinedValueExpressionOperator)clazz;
                return customInstance;
            }
            throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_CLASS_TYPE_ATTRIBUTE, (Object[])new Object[]{className, ATTR_CLASS, CombinedValueExpressionOperator.class.getName()}));
        }
        catch (CoreException ex) {
            throw new OdaException(ex);
        }
    }

    public String getId() {
        return this.m_id;
    }

    public String getDisplayName() {
        return this.getId();
    }

    public boolean isBuiltInOperator() {
        return true;
    }

    public CombinedValueExpressionOperator getOperator() {
        if (this.m_customInstance != null) {
            return this.m_customInstance;
        }
        return CombinedValueExpressionOperator.get(this.m_id);
    }

    static CustomCombinedOperatorDefinition newCustomDefinition(IConfigurationElement opElement) throws OdaException {
        CombinedExpressionOperatorDefinition combinedExpressionOperatorDefinition = new CombinedExpressionOperatorDefinition();
        combinedExpressionOperatorDefinition.getClass();
        return combinedExpressionOperatorDefinition.new CustomCombinedOperatorDefinition(opElement);
    }

    public class CustomCombinedOperatorDefinition
    extends CombinedExpressionOperatorDefinition {
        private static final String ATTR_NAME = "displayName";
        private String m_name;

        private CustomCombinedOperatorDefinition(IConfigurationElement opElement) throws OdaException {
            super(opElement);
            this.m_name = opElement.getAttribute(ATTR_NAME);
        }

        protected CombinedValueExpressionOperator createCustomOperator(IConfigurationElement opElement) throws OdaException {
            CombinedValueExpressionOperator customOp = super.createCustomOperator(opElement);
            if (customOp == null) {
                String literal = ResultExtensionUtil.getRequiredAttributeValue(opElement, CombinedExpressionOperatorDefinition.ATTR_LITERAL, CombinedExpressionOperatorDefinition.CUSTOM_ELEMENT_NAME);
                customOp = new CombinedValueExpressionOperator(this.getId(), literal);
            }
            return customOp;
        }

        public String getDisplayName() {
            if (this.m_name != null && this.m_name.trim().length() > 0) {
                return this.m_name;
            }
            return CombinedExpressionOperatorDefinition.this.m_id;
        }

        public boolean isBuiltInOperator() {
            return false;
        }
    }
}

