/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class EntityManagerFactoryProvider {
    public static final HashMap<String, EntityManagerSetupImpl> emSetupImpls = new HashMap();
    public static final HashMap<String, PersistenceUnitInfo> persistenceUnits = new HashMap();
    public static volatile int PUIUsageCount = 0;
    protected static final String[][] oldPropertyNames = new String[][]{{"eclipselink.jdbc.write-connections.max", "eclipselink.max-write-connections"}, {"eclipselink.jdbc.write-connections.min", "eclipselink.min-write-connections"}, {"eclipselink.jdbc.read-connections.max", "eclipselink.max-read-connections"}, {"eclipselink.jdbc.read-connections.min", "eclipselink.min-read-connections"}, {"eclipselink.jdbc.bind-parameters", "eclipselink.bind-all-parameters"}, {"eclipselink.target-database", "eclipselink.platform.class.name"}, {"eclipselink.target-server", "eclipselink.server.platform.class.name"}, {"eclipselink.cache.size.default", "eclipselink.cache.default-size"}};

    public static void addEntityManagerSetupImpl(String name, EntityManagerSetupImpl setup) {
        if (name == null) {
            emSetupImpls.put("", setup);
        }
        emSetupImpls.put(name, setup);
    }

    protected static String addFileSeperator(String appLocation) {
        int strLength = appLocation.length();
        if (appLocation.substring(strLength - 1, strLength).equals(File.separator)) {
            return appLocation;
        }
        return appLocation + File.separator;
    }

    protected static void createOrReplaceDefaultTables(SchemaManager mgr, boolean shouldDropFirst) {
        if (shouldDropFirst) {
            mgr.replaceDefaultTables(true, true);
        } else {
            mgr.createDefaultTables(true);
        }
    }

    protected static void generateDDL(ServerSession session, Map props) {
        boolean createTables = false;
        boolean shouldDropFirst = false;
        if (null == props) {
            return;
        }
        String ddlGeneration = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation", props, "none");
        if ((ddlGeneration = ddlGeneration.toLowerCase()).equals("none")) {
            return;
        }
        if (ddlGeneration.equals("create-tables") || ddlGeneration.equals("drop-and-create-tables")) {
            createTables = true;
            if (ddlGeneration.equals("drop-and-create-tables")) {
                shouldDropFirst = true;
            }
        }
        if (createTables) {
            String ddlGenerationMode = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation.output-mode", props, "database");
            if (ddlGenerationMode.equals("none")) {
                return;
            }
            SchemaManager mgr = new SchemaManager((DatabaseSessionImpl)session);
            if (ddlGenerationMode.equals("database") || ddlGenerationMode.equals("both")) {
                EntityManagerFactoryProvider.writeDDLToDatabase(mgr, shouldDropFirst);
            }
            if (ddlGenerationMode.equals("sql-script") || ddlGenerationMode.equals("both")) {
                String appLocation = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.application-location", props, PersistenceUnitProperties.DEFAULT_APP_LOCATION);
                String createDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.create-ddl-jdbc-file-name", props, "createDDL.jdbc");
                String dropDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.drop-ddl-jdbc-file-name", props, "dropDDL.jdbc");
                EntityManagerFactoryProvider.writeDDLsToFiles(mgr, appLocation, createDDLJdbc, dropDDLJdbc);
            }
        }
    }

    public static String getConfigPropertyAsString(String propertyKey, Map overrides) {
        String value = null;
        if (overrides != null) {
            value = (String)overrides.get(propertyKey);
        }
        if (value == null) {
            value = System.getProperty(propertyKey);
        }
        return value;
    }

    public static String getConfigPropertyAsString(String propertyKey, Map overrides, String defaultValue) {
        String value = EntityManagerFactoryProvider.getConfigPropertyAsString(propertyKey, overrides);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected static String getConfigPropertyAsStringLogDebug(String propertyKey, Map overrides, AbstractSession session) {
        return (String)EntityManagerFactoryProvider.getConfigPropertyLogDebug(propertyKey, overrides, session);
    }

    protected static String getConfigPropertyAsStringLogDebug(String propertyKey, Map overrides, AbstractSession session, boolean useSystemAsDefault) {
        return (String)EntityManagerFactoryProvider.getConfigPropertyLogDebug(propertyKey, overrides, session, useSystemAsDefault);
    }

    protected static String getConfigPropertyAsStringLogDebug(String propertyKey, Map overrides, String defaultValue, AbstractSession session) {
        String value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(propertyKey, overrides, session);
        if (value == null) {
            value = defaultValue;
            session.log(1, "properties", "property_value_default", new Object[]{propertyKey, value});
        }
        return value;
    }

    protected static Object getConfigPropertyLogDebug(String propertyKey, Map overrides, AbstractSession session) {
        return EntityManagerFactoryProvider.getConfigPropertyLogDebug(propertyKey, overrides, session, true);
    }

    protected static Object getConfigPropertyLogDebug(String propertyKey, Map overrides, AbstractSession session, boolean useSystemAsDefault) {
        String value = null;
        if (overrides != null) {
            value = (String)overrides.get(propertyKey);
        }
        if (value == null && useSystemAsDefault) {
            value = System.getProperty(propertyKey);
        }
        if (value != null && session != null && session.shouldLog(1, "properties")) {
            String overrideValue = PersistenceUnitProperties.getOverriddenLogStringForProperty((String)propertyKey);
            String logValue = overrideValue == null ? value : overrideValue;
            session.log(1, "properties", "property_value_specified", new Object[]{propertyKey, logValue});
        }
        return value;
    }

    public static EntityManagerSetupImpl getEntityManagerSetupImpl(String emName) {
        if (emName == null) {
            return emSetupImpls.get("");
        }
        return emSetupImpls.get(emName);
    }

    public static PersistenceUnitInfo getPersistenceUnitInfo(String puName) {
        if (puName == null) {
            return persistenceUnits.get("");
        }
        return persistenceUnits.get(puName);
    }

    protected static void login(ServerSession session, Map properties) {
        String eclipselinkPlatform = (String)properties.get("eclipselink.target-database");
        if (!session.isConnected()) {
            if (eclipselinkPlatform == null || eclipselinkPlatform.equals("Auto")) {
                session.loginAndDetectDatasource();
            } else {
                session.login();
            }
        }
    }

    public static Map mergeMaps(Map target, Map source) {
        HashMap map = new HashMap();
        if (source != null) {
            map.putAll(source);
        }
        if (target != null) {
            map.putAll(target);
        }
        return map;
    }

    protected static void translateOldProperties(Map m, AbstractSession session) {
        for (int i = 0; i < oldPropertyNames.length; ++i) {
            String value = EntityManagerFactoryProvider.getConfigPropertyAsString(oldPropertyNames[i][1], m);
            if (value == null) continue;
            if (session != null) {
                session.log(5, "transaction", "deprecated_property", oldPropertyNames[i]);
            }
            m.put(oldPropertyNames[i][0], value);
        }
    }

    protected static void warnOldProperties(Map m, AbstractSession session) {
        for (int i = 0; i < oldPropertyNames.length; ++i) {
            Object value = m.get(oldPropertyNames[i][1]);
            if (value == null) continue;
            session.log(5, "transaction", "deprecated_property", oldPropertyNames[i]);
        }
    }

    protected static void writeDDLToDatabase(SchemaManager mgr, boolean shouldDropFirst) {
        String str = EntityManagerFactoryProvider.getConfigPropertyAsString("INTERACT_WITH_DB", null, "true");
        boolean interactWithDB = Boolean.valueOf(str.toLowerCase());
        if (!interactWithDB) {
            return;
        }
        EntityManagerFactoryProvider.createOrReplaceDefaultTables(mgr, shouldDropFirst);
    }

    protected static void writeDDLsToFiles(SchemaManager mgr, String appLocation, String createDDLJdbc, String dropDDLJdbc) {
        appLocation = EntityManagerFactoryProvider.addFileSeperator(appLocation);
        if (null != createDDLJdbc) {
            String createJdbcFileName = appLocation + createDDLJdbc;
            mgr.outputCreateDDLToFile(createJdbcFileName);
        }
        if (null != dropDDLJdbc) {
            String dropJdbcFileName = appLocation + dropDDLJdbc;
            mgr.outputDropDDLToFile(dropJdbcFileName);
        }
        mgr.setCreateSQLFiles(false);
        EntityManagerFactoryProvider.createOrReplaceDefaultTables(mgr, true);
        mgr.closeDDLWriter();
    }
}

