/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tracwiki.core.token;

import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.tracwiki.core.TracWikiLanguage;

public class ChangesetLinkReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(r(\\d+))|(\\[(\\d+)(?:/(\\w+))?\\])|(changeset:(\\d+)(?:/(\\w+))?)";
    }

    protected int getPatternGroupCount() {
        return 8;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new ChangesetReplacementTokenProcessor();
    }

    private static class ChangesetReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private ChangesetReplacementTokenProcessor() {
        }

        public void emit() {
            String text = this.group(1);
            String changesetId = this.group(2);
            String restriction = null;
            if (changesetId == null) {
                text = this.group(3);
                changesetId = this.group(4);
                restriction = this.group(5);
                if (changesetId == null) {
                    text = this.group(6);
                    changesetId = this.group(7);
                    restriction = this.group(8);
                }
            }
            String href = ((TracWikiLanguage)this.markupLanguage).toChangesetHref(changesetId, restriction);
            this.builder.link(href, text);
        }
    }
}

