/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.deltaddl;

import java.util.List;
import java.util.Map;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlConstants;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlUtils;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class SybaseIndexDeltaDdlGenProvider
extends AbstractDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
ISybaseDdlConstants {
    protected void addCreateStatement(SybaseDdlScript script, String statement) {
        script.addCreateIndexStatement(statement);
    }

    protected void addDropStatement(SybaseDdlScript script, String statement) {
        script.addDropIndexStatement(statement);
    }

    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
        super.analyze(element, changeMap, modificationRecords);
        List records = (List)modificationRecords.get(element);
        if (records != null) {
            int i = records.size() - 1;
            while (i >= 0) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord rc = (SybaseDeltaDdlGeneration.FeatureChangeRecord)records.get(i);
                EStructuralFeature feature = rc.feature;
                if (this.needRecreate(feature) && !SybaseDdlUtils.isEqualIndexMembers(rc.newValue, rc.oldValue)) {
                    changeMap.clear();
                    changeMap.put(element, new Integer(3));
                }
                --i;
            }
        }
    }

    protected boolean needRecreate(EStructuralFeature feature) {
        if (feature != null) {
            switch (feature.getFeatureID()) {
                case 1: {
                    return false;
                }
                case 8: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

