/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tasks.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractTaskHyperlinkDetector;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.wikitext.tasks.ui.editor.MarkupTaskEditorExtension;
import org.eclipse.mylyn.wikitext.tracwiki.core.TracWikiLanguage;
import org.eclipse.mylyn.wikitext.ui.viewer.AbstractTextSourceViewerConfiguration;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewer;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracWikiMarkupTaskEditorExtension
extends MarkupTaskEditorExtension<TracWikiLanguage>
implements AbstractTextSourceViewerConfiguration.HyperlinkDetectorDescriptorFilter {
    private final TracTaskHyperlinkDetector hyperlinkDetector = new TracTaskHyperlinkDetector();

    public TracWikiMarkupTaskEditorExtension() {
        this.setMarkupLanguage(new TracWikiLanguage());
    }

    @Override
    protected void configureDefaultInternalLinkPattern(TaskRepository taskRepository, TracWikiLanguage markupLanguage) {
        String url = taskRepository.getRepositoryUrl();
        if (url != null && url.length() > 0) {
            if (!url.endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            markupLanguage.setInternalLinkPattern(String.valueOf(url) + "wiki/{0}");
            markupLanguage.setServerUrl(url);
        }
    }

    @Override
    protected MarkupTaskEditorExtension.TaskMarkupSourceViewerConfiguration createSourceViewerConfiguration(TaskRepository taskRepository, SourceViewer viewer) {
        MarkupTaskEditorExtension.TaskMarkupSourceViewerConfiguration configuration = super.createSourceViewerConfiguration(taskRepository, viewer);
        configuration.addHyperlinkDetectorDescriptorFilter(this);
        configuration.addHyperlinkDetector((IHyperlinkDetector)this.hyperlinkDetector);
        return configuration;
    }

    @Override
    protected MarkupTaskEditorExtension.TaskMarkupViewerConfiguration createViewerConfiguration(TaskRepository taskRepository, MarkupViewer markupViewer) {
        MarkupTaskEditorExtension.TaskMarkupViewerConfiguration configuration = super.createViewerConfiguration(taskRepository, markupViewer);
        configuration.addHyperlinkDetectorDescriptorFilter(this);
        configuration.addHyperlinkDetector((IHyperlinkDetector)this.hyperlinkDetector);
        return configuration;
    }

    public boolean filter(HyperlinkDetectorDescriptor descriptor) {
        String id = descriptor.getId();
        return "org.eclipse.mylyn.trac.ui.hyperlinksDetectors.Trac".equals(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TracTaskHyperlinkDetector
    extends AbstractTaskHyperlinkDetector {
        private final Pattern pattern = Pattern.compile("(?:(?<=[\\s\\.\\\"'?!;:\\)\\(\\{\\}\\[\\]-])|^)((?:comment:(\\d+):)?(?:#|ticket:)(\\d+))");

        protected List<IHyperlink> detectHyperlinks(ITextViewer textViewer, String content, int index, int contentOffset) {
            TaskRepository taskRepository = this.getTaskRepository(textViewer);
            if (taskRepository != null && "trac".equals(taskRepository.getConnectorKind())) {
                ArrayList<TaskHyperlink> hyperlinks = null;
                Matcher matcher = this.pattern.matcher(content);
                while (matcher.find()) {
                    if (!this.isInRegion(index, matcher)) continue;
                    if (hyperlinks == null) {
                        hyperlinks = new ArrayList<TaskHyperlink>();
                    }
                    String taskId = matcher.group(3);
                    hyperlinks.add(new TaskHyperlink(this.determineRegion(contentOffset, matcher), taskRepository, taskId));
                }
                return hyperlinks;
            }
            return null;
        }

        private boolean isInRegion(int offsetInText, Matcher m) {
            return offsetInText == -1 || offsetInText >= m.start() && offsetInText <= m.end();
        }

        private IRegion determineRegion(int textOffset, Matcher m) {
            return new Region(textOffset + m.start(), m.end() - m.start());
        }
    }
}

