/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tasks.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.internal.wikitext.tasks.ui.ActiveFoldingListener;
import org.eclipse.mylyn.internal.wikitext.ui.editor.IFoldingStructure;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ActiveFoldingEditorTracker
extends AbstractEditorTracker {
    private final Map<IEditorPart, ActiveFoldingListener> partToListener = new HashMap<IEditorPart, ActiveFoldingListener>();

    public ActiveFoldingEditorTracker(IWorkbench workbench) {
        this.install(workbench);
    }

    public void install(IWorkbench workbench) {
        super.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference reference = iEditorReferenceArray[n6];
                    IEditorPart editorPart = reference.getEditor(false);
                    if (editorPart != null) {
                        this.editorOpened(editorPart);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void editorBroughtToTop(IEditorPart part) {
    }

    protected void editorClosed(IEditorPart part) {
        ActiveFoldingListener listener = this.partToListener.remove(part);
        if (listener != null) {
            listener.dispose();
        }
    }

    protected void editorOpened(IEditorPart part) {
        IFoldingStructure foldingStructure = (IFoldingStructure)part.getAdapter(IFoldingStructure.class);
        if (foldingStructure == null) {
            return;
        }
        if (this.partToListener.containsKey(part)) {
            return;
        }
        this.partToListener.put(part, new ActiveFoldingListener(part, foldingStructure));
    }
}

