/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.elements.interfaces.IDesignElementModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PropertyBindingPage
extends AbstractDescriptionPropertyPage {
    private IDesignElementModel ds;
    private List bindingName = new ArrayList();
    private List displayName = new ArrayList();
    private List bindingValue = new ArrayList();
    private List nameLabelList = new ArrayList();
    private List<Text> propertyTextList = new ArrayList<Text>();
    private final String QUERYTEXT = "queryText";
    private final String ODAPASSWORD = "odaPassword";
    private final String PASSWORD = "Password";
    private static Logger logger = Logger.getLogger(PropertyBindingPage.class.getName());
    private ReportElementHandle handle;

    public Control createContents(Composite parent) {
        this.initPropertyBinding();
        int size = this.bindingName.size();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(272);
        composite.setLayoutData((Object)gridData);
        Text propertyText = null;
        int i = 0;
        while (i < size) {
            OdaDataSourceHandle odsh;
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText(String.valueOf((String)this.displayName.get(i)) + Messages.getString((String)"PropertyBindingPage.label.colon"));
            this.nameLabelList.add(nameLabel);
            GridData data = new GridData(768);
            if (((String)this.bindingName.get(i)).equals("queryText")) {
                propertyText = new Text(composite, 2816);
                data.heightHint = 100;
            } else if ("odaPassword".equals((String)this.bindingName.get(i)) || "Password".equals((String)this.bindingName.get(i))) {
                Expression expr;
                propertyText = new Text(composite, 2048);
                if (this.ds instanceof DesignElementHandle && (expr = ((DesignElementHandle)this.ds).getPropertyBindingExpression((String)this.bindingName.get(i))) != null && "constant".equals(expr.getType())) {
                    Text dummy = new Text(composite, 0x400800);
                    propertyText.setEchoChar(dummy.getEchoChar());
                    dummy.dispose();
                }
            } else {
                propertyText = new Text(composite, 2048);
            }
            propertyText.setLayoutData((Object)data);
            propertyText.setText((String)this.bindingValue.get(i) == null ? "" : (String)this.bindingValue.get(i));
            this.propertyTextList.add(propertyText);
            if (this.ds instanceof OdaDataSourceHandle) {
                this.handle = (OdaDataSourceHandle)this.ds;
                odsh = (OdaDataSourceHandle)this.ds;
                Utility.setSystemHelp((Control)composite, (String)("org.eclipse.birt.cshelp.Wizard_DataSourcePropertyBinding(" + odsh.getExtensionID().replace('.', '_') + ")" + "_ID"));
            } else if (this.ds instanceof OdaDataSetHandle) {
                this.handle = (OdaDataSetHandle)this.ds;
                odsh = (OdaDataSourceHandle)((OdaDataSetHandle)this.ds).getDataSource();
                Utility.setSystemHelp((Control)composite, (String)("org.eclipse.birt.cshelp.Wizard_DataSetPropertyBinding(" + odsh.getExtensionID().replace('.', '_') + ")" + "_ID"));
            }
            this.createExpressionButton(composite, propertyText, (String)this.bindingName.get(i));
            ++i;
        }
        if (size <= 0) {
            this.setEmptyPropertyMessages(composite);
        }
        return composite;
    }

    private void createExpressionButton(Composite composite, Text property, String propName) {
        Expression expr;
        ExpressionButton exprButton = ExpressionButtonUtil.createExpressionButton((Composite)composite, (Control)property, (IExpressionProvider)new ExpressionProvider((DesignElementHandle)this.handle), (Object)this.handle, (boolean)true, (int)8);
        if ("odaPassword".equals(propName) || "Password".equals(propName)) {
            exprButton.setExpressionButtonProvider((IExpressionButtonProvider)new ExprButtonProvider(true, property));
        }
        property.setData("exprType", (Object)((expr = this.handle.getPropertyBindingExpression(propName)) == null || expr.getType() == null ? UIUtil.getDefaultScriptType() : expr.getType()));
        property.setText(expr == null || expr.getStringExpression() == null ? "" : expr.getStringExpression());
        exprButton.refresh();
    }

    private void initPropertyBinding() {
        this.ds = (IDesignElementModel)this.getContainer().getModel();
        Iterator iterator = null;
        IElementDefn elementDefn = this.getElementDefn();
        if (elementDefn != null) {
            iterator = elementDefn.getProperties().iterator();
        }
        if (this.ds instanceof DataSetHandle && ((DataSetHandle)this.ds).getPropertyHandle("queryText").isVisible()) {
            this.bindingName.add("queryText");
            this.displayName.add(Messages.getString((String)"PropertyBindingPage.dataset.queryText"));
            this.bindingValue.add(((DataSetHandle)this.ds).getPropertyBinding("queryText") == null ? "" : ((DataSetHandle)this.ds).getPropertyBinding("queryText"));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                IElementPropertyDefn propertyDefn = (IElementPropertyDefn)iterator.next();
                if (!(propertyDefn instanceof IPropertyDefn) || propertyDefn.getValueType() != 4) continue;
                String name = propertyDefn.getName();
                if (elementDefn != null && !elementDefn.isPropertyVisible(name)) continue;
                this.bindingName.add(name);
                this.displayName.add(propertyDefn.getDisplayName());
                if (this.ds instanceof DataSetHandle) {
                    this.bindingValue.add(((DataSetHandle)this.ds).getPropertyBinding(name) == null ? "" : ((DataSetHandle)this.ds).getPropertyBinding(name));
                    continue;
                }
                if (this.ds instanceof DataSourceHandle) {
                    this.bindingValue.add(((DataSourceHandle)this.ds).getPropertyBinding(name) == null ? "" : ((DataSourceHandle)this.ds).getPropertyBinding(name));
                    continue;
                }
                this.bindingValue.add("");
            }
        }
    }

    private IElementDefn getElementDefn() {
        IElementDefn elementDefn = null;
        if (this.ds instanceof DataSourceHandle) {
            elementDefn = ((DataSourceHandle)this.ds).getDefn();
        } else if (this.ds instanceof DataSetHandle) {
            elementDefn = ((DataSetHandle)this.ds).getDefn();
        }
        return elementDefn;
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.bindingName.size()) {
            try {
                String value = null;
                Text propertyText = this.propertyTextList.get(i);
                if (!propertyText.isDisposed() && propertyText.getText() != null && propertyText.getText().trim().length() > 0) {
                    value = propertyText.getText().trim();
                }
                Expression expr = new Expression(value, (String)propertyText.getData("exprType"));
                if (this.ds instanceof DesignElementHandle) {
                    ((DesignElementHandle)this.ds).setPropertyBinding((String)this.bindingName.get(i), expr);
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, e.getMessage(), e);
                ExceptionHandler.handle((Throwable)e);
                return true;
            }
            ++i;
        }
        return super.performOk();
    }

    private void setEmptyPropertyMessages(Composite composite) {
        Label messageLabel = new Label(composite, 0);
        if (this.ds instanceof DataSourceHandle) {
            messageLabel.setText(Messages.getString((String)"PropertyBindingPage.datasource.property.empty"));
        } else if (this.ds instanceof DataSetHandle) {
            messageLabel.setText(Messages.getString((String)"PropertyBindingPage.dataset.property.empty"));
        }
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"datasource.editor.property"), 0);
    }

    public String getToolTip() {
        return Messages.getString((String)"PropertyBindingPage.property.tooltip");
    }

    private class ExprButtonProvider
    extends ExpressionButtonProvider {
        private Text propText;

        public ExprButtonProvider(boolean allowConstant, Text propText) {
            super(allowConstant);
            this.propText = propText;
        }

        public void handleSelectionEvent(String exprType) {
            super.handleSelectionEvent(exprType);
            if ("constant".equals(exprType)) {
                Text dummy = new Text(this.propText.getParent(), 0x400800);
                this.propText.setEchoChar(dummy.getEchoChar());
                dummy.dispose();
            } else {
                this.propText.setEchoChar('\u0000');
            }
        }
    }
}

