/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableAction;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableActionFactory;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExecutorHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.properties.AbstractPropertyPage;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class OutputParameterPreviewPage
extends AbstractPropertyPage
implements Listener {
    private Table outputParameterTable = null;
    private boolean modelChanged = true;
    private static final String PREFIX_OUTPUTPARAMETER = "outputParams";
    private static final String PREFIX_PARAMETER = "PARAMS_";

    public Control createPageControl(Composite parent) {
        this.outputParameterTable = new Table(parent, 65538);
        this.outputParameterTable.setHeaderVisible(true);
        this.outputParameterTable.setLinesVisible(true);
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        this.outputParameterTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    MenuManager menuManager = new MenuManager();
                    ResultSetTableAction copyAction = ResultSetTableActionFactory.createResultSetTableAction(OutputParameterPreviewPage.this.outputParameterTable, 1);
                    ResultSetTableAction selectAllAction = ResultSetTableActionFactory.createResultSetTableAction(OutputParameterPreviewPage.this.outputParameterTable, 2);
                    menuManager.add((IAction)copyAction);
                    menuManager.add((IAction)selectAllAction);
                    menuManager.update();
                    copyAction.update();
                    selectAllAction.update();
                    Menu contextMenu = menuManager.createContextMenu((Control)OutputParameterPreviewPage.this.outputParameterTable);
                    contextMenu.setEnabled(true);
                    contextMenu.setVisible(true);
                }
            }
        });
        return this.outputParameterTable;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (focus.equals(this.getContainer().getModel())) {
            this.modelChanged = true;
        }
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputparameters"), 0);
        if (this.modelChanged || ((DataSetEditor)this.getContainer()).modelChanged()) {
            this.modelChanged = false;
            this.runUpdateResults();
        }
    }

    private void runUpdateResults() {
        if (this.outputParameterTable != null && !this.outputParameterTable.isDisposed()) {
            this.clearResultSetTable();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (OutputParameterPreviewPage.this.outputParameterTable != null && !OutputParameterPreviewPage.this.outputParameterTable.isDisposed()) {
                        OutputParameterPreviewPage.this.updateResults();
                    }
                }
            });
        }
    }

    private void clearResultSetTable() {
        TableColumn[] columns = this.outputParameterTable.getColumns();
        int n = 0;
        while (n < columns.length) {
            columns[n].dispose();
            ++n;
        }
        this.outputParameterTable.removeAll();
    }

    private void updateResults() {
        int outputParamsSize = this.outputParametersSize();
        if (outputParamsSize == 0) {
            return;
        }
        DataRequestSession session = null;
        try {
            try {
                DataSessionContext context = new DataSessionContext(3, ((DataSetEditor)this.getContainer()).getHandle().getModuleHandle());
                session = DataRequestSession.newSession((DataSessionContext)context);
                QueryDefinition query = new QueryDefinition();
                query.setDataSetName(((DataSetEditor)this.getContainer()).getHandle().getQualifiedName());
                query.setMaxRows(1);
                PropertyHandle propertyHandle = ((DataSetEditor)this.getContainer()).getHandle().getPropertyHandle("parameters");
                int paramsSize = propertyHandle.getListValue().size();
                Iterator paramIter = propertyHandle.iterator();
                int outputParamIndex = 0;
                TableLayout layout = new TableLayout();
                TableColumn column = null;
                TableItem tableItem = null;
                ArrayList<String> paramColumnBindingNames = new ArrayList<String>();
                int n = 1;
                while (n <= paramsSize) {
                    DataSetParameterHandle paramDefn = (DataSetParameterHandle)paramIter.next();
                    if (paramDefn.isOutput()) {
                        column = new TableColumn(this.outputParameterTable, 16384);
                        column.setText(paramDefn.getName());
                        column.setResizable(true);
                        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(120, true));
                        String bindingName = PREFIX_PARAMETER + outputParamIndex++;
                        Binding binding = new Binding(bindingName);
                        binding.setExpression((IBaseExpression)new ScriptExpression("outputParams[\"" + paramDefn.getName() + "\"]"));
                        binding.setDataType(DataAdapterUtil.adaptModelDataType((String)paramDefn.getDataType()));
                        paramColumnBindingNames.add(bindingName);
                        query.addBinding((IBinding)binding);
                        column.pack();
                    }
                    ++n;
                }
                this.outputParameterTable.setLayout((Layout)layout);
                this.outputParameterTable.layout(true);
                DataSetExecutorHelper helper = new DataSetExecutorHelper();
                IQueryResults actualResultSet = helper.execute(((DataSetEditor)this.getContainer()).getHandle(), query, true, true, session);
                if (actualResultSet != null) {
                    IResultIterator iter = actualResultSet.getResultIterator();
                    iter.next();
                    String[] record = new String[outputParamIndex];
                    int n2 = 0;
                    while (n2 < record.length) {
                        record[n2] = iter.getString(paramColumnBindingNames.get(n2).toString());
                        ++n2;
                    }
                    tableItem = new TableItem(this.outputParameterTable, 0);
                    tableItem.setText(record);
                    actualResultSet.close();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
                if (session != null) {
                    session.shutdown();
                }
            }
        }
        finally {
            if (session != null) {
                session.shutdown();
            }
        }
    }

    private int outputParametersSize() {
        PropertyHandle propertyHandle = ((DataSetEditor)this.getContainer()).getHandle().getPropertyHandle("parameters");
        ArrayList paramList = propertyHandle.getListValue();
        if (paramList == null || paramList.size() == 0) {
            return 0;
        }
        int size = 0;
        int paramSize = paramList.size();
        int i = 0;
        while (i < paramSize) {
            DataSetParameter parameter = (DataSetParameter)paramList.get(i);
            if (parameter.isOutput()) {
                ++size;
            }
            ++i;
        }
        return size;
    }

    public boolean performOk() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performOk();
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public String getToolTip() {
        return Messages.getString((String)"dataset.outputparameters.preview.tooltip");
    }
}

