/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;

public class ExternalUIUtil {
    public static void validateDataSetHandle(DataSetHandle ds) {
        if (!(ds instanceof JointDataSetHandle)) {
            if (ds.getDataSource() == null) {
                throw new RuntimeException(Messages.getFormattedString((String)"dataset.editor.error.noDataSource", (Object[])new String[]{ds.getQualifiedName()}));
            }
            if (ds instanceof OdaDataSetHandle && !(ds.getDataSource() instanceof OdaDataSourceHandle)) {
                throw new RuntimeException(Messages.getFormattedString((String)"dataset.editor.error.nonmatchedDataSource", (Object[])new String[]{ds.getQualifiedName(), ((OdaDataSetHandle)ds).getExtensionID()}));
            }
            if (ds instanceof ScriptDataSetHandle && !(ds.getDataSource() instanceof ScriptDataSourceHandle)) {
                throw new RuntimeException(Messages.getFormattedString((String)"dataset.editor.error.nonmatchedDataSource", (Object[])new String[]{ds.getQualifiedName(), "ScriptSelectDataSet"}));
            }
        }
    }

    public static void populateApplicationContext(DataSetHandle handle, DataRequestSession session) throws BirtException {
    }

    public static boolean containsDataSource(DataSetHandle ds) {
        return !(ds instanceof JointDataSetHandle);
    }

    public static String getDataSourceType(DataSetHandle ds) {
        return null;
    }

    public static String getDataSetType(DataSetHandle ds) {
        return null;
    }

    public static IPropertyPage[] getCommonPages(DataSetHandle ds) {
        return new IPropertyPage[0];
    }

    public static DataSetHandle getQulifiedDataSetHandle(DataSetHandle ds) {
        return ds;
    }

    public static boolean needUtilityPages(DataSetHandle ds) {
        return true;
    }

    public static Expression getParamValueExpression(DataSetHandle dataSet, OdaDataSetParameterHandle paramDefn) throws BirtException {
        ParameterHandle ph;
        String linkedReportParam = paramDefn.getParamName();
        if (linkedReportParam != null && (ph = dataSet.getModuleHandle().findParameter(linkedReportParam)) instanceof ScalarParameterHandle && ((ScalarParameterHandle)ph).getParamType().equals("multi-value")) {
            throw new BirtException(Messages.getFormattedString((String)"dataset.editor.error.invalidLinkedParameter", (Object[])new String[]{linkedReportParam}), null);
        }
        return new Expression((Object)DataUtil.getParamValue((DataSetHandle)dataSet, (OdaDataSetParameterHandle)paramDefn), "javascript");
    }
}

