/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshAction;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.ShowPropertyAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.action.EditCubeMeasureGroupAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class TabularMeasureGroupNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        if (((MeasureGroupHandle)object).canEdit()) {
            menu.insertAfter("additions", (IAction)new EditCubeMeasureGroupAction(object, Messages.getString("CubeMeasureGroupNodeProvider.menu.text")));
        }
        menu.insertBefore("additions-refresh", (IAction)new ShowPropertyAction(object));
        menu.insertAfter("additions-refresh", (IContributionItem)new Separator());
        RefreshAction action = new RefreshAction(sourceViewer);
        if (action.isEnabled()) {
            menu.insertAfter("additions-refresh", (IAction)action);
        }
    }

    public Object[] getChildren(Object model) {
        return ((MeasureGroupHandle)model).getContents("measures").toArray();
    }

    public Object getParent(Object model) {
        MeasureGroupHandle measures = (MeasureGroupHandle)model;
        CubeHandle cube = (CubeHandle)measures.getContainer();
        if (cube != null) {
            return cube.getPropertyHandle("measureGroups");
        }
        return null;
    }

    public String getNodeDisplayName(Object object) {
        MeasureGroupHandle measures = (MeasureGroupHandle)object;
        return measures.getName();
    }

    public Image getNodeIcon(Object model) {
        if (model instanceof DesignElementHandle && ((DesignElementHandle)model).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK");
        }
        return UIHelper.getImage("icons/obj16/measure_group.gif");
    }
}

