/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DateLevelDialog
extends TitleAreaDialog {
    private static final String NONE = Messages.getString("DateLevelDialog.None");
    private Text nameText;
    private Combo typeCombo;
    private TabularLevelHandle input;
    private TabularCubeHandle cube;
    private IDialogHelper helper;
    private static HashMap formatMap = new HashMap();
    private Combo formatCombo;
    private Text fieldText;

    static {
        Date defaultDate = new Date();
        formatMap.put("year", new String[][]{{new DateFormatter("yyyy").format(defaultDate), "yyyy"}, {new DateFormatter("yy").format(defaultDate), "yy"}});
        formatMap.put("month", new String[][]{{new DateFormatter("MMM").format(defaultDate), "MMM"}, {new DateFormatter("MMM yyyy").format(defaultDate), "MMM yyyy"}, {new DateFormatter("MMM yy").format(defaultDate), "MMM yy"}});
        formatMap.put("day-of-year", new String[][]{{new DateFormatter("MMMM dd, yyyy").format(defaultDate), "MMMM dd, yyyy"}, {new DateFormatter("MMMM dd, yy").format(defaultDate), "MMMM dd, yy"}});
        formatMap.put("day-of-month", new String[][]{{new DateFormatter("dd").format(defaultDate), "dd"}});
        formatMap.put("day-of-week", new String[][]{{new DateFormatter("EEEE").format(defaultDate), "EEEE"}});
        formatMap.put("hour", new String[][]{{new DateFormatter("HH:mm:ss aaa").format(defaultDate), "HH:mm:ss aaa"}, {new DateFormatter("HH:mm:ss").format(defaultDate), "HH:mm:ss"}, {new DateFormatter("HH:mm").format(defaultDate), "HH:mm"}});
        formatMap.put("minute", new String[][]{{new DateFormatter("mm").format(defaultDate), "mm"}});
        formatMap.put("second", new String[][]{{new DateFormatter("ss").format(defaultDate), "ss"}});
    }

    private String[] getFormatDisplayItems(String type) {
        String[][] formatPattern = (String[][])formatMap.get(type);
        if (formatPattern == null) {
            return new String[0];
        }
        String[] items = new String[formatPattern.length];
        int i = 0;
        while (i < items.length) {
            items[i] = formatPattern[i][0];
            ++i;
        }
        return items;
    }

    private String[] getFormatPatternItems(String type) {
        String[][] formatPattern = (String[][])formatMap.get(type);
        String[] items = new String[formatPattern.length];
        int i = 0;
        while (i < items.length) {
            items[i] = formatPattern[i][1];
            ++i;
        }
        return items;
    }

    private String getDateFormatDisplayName(String dateType, String pattern) {
        if (dateType == null) {
            return NONE;
        }
        String[][] formatPattern = (String[][])formatMap.get(dateType);
        if (pattern == null) {
            return NONE;
        }
        int i = 0;
        while (i < formatPattern.length) {
            if (pattern.equals(formatPattern[i][1])) {
                return formatPattern[i][0];
            }
            ++i;
        }
        return NONE;
    }

    public DateLevelDialog() {
        super(UIUtil.getDefaultShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public void setInput(TabularCubeHandle cube, TabularLevelHandle level) {
        this.input = level;
        this.cube = cube;
    }

    private List getDateTypeNames(IChoice[] choices) {
        ArrayList<String> dateTypeList = new ArrayList<String>();
        if (choices == null) {
            return dateTypeList;
        }
        int i = 0;
        while (i < choices.length) {
            dateTypeList.add(choices[i].getName());
            ++i;
        }
        return dateTypeList;
    }

    private String[] getAvailableDateTypeDisplayNames() {
        List dateTypeList = this.getAvailableDateTypeNames();
        ArrayList<String> dateTypeDisplayList = new ArrayList<String>();
        int i = 0;
        while (i < dateTypeList.size()) {
            dateTypeDisplayList.add(this.getDateTypeDisplayName(dateTypeList.get(i).toString()));
            ++i;
        }
        return dateTypeDisplayList.toArray(new String[0]);
    }

    private IChoice[] getLevelTypesByDateType() {
        TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)this.input.getContainer();
        String dataField = this.input.getColumnName();
        if (hierarchy == null || dataField == null) {
            return null;
        }
        ResultSetColumnHandle column = OlapUtil.getDataField(OlapUtil.getHierarchyDataset(hierarchy), dataField);
        if (column == null) {
            return OlapUtil.getDateTimeLevelTypeChoices();
        }
        String dataType = column.getDataType();
        if (dataType.equals("date-time")) {
            return OlapUtil.getDateTimeLevelTypeChoices();
        }
        if (dataType.equals("date")) {
            return OlapUtil.getDateLevelTypeChoices();
        }
        return OlapUtil.getTimeLevelTypeChoices();
    }

    private List getAvailableDateTypeNames() {
        ArrayList dateTypeList = new ArrayList();
        dateTypeList.addAll(this.getDateTypeNames(this.getLevelTypesByDateType()));
        List levels = this.input.getContainer().getContents("levels");
        int i = 0;
        while (i < levels.size()) {
            if (levels.get(i) != this.input) {
                dateTypeList.remove(((TabularLevelHandle)levels.get(i)).getDateTimeLevelType());
            }
            ++i;
        }
        return dateTypeList;
    }

    public String getDateTypeDisplayName(String name) {
        if (name == null) {
            return "";
        }
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)OlapUtil.getDateTimeLevelTypeChoiceSet());
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CubeBuilderDateLevelDialog_ID");
        this.setTitle(Messages.getString("DateLevelDialog.Title"));
        this.getShell().setText(Messages.getString("DateLevelDialog.Shell.Title"));
        this.setMessage(Messages.getString("DateLevelDialog.Message"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        contents.setLayoutData((Object)data);
        this.createContentArea(contents);
        WidgetUtil.createGridPlaceholder((Composite)contents, (int)1, (boolean)true);
        this.initLevelDialog();
        parent.layout();
        return contents;
    }

    private void initLevelDialog() {
        this.nameText.setText(this.input.getName());
        this.fieldText.setText(this.input.getColumnName());
        this.typeCombo.setItems(this.getAvailableDateTypeDisplayNames());
        this.typeCombo.setText(this.getDateTypeDisplayName(this.input.getDateTimeLevelType()));
        if (this.typeCombo.getSelectionIndex() > -1) {
            this.formatCombo.setItems(this.getFormatDisplayItems(this.getAvailableDateTypeNames().get(this.typeCombo.getSelectionIndex()).toString()));
        }
        this.formatCombo.add(NONE, 0);
        this.formatCombo.setText(this.getDateFormatDisplayName(this.input.getDateTimeLevelType(), this.input.getDateTimeFormat()));
    }

    private void createContentArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        new Label(content, 0).setText(Messages.getString("DateLevelDialog.Name"));
        this.nameText = new Text(content, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DateLevelDialog.this.checkOkButtonStatus();
            }
        });
        new Label(content, 0).setText(Messages.getString("DateLevelDialog.KeyField"));
        this.fieldText = new Text(content, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fieldText.setLayoutData((Object)gd);
        new Label(content, 0).setText(Messages.getString("DateLevelDialog.Type"));
        this.typeCombo = new Combo(content, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.typeCombo.setLayoutData((Object)gd);
        this.typeCombo.setVisibleItemCount(30);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateLevelDialog.this.checkOkButtonStatus();
                DateLevelDialog.this.formatCombo.setItems(new String[0]);
                DateLevelDialog.this.formatCombo.setItems(DateLevelDialog.this.getFormatDisplayItems(DateLevelDialog.this.getAvailableDateTypeNames().get(DateLevelDialog.this.typeCombo.getSelectionIndex()).toString()));
                DateLevelDialog.this.formatCombo.add(NONE, 0);
                DateLevelDialog.this.formatCombo.select(0);
            }
        });
        new Label(content, 0).setText(Messages.getString("DateLevelDialog.Format"));
        this.formatCombo = new Combo(content, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.formatCombo.setLayoutData((Object)gd);
        this.formatCombo.setVisibleItemCount(30);
        this.formatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateLevelDialog.this.checkOkButtonStatus();
            }
        });
        this.createSecurityPart(content);
        this.createHyperLinkPart(content);
    }

    private IDialogHelper createHyperLinkPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.cube, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper hyperLinkHelper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (hyperLinkHelper = helperProvider.createHelper((Object)this, "HyperLink Helper")) != null) {
                    hyperLinkHelper.setProperty("HyperLink Label", (Object)Messages.getString("DateLevelDialog.Label.LinkTo"));
                    hyperLinkHelper.setProperty("HyperLink Button Text", (Object)Messages.getString("DateLevelDialog.Button.Text.Edit"));
                    hyperLinkHelper.setProperty("HyperLink Report Item Handle", (Object)this.input);
                    hyperLinkHelper.createContent(parent);
                    hyperLinkHelper.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            hyperLinkHelper.update(false);
                        }
                    });
                    hyperLinkHelper.update(true);
                    return hyperLinkHelper;
                }
                ++i;
            }
        }
        return null;
    }

    private void createSecurityPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.cube, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && this.helper == null) {
                    this.helper = helperProvider.createHelper((Object)this, "Security Helper");
                    if (this.helper != null) {
                        this.helper.setProperty("Security Label", (Object)Messages.getString("DateLevelDialog.Access.Control.List.Expression"));
                        this.helper.setProperty("Security Expression Context", (Object)this.cube);
                        this.helper.setProperty("Security Expression Provider", (Object)new CubeExpressionProvider((DesignElementHandle)this.cube));
                        this.helper.setProperty("Security Expression Property", (Object)this.input.getACLExpression());
                        this.helper.createContent(parent);
                        this.helper.addListener(24, new Listener(){

                            public void handleEvent(Event event) {
                                DateLevelDialog.this.helper.update(false);
                            }
                        });
                        this.helper.update(true);
                    }
                }
                ++i;
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.checkOkButtonStatus();
    }

    protected void checkOkButtonStatus() {
        if (this.nameText.getText() == null || this.nameText.getText().trim().equals("") || this.typeCombo.getSelectionIndex() == -1 || this.formatCombo.getSelectionIndex() == -1) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("DateLevelDialog.Message.BlankName"));
        } else if (!UIUtil.validateDimensionName((String)this.nameText.getText())) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.NumericName"));
        } else {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(true);
            }
            this.setErrorMessage(null);
            this.setMessage(Messages.getString("DateLevelDialog.Message"));
        }
    }

    protected void okPressed() {
        try {
            if (this.nameText.getText() != null && !this.nameText.getText().trim().equals("")) {
                this.input.setName(this.nameText.getText());
            }
            if (this.typeCombo.getText() != null) {
                this.input.setDateTimeLevelType(this.getAvailableDateTypeNames().get(this.typeCombo.getSelectionIndex()).toString());
            }
            if (this.formatCombo.getText() != null) {
                if (this.formatCombo.getText().equals(NONE)) {
                    this.input.setDateTimeFormat(null);
                } else {
                    this.input.setDateTimeFormat(this.getFormatPatternItems(this.getAvailableDateTypeNames().get(this.typeCombo.getSelectionIndex()).toString())[this.formatCombo.getSelectionIndex() - 1]);
                }
            }
            if (this.helper != null) {
                this.input.setExpressionProperty("ACLExpression", (Expression)this.helper.getProperty("Security Expression Property"));
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
            return;
        }
        super.okPressed();
    }
}

