/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml.writer;

import java.text.Bidi;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.wpml.AbstractEmitterImpl;
import org.eclipse.birt.report.engine.emitter.wpml.DiagonalLineInfo;
import org.eclipse.birt.report.engine.emitter.wpml.HyperlinkInfo;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractWordXmlWriter {
    protected XMLWriter writer;
    protected final String RIGHT = "right";
    protected final String LEFT = "left";
    protected final String TOP = "top";
    protected final String BOTTOM = "bottom";
    protected int imageId = 75;
    protected int bookmarkId = 0;
    private int lineId = 0;
    protected boolean rtl = false;
    protected String[] bidiChunks = new String[0];
    protected int[] bidiLevels = new int[0];

    protected abstract void writeTableLayout();

    protected abstract void writeFontSize(IStyle var1);

    protected abstract void writeFont(String var1);

    protected abstract void writeFontStyle(IStyle var1);

    protected abstract void writeFontWeight(IStyle var1);

    protected abstract void openHyperlink(HyperlinkInfo var1);

    protected abstract void closeHyperlink(HyperlinkInfo var1);

    protected abstract void writeVmerge(SpanInfo var1);

    protected abstract void writeIndent(int var1);

    public void startSectionInParagraph() {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        this.startSection();
    }

    public void endSectionInParagraph() {
        this.endSection();
        this.writer.closeTag("w:pPr");
        this.writer.closeTag("w:p");
    }

    public void startSection() {
        this.writer.openTag("w:sectPr");
    }

    public void endSection() {
        this.writer.closeTag("w:sectPr");
    }

    protected void drawImageShapeType(int imageId) {
        this.writer.openTag("v:shapetype");
        this.writer.attribute("id", "_x0000_t" + imageId);
        this.writer.attribute("coordsize", "21600,21600");
        this.writer.attribute("o:spt", "75");
        this.writer.attribute("o:preferrelative", "t");
        this.writer.attribute("path", "m@4@5l@4@11@9@11@9@5xe");
        this.writer.attribute("filled", "f");
        this.writer.attribute("stroked", "f");
        this.writer.openTag("v:stroke");
        this.writer.attribute("imagealignshape", "false");
        this.writer.attribute("joinstyle", "miter");
        this.writer.closeTag("v:stroke");
        this.writer.openTag("v:formulas");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "if lineDrawn pixelLineWidth 0");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @0 1 0");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum 0 0 @1");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @2 1 2");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @3 21600 pixelWidth");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @3 21600 pixelHeight");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @0 0 1");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @6 1 2");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @7 21600 pixelWidth");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @8 21600 0 ");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @7 21600 pixelHeight");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @10 21600 0");
        this.writer.closeTag("v:f");
        this.writer.closeTag("v:formulas");
        this.writer.openTag("v:path");
        this.writer.attribute("o:extrusionok", "f");
        this.writer.attribute("gradientshapeok", "t");
        this.writer.attribute("o:connecttype", "rect");
        this.writer.closeTag("v:path");
        this.writer.openTag("o:lock");
        this.writer.attribute("v:ext", "edit");
        this.writer.attribute("aspectratio", "t");
        this.writer.closeTag("o:lock");
        this.writer.closeTag("v:shapetype");
    }

    protected void drawImageBordersStyle(IStyle style) {
        this.drawImageBorderStyle("bottom", style.getBorderBottomStyle(), style.getProperty(23));
        this.drawImageBorderStyle("top", style.getBorderTopStyle(), style.getProperty(6));
        this.drawImageBorderStyle("left", style.getBorderLeftStyle(), style.getProperty(31));
        this.drawImageBorderStyle("right", style.getBorderRightStyle(), style.getProperty(8));
    }

    private void drawImageBorderStyle(String pos, String style, CSSValue width) {
        String direct = "w10:border" + pos;
        this.writer.openTag(direct);
        this.writer.attribute("type", WordUtil.parseImageBorderStyle(style));
        this.writer.attribute("width", WordUtil.parseBorderSize(PropertyUtil.getDimensionValue((CSSValue)width)));
        this.writer.closeTag(direct);
    }

    protected void drawImageBordersColor(IStyle style) {
        this.drawImageBorderColor("bottom", style.getBorderBottomColor());
        this.drawImageBorderColor("top", style.getBorderTopColor());
        this.drawImageBorderColor("left", style.getBorderLeftColor());
        this.drawImageBorderColor("right", style.getBorderRightColor());
    }

    private void drawImageBorderColor(String pos, String color) {
        String borderColor = "#" + WordUtil.parseColor(color);
        String direct = "o:border" + pos + "color";
        this.writer.attribute(direct, borderColor);
    }

    public void writePageProperties(int pageHeight, int pageWidth, int headerHeight, int footerHeight, int topMargin, int bottomMargin, int leftMargin, int rightMargin, String orient) {
        this.writer.openTag("w:pgSz");
        this.writer.attribute("w:w", pageWidth);
        this.writer.attribute("w:h", pageHeight);
        this.writer.attribute("w:orient", orient);
        this.writer.closeTag("w:pgSz");
        this.writer.openTag("w:pgMar");
        this.writer.attribute("w:top", topMargin);
        this.writer.attribute("w:bottom", bottomMargin);
        this.writer.attribute("w:left", leftMargin);
        this.writer.attribute("w:right", rightMargin);
        this.writer.attribute("w:header", topMargin);
        this.writer.attribute("w:footer", bottomMargin);
        this.writer.closeTag("w:pgMar");
    }

    public void startTable(IStyle style, int tablewidth) {
        this.writer.openTag("w:tbl");
        this.writer.openTag("w:tblPr");
        this.writeTableIndent();
        this.writeAttrTag("w:tblStyle", "TableGrid");
        this.writeAttrTag("w:tblOverlap", "Never");
        this.writeBidiTable();
        this.writeTableWidth(tablewidth);
        this.writeAttrTag("w:tblLook", "01E0");
        this.writeTableLayout();
        this.writeTableBorders(style);
        this.writeBackgroundColor(style.getBackgroundColor());
        this.writeAlign(style.getTextAlign(), style.getDirection());
        this.writer.closeTag("w:tblPr");
    }

    private void writeTableBorders(IStyle style) {
        this.writer.openTag("w:tblBorders");
        this.writeBorders(style, 0, 0, 0, 0);
        this.writer.closeTag("w:tblBorders");
    }

    public void endTable() {
        this.writer.closeTag("w:tbl");
    }

    private void writeTableWidth(int tablewidth) {
        this.writer.openTag("w:tblW");
        this.writer.attribute("w:w", tablewidth);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tblW");
    }

    private void writeTableIndent() {
        this.writer.openTag("w:tblInd");
        this.writer.attribute("w:w", 0);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tblInd");
    }

    protected void writeBorders(IStyle style, int bottomMargin, int topMargin, int leftMargin, int rightMargin) {
        String borderStyle = style.getBorderBottomStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeSingleBorder("bottom", borderStyle, style.getBorderBottomColor(), style.getProperty(23), bottomMargin);
        }
        if (this.hasBorder(borderStyle = style.getBorderTopStyle())) {
            this.writeSingleBorder("top", borderStyle, style.getBorderTopColor(), style.getProperty(6), topMargin);
        }
        if (this.hasBorder(borderStyle = style.getBorderLeftStyle())) {
            this.writeSingleBorder("left", borderStyle, style.getBorderLeftColor(), style.getProperty(31), leftMargin);
        }
        if (this.hasBorder(borderStyle = style.getBorderRightStyle())) {
            this.writeSingleBorder("right", borderStyle, style.getBorderRightColor(), style.getProperty(8), rightMargin);
        }
    }

    private void writeSingleBorder(String type, String borderStyle, String color, CSSValue width, int margin) {
        this.writer.openTag("w:" + type);
        this.writeBorderProperty(borderStyle, color, width, margin);
        this.writer.closeTag("w:" + type);
    }

    private void writeBorderProperty(String style, String color, CSSValue width, int margin) {
        this.writer.attribute("w:val", WordUtil.parseBorderStyle(style));
        this.writer.attribute("w:sz", WordUtil.parseBorderSize(PropertyUtil.getDimensionValue((CSSValue)width)));
        this.writer.attribute("w:space", this.validateBorderSpace(margin));
        this.writer.attribute("w:color", WordUtil.parseColor(color));
    }

    private int validateBorderSpace(int margin) {
        int space = (int)WordUtil.twipToPt(margin);
        if (space > 31) {
            space = 31;
        }
        return space;
    }

    protected void writeAlign(String align, String direction) {
        if (align == null) {
            return;
        }
        String textAlign = align;
        if ("justify".equalsIgnoreCase(align)) {
            textAlign = "both";
        }
        if ("rtl".equalsIgnoreCase(direction)) {
            if ("right".equals(textAlign)) {
                this.writeAttrTag("w:jc", "left");
            } else if ("left".equals(textAlign)) {
                this.writeAttrTag("w:jc", "right");
            } else {
                this.writeAttrTag("w:jc", textAlign);
            }
        } else {
            this.writeAttrTag("w:jc", textAlign);
        }
    }

    protected void writeBackgroundColor(String color) {
        String cssColor = WordUtil.parseColor(color);
        if (cssColor == null) {
            return;
        }
        this.writer.openTag("w:shd");
        this.writer.attribute("w:val", "clear");
        this.writer.attribute("w:color", "auto");
        this.writer.attribute("w:fill", cssColor);
        this.writer.closeTag("w:shd");
    }

    private void writeBidiTable() {
        if (this.rtl) {
            this.writer.openTag("w:bidiVisual");
            this.writer.closeTag("w:bidiVisual");
        }
    }

    protected void writeRunBorders(IStyle style) {
        String borderStyle = style.getBorderTopStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeRunBorder(borderStyle, style.getBorderTopColor(), style.getProperty(6));
            return;
        }
        borderStyle = style.getBorderBottomStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeRunBorder(borderStyle, style.getBorderBottomColor(), style.getProperty(23));
            return;
        }
        borderStyle = style.getBorderLeftStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeRunBorder(borderStyle, style.getBorderLeftColor(), style.getProperty(31));
            return;
        }
        borderStyle = style.getBorderRightStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeRunBorder(borderStyle, style.getBorderRightColor(), style.getProperty(8));
            return;
        }
    }

    private boolean hasBorder(String borderStyle) {
        return borderStyle != null && !"none".equalsIgnoreCase(borderStyle);
    }

    private void writeRunBorder(String borderStyle, String color, CSSValue borderWidth) {
        this.writer.openTag("w:bdr");
        this.writeBorderProperty(borderStyle, color, borderWidth, 0);
        this.writer.closeTag("w:bdr");
    }

    private boolean needNewParagraph(String txt) {
        return "\n".equals(txt) || "\r".equalsIgnoreCase(txt) || "\r\n".equals(txt);
    }

    public void startParagraph(IStyle style, boolean isInline, int paragraphWidth) {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        this.writeSpacing(style.getProperty(2), style.getProperty(16));
        this.writeAlign(style.getTextAlign(), style.getDirection());
        int indent = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(21), (int)paragraphWidth) / 1000 * 20;
        if (indent != 0) {
            this.writeIndent(indent);
        }
        if (!isInline) {
            this.writeBackgroundColor(style.getBackgroundColor());
            this.writeParagraphBorders(style);
        }
        this.writer.closeTag("w:pPr");
    }

    private void writeSpacing(CSSValue height) {
        float spacingValue = PropertyUtil.getDimensionValue((CSSValue)height);
        int spacing = WordUtil.parseSpacing(spacingValue) / 2;
        this.writeSpacing(spacing, spacing);
    }

    private void writeSpacing(CSSValue top, CSSValue bottom) {
        float topSpacingValue = PropertyUtil.getDimensionValue((CSSValue)top);
        float bottomSpacingValue = PropertyUtil.getDimensionValue((CSSValue)bottom);
        this.writeSpacing(WordUtil.parseSpacing(topSpacingValue) / 2, WordUtil.parseSpacing(bottomSpacingValue) / 2);
    }

    private void writeSpacing(int beforeValue, int afterValue) {
        this.writer.openTag("w:spacing");
        this.writer.attribute("w:before", beforeValue);
        this.writer.attribute("w:after", afterValue);
        this.writer.closeTag("w:spacing");
    }

    protected void writeAutoText(int type) {
        this.writer.openTag("w:instrText");
        if (type == 1) {
            this.writer.text("PAGE");
        } else if (type == 0) {
            this.writer.text("NUMPAGES");
        }
        this.writer.closeTag("w:instrText");
    }

    private void writeString(String txt, IStyle style) {
        if (txt == null) {
            return;
        }
        if (style != null) {
            String textTransform = style.getTextTransform();
            if ("capitalize".equalsIgnoreCase(textTransform)) {
                txt = WordUtil.capitalize(txt);
            } else if ("uppercase".equalsIgnoreCase(textTransform)) {
                txt = txt.toUpperCase();
            } else if ("lowercase".equalsIgnoreCase(textTransform)) {
                txt = txt.toLowerCase();
            }
        }
        this.writer.openTag("w:t");
        boolean notFirst = false;
        String[] stringArray = txt.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            String row = "<![CDATA[" + st + "]]>";
            if (notFirst) {
                row = "<w:br/>" + row;
            } else {
                notFirst = true;
            }
            this.writer.cdata(row);
            ++n2;
        }
        this.writer.closeTag("w:t");
    }

    private void writeLetterSpacing(IStyle style) {
        int letterSpacing = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(56));
        this.writeAttrTag("w:spacing", WordUtil.parseSpacing(letterSpacing));
    }

    private void writeHyperlinkStyle(boolean isHyperlink, IStyle style) {
        if (isHyperlink) {
            this.writeAttrTag("w:rStyle", "Hyperlink");
        } else {
            this.writeTextUnderline(style);
            this.writeTextColor(style);
        }
    }

    protected void writeTocText(String tocText, int level) {
        this.writer.openTag("w:r");
        this.writer.openTag("w:instrText");
        this.writer.text(" TC \"" + tocText + "\"" + " \\f C \\l \"" + String.valueOf(level) + "\"");
        this.writer.closeTag("w:instrText");
        this.writer.closeTag("w:r");
    }

    protected void writeBidi(boolean rtl) {
        if (rtl) {
            this.writer.openTag("w:bidi");
            this.writer.closeTag("w:bidi");
        } else {
            this.writeAttrTag("w:bidi", "off");
        }
    }

    protected void writeField(boolean isStart) {
        String fldCharType = isStart ? "begin" : "end";
        this.writer.openTag("w:r");
        this.writer.openTag("w:fldChar");
        this.writer.attribute("w:fldCharType", fldCharType);
        this.writer.closeTag("w:fldChar");
        this.writer.closeTag("w:r");
    }

    public void writeColumn(int[] cols) {
        this.writer.openTag("w:tblGrid");
        int i = 0;
        while (i < cols.length) {
            this.writeAttrTag("w:gridCol", cols[i]);
            ++i;
        }
        this.writer.closeTag("w:tblGrid");
    }

    public void startTableRow(double height, boolean isHeader, boolean repeatHeader, boolean fixedLayout) {
        this.writer.openTag("w:tr");
        this.writer.openTag("w:trPr");
        if (height != -1.0) {
            this.writer.openTag("w:trHeight");
            if (fixedLayout) {
                this.writer.attribute("w:h-rule", "exact");
            }
            this.writer.attribute("w:val", height);
            this.writer.closeTag("w:trHeight");
        }
        if (isHeader) {
            String headerOnOff = repeatHeader ? "on" : "off";
            this.writeAttrTag("w:tblHeader", headerOnOff);
        }
        this.writer.closeTag("w:trPr");
    }

    public void endTableRow() {
        this.writer.closeTag("w:tr");
    }

    public void startTableCell(int width, IStyle style, SpanInfo spanInfo) {
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writeCellWidth(width);
        if (spanInfo != null) {
            this.writeGridSpan(spanInfo);
            this.writeVmerge(spanInfo);
        }
        this.writeCellProperties(style);
        this.writer.closeTag("w:tcPr");
        String align = style.getTextAlign();
        if (align == null) {
            return;
        }
        String direction = style.getDirection();
        if ("left".equals(align) && !"rtl".equals(direction)) {
            return;
        }
        this.writer.openTag("w:pPr");
        this.writeAlign(align, direction);
        this.writer.closeTag("w:pPr");
    }

    private void writeCellWidth(int width) {
        this.writer.openTag("w:tcW");
        this.writer.attribute("w:w", width);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tcW");
    }

    private void writeGridSpan(SpanInfo spanInfo) {
        int columnSpan = spanInfo.getColumnSpan();
        if (columnSpan > 1) {
            this.writeAttrTag("w:gridSpan", columnSpan);
        }
    }

    public void writeSpanCell(SpanInfo info) {
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writeCellWidth(info.getCellWidth());
        this.writeGridSpan(info);
        this.writeVmerge(info);
        this.writeCellProperties(info.getStyle());
        this.writer.closeTag("w:tcPr");
        this.insertHiddenParagraph();
        this.writer.closeTag("w:tc");
    }

    public void endTableCell(boolean empty) {
        if (empty) {
            this.insertHiddenParagraph();
        }
        this.writer.closeTag("w:tc");
    }

    public void writeEmptyCell() {
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writer.openTag("w:tcW");
        this.writer.attribute("w:w", 0);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tcW");
        this.writer.closeTag("w:tcPr");
        this.insertHiddenParagraph();
        this.writer.closeTag("w:tc");
    }

    public void insertHiddenParagraph() {
        this.writer.openTag("w:p");
        this.writeHiddenProperty();
        this.writer.closeTag("w:p");
    }

    public void writeHiddenProperty() {
        this.writer.openTag("w:rPr");
        this.writeAttrTag("w:vanish", "on");
        this.writer.closeTag("w:rPr");
    }

    public void endParagraph() {
        this.writer.closeTag("w:p");
    }

    public void writeCaption(String txt) {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        this.writeAlign("center", null);
        this.writer.closeTag("w:pPr");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writeString(txt, null);
        this.writer.closeTag("w:rPr");
        this.writer.closeTag("w:r");
        this.writer.closeTag("w:p");
    }

    private void writeCellProperties(IStyle style) {
        if (style == null) {
            return;
        }
        this.writeBackgroundColor(style.getBackgroundColor());
        this.writeCellBorders(style);
        String verticalAlign = style.getVerticalAlign();
        if (verticalAlign != null) {
            this.writeAttrTag("w:vAlign", WordUtil.parseVerticalAlign(verticalAlign));
        }
        String noWrap = "nowrap".equalsIgnoreCase(style.getWhiteSpace()) ? "on" : "off";
        this.writeAttrTag("w:noWrap", noWrap);
    }

    private void writeCellBorders(IStyle style) {
        this.writer.openTag("w:tcBorders");
        this.writeBorders(style, 0, 0, 0, 0);
        this.writer.closeTag("w:tcBorders");
    }

    protected void buildBidiChunks(String text, boolean rtl) {
        Bidi bidiObj = new Bidi(text, rtl ? 1 : 0);
        int nRuns = bidiObj.getRunCount();
        if (nRuns != this.bidiChunks.length) {
            this.bidiChunks = new String[nRuns];
            this.bidiLevels = new int[nRuns];
        }
        int i = 0;
        while (i < nRuns) {
            this.bidiChunks[i] = text.substring(bidiObj.getRunStart(i), bidiObj.getRunLimit(i));
            this.bidiLevels[i] = bidiObj.getRunLevel(i) & 1;
            ++i;
        }
    }

    protected void writeAttrTag(String name, String val) {
        this.writer.openTag(name);
        this.writer.attribute("w:val", val);
        this.writer.closeTag(name);
    }

    protected void writeAttrTag(String name, int val) {
        this.writer.openTag(name);
        this.writer.attribute("w:val", val);
        this.writer.closeTag(name);
    }

    protected void writeAttrTag(String name, double val) {
        this.writer.openTag(name);
        this.writer.attribute("w:val", val);
        this.writer.closeTag(name);
    }

    protected int getImageID() {
        return this.imageId++;
    }

    private void writeTextInParagraph(int type, String txt, IStyle style, String fontFamily, HyperlinkInfo info, int paragraphWidth) {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        CSSValue lineHeight = style.getProperty(22);
        if (!"normal".equalsIgnoreCase(lineHeight.getCssText())) {
            this.writeSpacing(lineHeight);
        }
        this.writeAlign(style.getTextAlign(), style.getDirection());
        this.writeBackgroundColor(style.getBackgroundColor());
        this.writeParagraphBorders(style);
        int indent = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(21), (int)(paragraphWidth * 1000)) / 1000 * 20;
        if (indent != 0) {
            this.writeIndent(indent);
        }
        this.writer.closeTag("w:pPr");
        this.writeTextInRun(type, txt, style, fontFamily, info, false, paragraphWidth);
    }

    private void writeParagraphBorders(IStyle style) {
        this.writer.openTag("w:pBdr");
        this.writeBorders(style, 0, 0, 0, 0);
        this.writer.closeTag("w:pBdr");
    }

    public void writeText(int type, String txt, IStyle style, String fontFamily, HyperlinkInfo info, AbstractEmitterImpl.TextFlag flag, int paragraphWidth) {
        if (flag == AbstractEmitterImpl.TextFlag.START) {
            this.writeTextInParagraph(type, txt, style, fontFamily, info, paragraphWidth);
        } else if (flag == AbstractEmitterImpl.TextFlag.END) {
            this.writer.closeTag("w:p");
        } else if (flag == AbstractEmitterImpl.TextFlag.MIDDLE) {
            this.writeTextInRun(type, txt, style, fontFamily, info, false, paragraphWidth);
        } else {
            this.writeTextInParagraph(type, txt, style, fontFamily, info, paragraphWidth);
            this.writer.closeTag("w:p");
        }
    }

    public void writeTextInRun(int type, String txt, IStyle style, String fontFamily, HyperlinkInfo info, boolean isInline, int paragraphWidth) {
        if ("".equals(txt)) {
            return;
        }
        if (this.needNewParagraph(txt)) {
            this.writer.closeTag("w:p");
            this.startParagraph(style, isInline, paragraphWidth);
            return;
        }
        this.openHyperlink(info);
        boolean isField = WordUtil.isField(type);
        String direction = style.getDirection();
        boolean textIsRtl = "rtl".equals(direction);
        int nChunks = isField ? 1 : 0;
        this.writer.openTag("w:pPr");
        this.writeBidi(textIsRtl);
        this.writer.closeTag("w:pPr");
        if (isField) {
            this.writeField(true);
        } else {
            this.buildBidiChunks(txt, textIsRtl);
            nChunks = this.bidiChunks.length;
            assert (nChunks > 0);
        }
        int i = 0;
        while (i < nChunks) {
            this.writer.openTag("w:r");
            this.writer.openTag("w:rPr");
            this.writeRunProperties(style, fontFamily, info != null);
            if (isInline) {
                this.writeAlign(style.getTextAlign(), direction);
                this.writeBackgroundColor(style.getBackgroundColor());
                this.writePosition(style.getVerticalAlign(), style.getProperty(44));
                this.writeRunBorders(style);
            }
            if (!isField && this.bidiLevels[i] == 1) {
                this.writer.openTag("w:rtl");
                this.writer.closeTag("w:rtl");
            }
            this.writer.closeTag("w:rPr");
            if (isField) {
                this.writeAutoText(type);
            } else {
                this.writeString(this.bidiChunks[i], style);
            }
            this.writer.closeTag("w:r");
            ++i;
        }
        if (isField) {
            this.writeField(false);
        }
        this.closeHyperlink(info);
    }

    private void writePosition(String verticalAlign, CSSValue fontSize) {
        int size = WordUtil.parseFontSize(PropertyUtil.getDimensionValue((CSSValue)fontSize));
        if ("top".equalsIgnoreCase(verticalAlign)) {
            this.writeAttrTag("w:position", size * 1 / 3);
        } else if ("bottom".equalsIgnoreCase(verticalAlign)) {
            this.writeAttrTag("w:position", -size * 1 / 3);
        }
    }

    protected void writeRunProperties(IStyle style, String fontFamily, boolean ishyperlink) {
        this.writeHyperlinkStyle(ishyperlink, style);
        this.writeFont(fontFamily);
        this.writeFontSize(style);
        this.writeLetterSpacing(style);
        this.writeTextLineThrough(style);
        this.writeFontStyle(style);
        this.writeFontWeight(style);
    }

    private void writeTextColor(IStyle style) {
        String val = WordUtil.parseColor(style.getColor());
        if (val != null) {
            this.writeAttrTag("w:color", val);
        }
    }

    private void writeTextUnderline(IStyle style) {
        String val = WordUtil.removeQuote(style.getTextUnderline());
        if (!"none".equalsIgnoreCase(val)) {
            this.writeAttrTag("w:u", "single");
        }
    }

    private void writeTextLineThrough(IStyle style) {
        String val = WordUtil.removeQuote(style.getTextLineThrough());
        if (!"none".equalsIgnoreCase(val)) {
            this.writeAttrTag("w:strike", "on");
        }
    }

    protected void startHeaderFooterContainer(int headerHeight, int headerWidth) {
        this.writer.openTag("w:tbl");
        this.writer.openTag("w:tblPr");
        this.writeTableWidth(headerWidth);
        this.writeAttrTag("w:tblLook", "01E0");
        this.writeTableLayout();
        this.writer.closeTag("w:tblPr");
        this.writer.openTag("w:tr");
        this.writer.openTag("w:trPr");
        this.writeAttrTag("w:trHeight", headerHeight);
        this.writer.closeTag("w:trPr");
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writeCellWidth(headerWidth);
        this.writer.closeTag("w:tcPr");
    }

    protected void endHeaderFooterContainer() {
        this.insertHiddenParagraph();
        this.writer.closeTag("w:tc");
        this.writer.closeTag("w:tr");
        this.writer.closeTag("w:tbl");
    }

    public void drawDiagonalLine(DiagonalLineInfo diagonalLineInfo) {
        if (diagonalLineInfo.getDiagonalNumber() <= 0 && diagonalLineInfo.getAntiDiagonalNumber() <= 0) {
            return;
        }
        this.writer.openTag("w:p");
        this.writeHiddenProperty();
        this.writer.openTag("w:r");
        this.writer.openTag("w:pict");
        double diagonalLineWidth = diagonalLineInfo.getDiagonalLineWidth();
        String diagonalLineStyle = diagonalLineInfo.getDiagonalStyle();
        double antidiagonalLineWidth = diagonalLineInfo.getAntiDiagonalLineWidth();
        String antidiagonalLineStyle = diagonalLineInfo.getAntiDiagonalStyle();
        String lineColor = diagonalLineInfo.getColor();
        for (DiagonalLineInfo.Line line : diagonalLineInfo.getDiagonalLine()) {
            this.drawLine(diagonalLineWidth, diagonalLineStyle, lineColor, line);
        }
        for (DiagonalLineInfo.Line antiLine : diagonalLineInfo.getAntidiagonalLine()) {
            this.drawLine(antidiagonalLineWidth, antidiagonalLineStyle, lineColor, antiLine);
        }
        this.writer.closeTag("w:pict");
        this.writer.closeTag("w:r");
        this.writer.closeTag("w:p");
    }

    private void drawLine(double width, String style, String color, DiagonalLineInfo.Line line) {
        this.writer.openTag("v:line");
        this.writer.attribute("id", "Line" + this.getLineId());
        this.writer.attribute("style", "position:absolute;left:0;text-align:left;z-index:1");
        this.writer.attribute("from", String.valueOf(line.getXCoordinateFrom()) + "pt," + line.getYCoordinateFrom() + "pt");
        this.writer.attribute("to", String.valueOf(line.getXCoordinateTo()) + "pt," + line.getYCoordinateTo() + "pt");
        this.writer.attribute("strokeweight", String.valueOf(width) + "pt");
        this.writer.attribute("strokecolor", "#" + color);
        this.writer.openTag("v:stroke");
        this.writer.attribute("dashstyle", WordUtil.parseLineStyle(style));
        this.writer.closeTag("v:stroke");
        this.writer.closeTag("v:line");
    }

    private int getLineId() {
        return this.lineId++;
    }
}

