/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.UseCssInThemeDialog;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportResourceEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ResourceEntryWrapper;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

public class UseCssInThemeAction
extends Action {
    private LibraryExplorerTreeViewPage viewer;
    private static final String ACTION_TEXT = Messages.getString((String)"UseCssInThemeAction.Text");

    public UseCssInThemeAction(LibraryExplorerTreeViewPage page) {
        super(ACTION_TEXT);
        this.viewer = page;
    }

    public boolean isEnabled() {
        ModuleHandle obj = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (obj == null || !(obj instanceof LibraryHandle)) {
            return false;
        }
        LibraryHandle moduleHandle = (LibraryHandle)obj;
        CssStyleSheetHandle cssHandle = this.getSelectedCssStyleHandle();
        if (cssHandle == null) {
            return false;
        }
        SlotHandle slotHandle = moduleHandle.getThemes();
        for (ThemeHandle theme : slotHandle) {
            if (!theme.canAddCssStyleSheet(cssHandle)) continue;
            return true;
        }
        return false;
    }

    private CssStyleSheetHandle getSelectedCssStyleHandle() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null && selection.size() == 1) {
            Object selected = selection.getFirstElement();
            if (selected instanceof CssStyleSheetHandle) {
                return (CssStyleSheetHandle)selected;
            }
            if (selected instanceof ReportResourceEntry && ((ReportResourceEntry)selected).getReportElement() instanceof CssStyleSheetHandle) {
                return (CssStyleSheetHandle)((ReportResourceEntry)selected).getReportElement();
            }
            if (selected instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)selected).getType() == 1) {
                return (CssStyleSheetHandle)((ResourceEntryWrapper)selected).getAdapter(CssStyleSheetHandle.class);
            }
        }
        return null;
    }

    public void run() {
        CssStyleSheetHandle cssHandle = this.getSelectedCssStyleHandle();
        UseCssInThemeDialog dialog = new UseCssInThemeDialog();
        String relativeFileName = cssHandle.getFileName();
        dialog.setFileName(relativeFileName);
        if (dialog.open() == 0) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(ACTION_TEXT);
            ThemeHandle themeHandle = dialog.getTheme();
            try {
                IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
                css.setFileName(dialog.getFileName());
                css.setExternalCssURI(dialog.getURI());
                themeHandle.addCss(css);
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
                stack.rollback();
                return;
            }
            stack.commit();
        }
    }
}

